/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.common.constants.TaxFileConstants;
import kd.sit.sitbp.common.enums.EmpTypeEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbp.common.util.SitDateUtil;
import org.apache.commons.lang3.StringUtils;

public class EmploymentSaveValidator
extends AbstractValidator {
    protected static final Log logger = LogFactory.getLog(EmploymentSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), logger);

    public void validate() {
        this.effectLogger.start("EmploymentSaveValidator validate");
        this.dealData();
        this.effectLogger.end("EmploymentSaveValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        List<ExtendedDataEntity> entityList = Arrays.stream(this.getDataEntities()).collect(Collectors.toList());
        List employmentIds = entityList.stream().map(entity -> entity.getDataEntity().getLong("id")).collect(Collectors.toList());
        logger.info("EmploymentSaveValidator current employmentIds: {}", employmentIds);
        for (ExtendedDataEntity dataEntity : entityList) {
            DynamicObject employObject = dataEntity.getDataEntity();
            employObject.set("bsled", null);
        }
        this.validateNormalField(entityList);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        this.validateAboutFile(entityList);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        this.validateAboutEmploy(entityList);
    }

    private void validateNormalField(List<ExtendedDataEntity> entityList) {
        Iterator<ExtendedDataEntity> employIterator = entityList.iterator();
        while (employIterator.hasNext()) {
            ExtendedDataEntity dataEntity = employIterator.next();
            DynamicObject employObject = dataEntity.getDataEntity();
            long empTypeId = employObject.getLong("emptype.id");
            Date empDate = employObject.getDate("empdate");
            Date quitDate = employObject.getDate("quitdate");
            Date employBsed = employObject.getDate("bsed");
            if (empTypeId != 0L && empDate == null && empTypeId != EmpTypeEnum.EMP_TYPE_1050.getId()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u804c\u53d7\u96c7\u65e5\u671f\u3002", (String)"EmploymentSaveValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                employIterator.remove();
                continue;
            }
            String empSituation = employObject.getString("empsituation");
            if (!HRStringUtils.isEmpty((String)empSituation) && (empTypeId != EmpTypeEnum.EMP_TYPE_1010.getId() && empTypeId != EmpTypeEnum.EMP_TYPE_1020.getId() && empTypeId != EmpTypeEnum.EMP_TYPE_1030.getId() || empDate == null || empDate.before(TaxFileConstants.START_EMPDATE))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u7c7b\u578b\u4e3a\u201c\u96c7\u5458\u201d\u3001\u201c\u4fdd\u9669\u8425\u9500\u5458\u201d\u3001\u201c\u8bc1\u5238\u7ecf\u7eaa\u4eba\u201d\uff0c\u4e14\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e2020\u5e747\u6708\u65f6\u53ef\u586b\u5199\u5165\u804c\u5e74\u5ea6\u5c31\u4e1a\u60c5\u5f62\u3002", (String)"EmploymentSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                employIterator.remove();
                continue;
            }
            if (quitDate == null) continue;
            if (empDate != null && quitDate.before(empDate)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u79bb\u804c\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4efb\u804c\u53d7\u96c7\u65e5\u671f\u3002", (String)"EmploymentSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                employIterator.remove();
                continue;
            }
            if (employBsed == null || !employBsed.after(quitDate)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u79bb\u804c\u65e5\u671f\u3002", (String)"EmploymentSaveValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            employIterator.remove();
        }
    }

    private void validateAboutEmploy(List<ExtendedDataEntity> entityList) {
        Set<Long> fileBoIds = this.getFileBoIds(entityList);
        if (CollectionUtils.isEmpty(fileBoIds)) {
            return;
        }
        Map<Long, List<DynamicObject>> allEmployMap = this.getEmploymentMap(fileBoIds);
        if (CollectionUtils.isEmpty(allEmployMap)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : entityList) {
            DynamicObject employObject = dataEntity.getDataEntity();
            Date bsed = employObject.getDate("bsed");
            long fileBoId = employObject.getLong("taxfile.boid");
            List<DynamicObject> allEmployObjs = allEmployMap.get(fileBoId);
            if (!CollectionUtils.isEmpty(allEmployObjs)) continue;
        }
    }

    private DynamicObject getFirstQuitDateObj(List<DynamicObject> allEmployObjs) {
        for (DynamicObject oldEmployObj : allEmployObjs) {
            if (oldEmployObj.getDate("quitdate") == null) continue;
            return oldEmployObj;
        }
        return allEmployObjs.get(0);
    }

    private Map<Long, List<DynamicObject>> getEmploymentMap(Set<Long> taxFileIds) {
        HRBaseServiceHelper employHelper = new HRBaseServiceHelper("itc_employment");
        QFilter employFilter = new QFilter("taxfile.boid", "in", taxFileIds);
        employFilter.and("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        DynamicObject[] allEmployObjs = employHelper.query("taxfile,bsed,datastatus,quitdate", new QFilter[]{employFilter}, "quitdate asc");
        HashMap allEmployMap = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        for (DynamicObject employObj : allEmployObjs) {
            long taxFileId = employObj.getLong("taxfile.boid");
            allEmployMap.computeIfAbsent(taxFileId, key -> new LinkedList()).add(employObj);
        }
        return allEmployMap;
    }

    private void validateAboutFile(List<ExtendedDataEntity> entityList) {
        Set<Long> fileBoIds = this.getFileBoIds(entityList);
        Map fileMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(fileBoIds)) {
            fileMap = SitCommonServiceHelper.getTaxFileEffectRecords(fileBoIds);
        }
        Iterator<ExtendedDataEntity> employIterator = entityList.iterator();
        while (employIterator.hasNext()) {
            ExtendedDataEntity dataEntity = employIterator.next();
            DynamicObject employObject = dataEntity.getDataEntity();
            logger.info("EmploymentSaveValidator validateAboutFile current employmentId: {}", (Object)employObject.getLong("id"));
            long fileBoId = employObject.getLong("taxfile.boid");
            Date quitDate = employObject.getDate("quitdate");
            long empTypeId = employObject.getLong("emptype.id");
            Date employBsed = employObject.getDate("bsed");
            Date fileFirstBsed = employObject.getDate("taxfile.bsed");
            List fileList = (List)fileMap.get(fileBoId);
            if (!CollectionUtils.isEmpty((Collection)fileList)) {
                String bsedStr;
                Date quitTaxBsed = null;
                boolean quitTaxFlag = false;
                boolean firstBsedFlag = true;
                if (!CollectionUtils.isEmpty((Collection)fileList)) {
                    for (DynamicObject fileObj : fileList) {
                        String taxStatus = fileObj.getString("taxstatus");
                        if (firstBsedFlag) {
                            fileFirstBsed = fileObj.getDate("bsed");
                            firstBsedFlag = false;
                        }
                        Date maxDate = this.getMaxDate();
                        Date employBsled = employObject.getDate("bsled") == null ? maxDate : employObject.getDate("bsled");
                        if (!SitDateUtil.isDateRangeOverlap((Date)employBsed, (Date)employBsled, (Date)fileObj.getDate("bsed"), (Date)fileObj.getDate("bsled")) || !HRStringUtils.equals((String)"0", (String)taxStatus)) continue;
                        logger.info("EmploymentSaveValidator validateAboutFil fileid{}", (Object)fileObj.getLong("id"));
                        quitTaxBsed = fileObj.getDate("bsed");
                        quitTaxFlag = true;
                        break;
                    }
                }
                if (quitDate == null && empTypeId != EmpTypeEnum.EMP_TYPE_1050.getId() && quitTaxFlag) {
                    bsedStr = SITInteDateTimeUtil.formatDate((String)"itc_taxfile", (String)"bsed", quitTaxBsed);
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u6863\u6848\u505c\u6b62\u7b97\u7a0e\u65e5\u671f\u4e3a{0}\uff0c\u8bf7\u7ef4\u62a4\u79bb\u804c\u65e5\u671f\u3002", (String)"EmploymentSaveValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]), bsedStr));
                    logger.info("EmploymentSaveValidator_5");
                    employIterator.remove();
                    continue;
                }
                if (quitDate != null && quitTaxFlag && quitTaxBsed != null && quitDate.after(quitTaxBsed)) {
                    bsedStr = SITInteDateTimeUtil.formatDate((String)"itc_taxfile", (String)"bsed", quitTaxBsed);
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u79bb\u804c\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u6863\u6848\u57fa\u7840\u4fe1\u606f\u4e2d\u505c\u6b62\u7b97\u7a0e\u7684\u751f\u6548\u65e5\u671f{0}\u3002", (String)"EmploymentSaveValidator_7", (String)"sit-itc-opplugin", (Object[])new Object[0]), bsedStr));
                    employIterator.remove();
                    continue;
                }
            }
            OperateOption operateOption = this.getOption();
            String src = operateOption.getVariableValue("src", "");
            if (fileFirstBsed == null || employBsed == null || !employBsed.before(fileFirstBsed) || StringUtils.endsWithIgnoreCase((CharSequence)src, (CharSequence)"SYNAPI")) continue;
            String bsedStr = SITInteDateTimeUtil.formatDate((String)"itc_taxfile", (String)"bsed", (Date)fileFirstBsed);
            this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f{0}\u3002", (String)"EmploymentSaveValidator_6", (String)"sit-itc-opplugin", (Object[])new Object[0]), bsedStr));
            employIterator.remove();
        }
    }

    private Set<Long> getFileBoIds(List<ExtendedDataEntity> entityList) {
        HashSet fileBoIds = Sets.newHashSetWithExpectedSize((int)entityList.size());
        for (ExtendedDataEntity dataEntity : entityList) {
            DynamicObject employObj = dataEntity.getDataEntity();
            long fileBoId = employObj.getLong("taxfile.boid");
            if (fileBoId == 0L) continue;
            fileBoIds.add(fileBoId);
        }
        return fileBoIds;
    }

    private Date getMaxDate() {
        Date maxDate = null;
        try {
            maxDate = HRDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return maxDate;
    }
}

