/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.common.model.EffectLogger;
import org.apache.commons.lang3.StringUtils;

public class InvestorSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(InvestorSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);

    public void validate() {
        this.effectLogger.start("InvestorSaveValidator validate");
        this.dealData();
        this.effectLogger.end("InvestorSaveValidator validate");
    }

    private void dealData() {
        ExtendedDataEntity[] dataEntities;
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.validateFields(dataEntity);
        }
    }

    private void validateFields(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        BigDecimal investTotal = dynamicObject.getBigDecimal("investtotal");
        BigDecimal investRatio = dynamicObject.getBigDecimal("investratio");
        Object duty = dynamicObject.get("duty");
        if (duty == null && investTotal.compareTo(BigDecimal.ZERO) == 0 && investRatio.compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u80a1\u4e1c\u6295\u8d44\u8005\u4fe1\u606f\u201d\u3002", (String)"InvestorSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (investTotal.scale() > 2) {
            dynamicObject.set("investtotal", (Object)investTotal.setScale(2, 4));
        }
        if (investTotal.compareTo(BigDecimal.ZERO) > 0) {
            if (investRatio.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e2a\u4eba\u6295\u8d44\u6bd4\u4f8b\uff08%\uff09\u201d\u3002", (String)"InvestorSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            } else if (investRatio.divide(BigDecimal.valueOf(100L)).compareTo(BigDecimal.ONE) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u51990~100\u7684\u6570\u5b57\u3002", (String)"InvestorSaveValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

