/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.common.constants.TaxFileConstants;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.SITFormatUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OverseasPersonSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(OverseasPersonSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);

    public void validate() {
        this.effectLogger.start("OverseasPersonSaveValidator validate");
        this.dealData();
        this.effectLogger.end("OverseasPersonSaveValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, DynamicObject> employmentDyObjs = this.getEmploymentDyObjs(dataEntities);
        Set boids = Arrays.stream(dataEntities).map(entity -> entity.getDataEntity().getLong("taxfile.id")).collect(Collectors.toSet());
        Map taxFileFirstEffectRecords = SitCommonServiceHelper.getTaxFileFirstEffectRecords(boids);
        String keyInfoStr = this.getOption().getVariableValue("relateFileKeyInfo", "{}");
        Map relateFileKeyInfo = (Map)SerializationUtils.fromJsonString((String)keyInfoStr, Map.class);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long taxFileId = dataEntity.getDataEntity().getLong("taxfile.id");
            DynamicObject employmentDyOb = employmentDyObjs.get(taxFileId);
            Date date = (Date)taxFileFirstEffectRecords.get(taxFileId);
            if (date == null) {
                date = dataEntity.getDataEntity().getDate("taxfile.bsed");
            }
            Map cacheInfos = null;
            if (relateFileKeyInfo != null) {
                String fileIdStr = String.valueOf(taxFileId);
                cacheInfos = relateFileKeyInfo.get(fileIdStr) != null ? (Map)relateFileKeyInfo.get(fileIdStr) : null;
            }
            this.validateFields(dataEntity, employmentDyOb, date, cacheInfos);
        }
    }

    private void validateFields(ExtendedDataEntity dataEntity, DynamicObject employmentDyObj, Date firstBsedDate, Map<String, Object> cacheInfos) {
        String errorMsg;
        String message;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String addressId = dynamicObject.getString("address.id");
        String addressCityId = dynamicObject.getString("addresscity.id");
        Object taxReason = dynamicObject.get("taxreason");
        String addressCountyId = dynamicObject.getString("addresscounty.id");
        String addressInfo = dynamicObject.getString("addressinfo");
        Date firstEntryDate = dynamicObject.getDate("firstentrydate");
        Date departDate = dynamicObject.getDate("departdate");
        String chineseName = dynamicObject.getString("chinesename");
        Object otherIdType = dynamicObject.get("otheridtype");
        String otherIdNumber = dynamicObject.getString("otheridnumber");
        Object birthPlace = dynamicObject.get("birthplace");
        Date bsed = dynamicObject.getDate("bsed");
        Long empTypeId = null;
        Long credentialsTypeId = 0L;
        if (cacheInfos != null) {
            Object credentialsType;
            Object emptypeMap = cacheInfos.get("itc_employment.emptype");
            if (emptypeMap != null) {
                empTypeId = MapUtils.getLong((Map)((Map)emptypeMap), (Object)"id");
            }
            if ((credentialsType = cacheInfos.get("credentialstype")) == null) {
                credentialsType = cacheInfos.get("iit_person.credentialstype");
            }
            if (credentialsType != null) {
                credentialsTypeId = ((Map)credentialsType).get("id") != null ? Long.parseLong(((Map)credentialsType).get("id").toString()) : 0L;
            }
        }
        if ((empTypeId == null || empTypeId == 0L) && employmentDyObj != null) {
            empTypeId = employmentDyObj.getLong("emptype.id");
        }
        if (CredentialsTypeEnum.isId1010((long)credentialsTypeId)) {
            String message2 = ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u4e2d\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\uff0c\u65e0\u9700\u586b\u5199\u5883\u5916\u4eba\u5458\u4fe1\u606f\u3002", (String)"OverseasPersonSaveValidator_14", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, message2);
            return;
        }
        if (Objects.isNull(otherIdType) && !HRStringUtils.isEmpty((String)otherIdNumber)) {
            message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5176\u4ed6\u8bc1\u4ef6\u7c7b\u578b\u3002", (String)"OverseasPersonSaveValidator_12", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (!(HRStringUtils.isEmpty((String)addressId) && HRStringUtils.isEmpty((String)addressCityId) || !HRStringUtils.isEmpty((String)addressInfo))) {
            message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8054\u7cfb\u5730\u5740\uff08\u8be6\u7ec6\u5730\u5740\uff09\u201d\u3002", (String)"OverseasPersonSaveValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (!HRStringUtils.isEmpty((String)addressInfo) && (HRStringUtils.isEmpty((String)addressId) || HRStringUtils.isEmpty((String)addressCityId))) {
            message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8054\u7cfb\u5730\u5740\uff08\u7701\uff09\uff0c\u8054\u7cfb\u5730\u5740\uff08\u5e02\uff09\u3002", (String)"OverseasPersonSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (null != firstEntryDate && null != departDate && HRDateTimeUtils.dayBefore((Date)departDate, (Date)firstEntryDate)) {
            message = ResManager.loadKDString((String)"\u9884\u8ba1\u79bb\u5883\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u9996\u6b21\u5165\u5883\u65e5\u671f\u3002", (String)"OverseasPersonSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (!(null == firstEntryDate && null == departDate && HRStringUtils.isEmpty((String)chineseName) && ObjectUtils.isEmpty((Object)otherIdType) && HRStringUtils.isEmpty((String)otherIdNumber) && ObjectUtils.isEmpty((Object)birthPlace) && HRStringUtils.isEmpty((String)addressId) && HRStringUtils.isEmpty((String)addressCityId) && HRStringUtils.isEmpty((String)addressInfo) || null != bsed)) {
            message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"OverseasPersonSaveValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
        if (credentialsTypeId != 0L && !CredentialsTypeEnum.isId1010((long)credentialsTypeId)) {
            if (ObjectUtils.isEmpty((Object)taxReason) || ObjectUtils.isEmpty((Object)birthPlace)) {
                message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6d89\u7a0e\u4e8b\u7531\u201d\u53ca\u201c\u51fa\u751f\u5730\uff08\u7a0e\u5c40\uff09\u201d\u3002", (String)"OverseasPersonSaveValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
            if (empTypeId != null && empTypeId.equals(TaxFileConstants.EMPTYPE_1010) && (null == firstEntryDate || null == departDate)) {
                message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9996\u6b21\u5165\u5883\u65e5\u671f\u201d\u53ca\u201c\u9884\u8ba1\u79bb\u5883\u65e5\u671f\u201d\u3002", (String)"OverseasPersonSaveValidator_6", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
            Long otherIdTypeId = dynamicObject.getLong("otheridtype.id");
            Long idTypeNumberValue = CredentialsTypeEnum.getMapForeign((long)credentialsTypeId, (long)1000001L);
            if (null != idTypeNumberValue && (!idTypeNumberValue.equals(otherIdTypeId) || HRStringUtils.isEmpty((String)otherIdNumber))) {
                message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u51c6\u786e\u7684\u201c\u5176\u4ed6\u8bc1\u4ef6\u7c7b\u578b\u201d\u53ca\u201c\u5176\u4ed6\u8bc1\u4ef6\u53f7\u7801\u201d\u3002", (String)"OverseasPersonSaveValidator_7", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
            if (!HRStringUtils.isEmpty((String)addressId) && !HRStringUtils.isEmpty((String)addressCityId)) {
                String addressCountyParentId;
                String addressCityParentId;
                int level = TaxFileServiceHelper.getLevelByField((String)"address");
                int addressLevel = dynamicObject.getInt("address.level");
                long countryId = dynamicObject.getLong("address.country.id");
                if (!TaxFileServiceHelper.validateIsBelongToChina((String)"address", (long)countryId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740\uff08\u7701\uff09\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u4e2d\u56fd\u7684\u884c\u653f\u533a\u5212\u4fe1\u606f\u3002", (String)"OverseasPersonSaveValidator_11", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                }
                if (level != addressLevel) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740\uff08\u7701\uff09\u6709\u8bef\u3002", (String)"OverseasPersonSaveValidator_8", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                }
                if (!HRStringUtils.equals((String)addressId, (String)(addressCityParentId = dynamicObject.getString("addresscity.parent.id")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740\uff08\u7701\uff09\u4e0e\u8054\u7cfb\u5730\u5740\uff08\u5e02\uff09\u4e0d\u5339\u914d\u3002", (String)"OverseasPersonSaveValidator_9", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                }
                if (!HRStringUtils.isEmpty((String)addressCountyId) && !HRStringUtils.equals((String)addressCityId, (String)(addressCountyParentId = dynamicObject.getString("addresscounty.parent.id")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740\uff08\u5e02\uff09\u4e0e\u8054\u7cfb\u5730\u5740\uff08\u533a\u53bf\uff09\u4e0d\u5339\u914d\u3002", (String)"OverseasPersonSaveValidator_10", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                }
            }
        } else if (null == bsed || ObjectUtils.isEmpty((Object)taxReason)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5c06\u201c\u5883\u5916\u4eba\u5458\u4fe1\u606f\u201d\u8865\u5145\u5b8c\u6574\u3002", (String)"OverseasPersonSaveValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        String otherIdNum = dynamicObject.getString("otheridnumber");
        String otherIdTypeId = dynamicObject.getString("otheridtype.id");
        if (!(HRStringUtils.isEmpty((String)otherIdTypeId) || HRStringUtils.isEmpty((String)otherIdNum) || HRStringUtils.isEmpty((String)(errorMsg = SITFormatUtils.certfTypeCheck((String)otherIdTypeId, (String)otherIdNum))))) {
            this.addErrorMessage(dataEntity, errorMsg);
        }
        OperateOption operateOption = this.getOption();
        String src = operateOption.getVariableValue("src", "");
        if (null != bsed && bsed.before(firstBsedDate) && !StringUtils.endsWithIgnoreCase((CharSequence)src, (CharSequence)"SYNAPI")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5883\u5916\u4eba\u5458\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"OverseasPersonSaveValidator_13", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        dynamicObject.set("bsled", null);
    }

    private Map<Long, DynamicObject> getEmploymentDyObjs(ExtendedDataEntity[] dataEntities) {
        HashMap taxBsedFileMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(obj -> taxBsedFileMap.put(obj.getDataEntity().getLong("taxfile.id"), obj.getDataEntity().getDate("bsed")));
        Set taxFileBoIds = taxBsedFileMap.keySet();
        return TaxFileInfoServiceFactory.getRelatedInfo(taxFileBoIds, (Map)taxBsedFileMap, (String)"itc_overseasperson", (String)"itc_employment");
    }
}

