/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;

public class PersonCertValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PersonCertValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateTaxFileImportCert(dataEntities);
    }

    private void validateTaxFileImportCert(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity[]> pIds = new ArrayList<ExtendedDataEntity[]>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            ExtendedDataEntity[] pid = Long.valueOf(dataEntity.getDataEntity().getLong("person.personindexid"));
            pIds.add(pid);
        }
        DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)1000001L);
        Map veryfiResult = SITCertCommonHelper.verifyCertForApply((String)appInfo.getString("app.id"), (String)"itc_taxfile", pIds);
        Set failList = (Set)veryfiResult.get("failList");
        String message = (String)veryfiResult.get("message");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
            if (CollectionUtils.isEmpty((Collection)failList) || !failList.contains(pid)) continue;
            LOGGER.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
            this.addFatalErrorMessage(dataEntity, message);
        }
        Map checkCountMap = (Map)veryfiResult.get("msg");
        String showMessageType = (String)checkCountMap.get("showMessageType");
        if ("true".equals(checkCountMap.get("showMessage"))) {
            this.getOption().setVariableValue("showWarningTip", (String)checkCountMap.get("message"));
        }
    }
}

