/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.sitbp.common.model.EffectLogger;

public class SpecialInfoSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SpecialInfoSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);

    public void validate() {
        this.effectLogger.start("SpecialInfoSaveValidator validate");
        this.dealData();
        this.effectLogger.end("SpecialInfoSaveValidator validate");
    }

    private void dealData() {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set boids = Arrays.stream(dataEntities).map(entity -> entity.getDataEntity().getLong("taxfile.id")).collect(Collectors.toSet());
        Map taxFileFirstEffectRecords = SitCommonServiceHelper.getTaxFileFirstEffectRecords(boids);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date date = (Date)taxFileFirstEffectRecords.get(dataEntity.getDataEntity().getLong("taxfile.id"));
            if (date == null) {
                date = dataEntity.getDataEntity().getDate("taxfile.bsed");
            }
            this.validateFields(dataEntity, date);
        }
    }

    private void validateFields(ExtendedDataEntity dataEntity, Date bsed) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String disabilityStr = dynamicObject.getString("disability");
        String martyrsFamilyStr = dynamicObject.getString("martyrsfamily");
        String oldAndLoneyStr = dynamicObject.getString("oldandloney");
        boolean disability = StringUtils.equals((CharSequence)"1", (CharSequence)disabilityStr);
        boolean martyrsFamily = StringUtils.equals((CharSequence)"1", (CharSequence)martyrsFamilyStr);
        String disabilityNum = dynamicObject.getString("disabilitynum");
        String martyrsfamilyNum = dynamicObject.getString("martyrsfamilynum");
        Date bred = dynamicObject.getDate("bsed");
        if ((StringUtils.isNotBlank((CharSequence)disabilityStr) || StringUtils.isNotBlank((CharSequence)martyrsFamilyStr) || StringUtils.isNotBlank((CharSequence)oldAndLoneyStr) || !HRStringUtils.isEmpty((String)disabilityNum) || !HRStringUtils.isEmpty((String)martyrsfamilyNum)) && null == bred) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"SpecialInfoSaveValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (disability && HRStringUtils.isEmpty((String)disabilityNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6b8b\u75be\u8bc1\u53f7\u201d\u3002", (String)"SpecialInfoSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!disability && !HRStringUtils.isEmpty((String)disabilityNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u201c\u662f\u5426\u6b8b\u75be\u201d\u4e3a\u5426\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u6b8b\u75be\u8bc1\u53f7\u3002", (String)"SpecialInfoSaveValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!martyrsFamily && !HRStringUtils.isEmpty((String)martyrsfamilyNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u201c\u662f\u5426\u70c8\u5c5e\u201d\u4e3a\u5426\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u70c8\u5c5e\u8bc1\u53f7\u3002", (String)"SpecialInfoSaveValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)disabilityStr) && StringUtils.isEmpty((CharSequence)martyrsFamilyStr) && StringUtils.isEmpty((CharSequence)oldAndLoneyStr) && StringUtils.isEmpty((CharSequence)martyrsfamilyNum)) {
            if (bred != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5c06\u201c\u5176\u4ed6\u51cf\u514d\u7a0e\u4fe1\u606f\u201d\u8865\u5145\u5b8c\u6574\u3002", (String)"SpecialInfoSaveValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            } else {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u5176\u4ed6\u51cf\u514d\u7a0e\u4fe1\u606f\u201c\u3002", (String)"SpecialInfoSaveValidator_106", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
        OperateOption operateOption = this.getOption();
        String src = operateOption.getVariableValue("src", "");
        if (bred != null && bred.before(bsed) && !StringUtils.endsWithIgnoreCase((CharSequence)src, (CharSequence)"SYNAPI")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5176\u4ed6\u51cf\u514d\u7a0e\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"SpecialInfoSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        dynamicObject.set("bsled", null);
    }
}

