/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.util.SITFormatUtils;
import org.apache.commons.collections4.MapUtils;

public class TaxContactSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(TaxContactSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), logger);

    public void validate() {
        this.effectLogger.start("TaxContactSaveValidator validate");
        this.dealData();
        this.effectLogger.end("TaxContactSaveValidator validate");
    }

    private void dealData() {
        ExtendedDataEntity[] dataEntities;
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            logger.info("by cyh TaxContactSaveValidator return file.id = {}", this.getDataEntities()[0].getDataEntity().get("taxfile.id"));
            return;
        }
        logger.info("by cyh TaxContactSaveValidator file.id = {}", this.getDataEntities()[0].getDataEntity().get("taxfile.id"));
        String keyInfoStr = this.getOption().getVariableValue("relateFileKeyInfo", "{}");
        Map relateFileKeyInfo = (Map)SerializationUtils.fromJsonString((String)keyInfoStr, Map.class);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Map keyInfo = (Map)relateFileKeyInfo.get(dataEntity.getDataEntity().getString("taxfile.id"));
            Long idType = null;
            String idNumber = null;
            if (keyInfo != null) {
                Object typeObj = keyInfo.get("iit_person.credentialstype");
                idType = typeObj == null ? null : MapUtils.getLong((Map)((HashMap)typeObj), (Object)"id");
                Object numberObj = keyInfo.get("iit_person.credentialsnum");
                idNumber = numberObj == null ? null : (String)numberObj;
            }
            this.validateFields(dataEntity, idType, idNumber);
        }
    }

    private void validateFields(ExtendedDataEntity dataEntity, Long personIdType, String personIdNumber) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String phone = dynamicObject.getString("phone");
        String status = this.getOption().getVariableValue("status", "");
        String validatePhone = this.getOption().getVariableValue("validatephone", "");
        if ("".equals(validatePhone)) {
            if (HRStringUtils.isEmpty((String)phone) && org.apache.commons.lang3.StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4fe1\u606f\u7684\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxContactSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)phone) && !SITFormatUtils.checkPhone((String)phone)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4fe1\u606f\u7684\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\u3002", (String)"TaxContactSaveValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
        String email = dynamicObject.getString("email");
        email = email.replaceAll(" ", "");
        dynamicObject.set("email", (Object)email);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)email) && !StringUtils.isEmail((String)email)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TaxPersonSaveValidator_15", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        String regpermresId = dynamicObject.getString("regpermres.id");
        String regpermresCityId = dynamicObject.getString("regpermrescity.id");
        String regpermresCountyId = dynamicObject.getString("regpermrescounty.id");
        String regpermresInfo = dynamicObject.getString("regpermresinfo");
        if (!(HRStringUtils.isEmpty((String)regpermresId) && HRStringUtils.isEmpty((String)regpermresCityId) || !HRStringUtils.isEmpty((String)regpermresInfo))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6237\u7c4d\u6240\u5728\u5730\uff08\u8be6\u7ec6\u5730\u5740\uff09\u3002", (String)"TaxPersonSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)regpermresInfo) && (HRStringUtils.isEmpty((String)regpermresId) || HRStringUtils.isEmpty((String)regpermresCityId))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6237\u7c4d\u6240\u5728\u5730\uff08\u7701\uff09\u3001\u6237\u7c4d\u6240\u5728\u5730\uff08\u5e02\uff09\u3002", (String)"TaxPersonSaveValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)regpermresId) && !HRStringUtils.isEmpty((String)regpermresCityId)) {
            String regpermresCountyParentId;
            String regpermresCityParentId;
            int level = TaxFileServiceHelper.getLevelByField((String)"regpermres");
            int regpermresLevel = dynamicObject.getInt("regpermres.level");
            long countryId = dynamicObject.getLong("regpermres.country.id");
            if (!TaxFileServiceHelper.validateIsBelongToChina((String)"regpermres", (long)countryId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6237\u7c4d\u6240\u5728\u5730\uff08\u7701\uff09\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u4e2d\u56fd\u7684\u884c\u653f\u533a\u5212\u4fe1\u606f\u3002", (String)"TaxPersonSaveValidator_13", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (level != regpermresLevel) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6237\u7c4d\u6240\u5728\u5730\uff08\u7701\uff09\u6709\u8bef\u3002", (String)"TaxPersonSaveValidator_7", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.equals((String)regpermresId, (String)(regpermresCityParentId = dynamicObject.getString("regpermrescity.parent.id")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6237\u7c4d\u6240\u5728\u5730\uff08\u7701\uff09\u4e0e\u6237\u7c4d\u6240\u5728\u5730\uff08\u5e02\uff09\u4e0d\u5339\u914d\u3002", (String)"TaxPersonSaveValidator_8", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)regpermresCountyId) && !HRStringUtils.equals((String)regpermresCityId, (String)(regpermresCountyParentId = dynamicObject.getString("regpermrescounty.parent.id")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6237\u7c4d\u6240\u5728\u5730\uff08\u5e02\uff09\u4e0e\u6237\u7c4d\u6240\u5728\u5730\uff08\u533a\u53bf\uff09\u4e0d\u5339\u914d\u3002", (String)"TaxPersonSaveValidator_9", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
        String habitresId = dynamicObject.getString("habitres.id");
        String habitresCityId = dynamicObject.getString("habitrescity.id");
        String habitresCountyId = dynamicObject.getString("habitrescounty.id");
        String habitresInfo = dynamicObject.getString("habitresinfo");
        if (!(HRStringUtils.isEmpty((String)habitresId) && HRStringUtils.isEmpty((String)habitresCityId) || !HRStringUtils.isEmpty((String)habitresInfo))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u8be6\u7ec6\u5730\u5740\uff09\u3002", (String)"TaxPersonSaveValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)habitresInfo) && (HRStringUtils.isEmpty((String)habitresId) || HRStringUtils.isEmpty((String)habitresCityId))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u7701\uff09\u3001\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u5e02\uff09\u3002", (String)"TaxPersonSaveValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)habitresId) && !HRStringUtils.isEmpty((String)habitresCityId)) {
            String habitresCountyParentId;
            String habitresCityParentId;
            int level = TaxFileServiceHelper.getLevelByField((String)"habitres");
            int habitresLevel = dynamicObject.getInt("habitres.level");
            long countryId = dynamicObject.getLong("habitres.country.id");
            if (!TaxFileServiceHelper.validateIsBelongToChina((String)"habitres", (long)countryId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u7701\uff09\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u4e2d\u56fd\u7684\u884c\u653f\u533a\u5212\u4fe1\u606f\u3002", (String)"TaxPersonSaveValidator_14", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (level != habitresLevel) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u7701\uff09\u6709\u8bef\u3002", (String)"TaxPersonSaveValidator_10", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.equals((String)habitresId, (String)(habitresCityParentId = dynamicObject.getString("habitrescity.parent.id")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u7701\uff09\u4e0e\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u5e02\uff09\u4e0d\u5339\u914d\u3002", (String)"TaxPersonSaveValidator_11", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)habitresCountyId) && !HRStringUtils.equals((String)habitresCityId, (String)(habitresCountyParentId = dynamicObject.getString("habitrescounty.parent.id")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u5e02\uff09\u4e0e\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u533a\u53bf\uff09\u4e0d\u5339\u914d\u3002", (String)"TaxPersonSaveValidator_12", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
        if (personIdType != null && CredentialsTypeEnum.IDENTITY_1010.match(personIdType.longValue()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)personIdNumber)) {
            dynamicObject.set("taxpayernum", (Object)personIdNumber);
        }
    }
}

