/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SITFormatUtils;

public class TaxFileAuditValidator
extends AbstractValidator {
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileAuditValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        if ("2".equals(this.getOption().getVariableValue("action", ""))) {
            return;
        }
        String messageEmployment = ResManager.loadKDString((String)"\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u4fe1\u606f\u672a\u586b\u5199\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxFileAuditValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String messageTaxContact = ResManager.loadKDString((String)"\u8054\u7cfb\u4fe1\u606f\u672a\u586b\u5199\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxContactServiceImpl_0", (String)"sit-itc-business", (Object[])new Object[0]);
        String messagePhoneEmpty = ResManager.loadKDString((String)"\u8054\u7cfb\u4fe1\u606f\u7684\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxContactServiceImpl_1", (String)"sit-itc-business", (Object[])new Object[0]);
        String messagePhoneFormat = ResManager.loadKDString((String)"\u8054\u7cfb\u4fe1\u606f\u7684\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxContactServiceImpl_2", (String)"sit-itc-business", (Object[])new Object[0]);
        String messageOversea = ResManager.loadKDString((String)"\u5883\u5916\u4eba\u5458\u4fe1\u606f\u672a\u586b\u5199\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TaxFileAuditValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        Map contactInfo = this.taxFileOpContext.getInfo("itc_taxcontact");
        Map employmentInfo = this.taxFileOpContext.getInfo("itc_employment");
        Map overseaPersonInfo = this.taxFileOpContext.getInfo("itc_overseasperson");
        Map iitPersonInfo = this.taxFileOpContext.getInfo("iit_person");
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject iitPerson;
            String validateOverSeaInfo;
            String validatePhone;
            DynamicObject dyObj = dataEntity.getDataEntity();
            long taxFileId = dyObj.getLong("id");
            if (this.taxFileOpContext.isFailed(Long.valueOf(taxFileId))) continue;
            if (CollectionUtils.isEmpty((Map)employmentInfo) || !employmentInfo.containsKey(taxFileId)) {
                this.addErrorMessage(dataEntity, messageEmployment);
            }
            if ("".equals(validatePhone = this.getOption().getVariableValue("validatephone", ""))) {
                DynamicObject taxContact;
                if (contactInfo == null || (taxContact = (DynamicObject)contactInfo.get(taxFileId)) == null) {
                    this.addErrorMessage(dataEntity, messageTaxContact);
                } else {
                    String phone = taxContact.getString("phone");
                    if (StringUtils.isEmpty((CharSequence)phone)) {
                        this.addErrorMessage(dataEntity, messagePhoneEmpty);
                    } else if (!SITFormatUtils.checkPhone((String)phone)) {
                        this.addErrorMessage(dataEntity, messagePhoneFormat);
                    }
                }
            }
            if (!"".equals(validateOverSeaInfo = this.getOption().getVariableValue("validateoverseainfo", "")) || iitPersonInfo == null || (iitPerson = (DynamicObject)iitPersonInfo.get(taxFileId)) == null || CredentialsTypeEnum.IDENTITY_1010.getId() == iitPerson.getLong("credentialstype.id") || overseaPersonInfo != null && overseaPersonInfo.containsKey(taxFileId)) continue;
            this.addErrorMessage(dataEntity, messageOversea);
        }
    }
}

