/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.impl.splitter.AbstractBillSplitter;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import org.apache.commons.lang3.StringUtils;

public class TaxFileBillSplitValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileBillSplitValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileBillSplitValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileBillSplitValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileBillSplitValidator validate");
    }

    private void dealData() {
        this.taxFileOpContext.setOpKey(this.getOperateKey());
        this.taxFileOpContext.putOptionPara("ITCFILE_ACTIONWAY", this.getOption().getVariableValue("ITCFILE_ACTIONWAY", ""));
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        ArrayList<DynamicObject> taxFiles = new ArrayList<DynamicObject>(dataEntities.length);
        HashMap<Long, ExtendedDataEntity> fileIDAndDataMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject taxFile = dataEntity.getDataEntity();
            taxFiles.add(taxFile);
            fileIDAndDataMap.put(taxFile.getLong("id"), dataEntity);
        }
        this.splitEntity(taxFiles, fileIDAndDataMap);
    }

    private BatchResult<DynamicObject> splitEntity(List<DynamicObject> taxFiles, Map<Long, ExtendedDataEntity> fileIDAndDataMap) {
        try {
            BatchResult result = AbstractBillSplitter.doSplitBills(taxFiles, (TaxFileOpContext)this.taxFileOpContext);
            if (result != null) {
                List failResultOriginal;
                if (!result.isSuccess()) {
                    fileIDAndDataMap.entrySet().forEach(obj -> this.addFatalErrorMessage((ExtendedDataEntity)obj.getValue(), result.getMessage()));
                }
                if (!CollectionUtils.isEmpty((Collection)(failResultOriginal = result.getFailResultOriginal()))) {
                    for (ResultItem resultItem : failResultOriginal) {
                        this.addFatalErrorMessage(fileIDAndDataMap.get(((DynamicObject)resultItem.getData()).getLong("id")), resultItem.getMessage());
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            String s1 = "TaxFileBillSplitValidator splitEntity error: " + e;
            this.effectLogger.log(s1);
            throw e;
        }
    }
}

