/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public class TaxFileDeleteValidator
extends AbstractValidator {
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileDeleteValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        long taxFileId;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap taxFileMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashSet auditFileIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            long taxFileId2 = entity.getLong("id");
            taxFileMap.put(taxFileId2, dataEntity);
            if (!"C".equals(entity.getString("status"))) continue;
            auditFileIds.add(taxFileId2);
        }
        if (CollectionUtils.isEmpty((Collection)auditFileIds)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        Object[] query = serviceHelper.query("id,taxfile", new QFilter[]{new QFilter("taxfile.boid", "in", (Object)auditFileIds), new QFilter("declarestatus", "=", (Object)"1"), new QFilter("taxdatabasicid.status", "!=", (Object)"E")});
        if (!ArrayUtils.isEmpty((Object[])query)) {
            String message = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u5b58\u5728\u5df2\u62a5\u9001\u7684\u8bb0\u5f55", (String)"TaxFileDeleteValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            for (Object object : query) {
                taxFileId = object.getLong("taxfile.boid");
                if (!auditFileIds.remove(taxFileId)) continue;
                this.addFatalErrorMessage((ExtendedDataEntity)taxFileMap.get(taxFileId), message);
                this.taxFileOpContext.taxFileFail(Long.valueOf(taxFileId), message);
            }
        }
        if (CollectionUtils.isEmpty((Collection)auditFileIds)) {
            return;
        }
        serviceHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
        query = serviceHelper.query("id,taxfile.boid", new QFilter[]{new QFilter("taxfile.boid", "in", (Object)auditFileIds), new QFilter("status", "!=", (Object)"E")});
        if (!ArrayUtils.isEmpty((Object[])query)) {
            String message = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u5b58\u5728\u4e2a\u7a0e\u6e90\u6570\u636e\u8bb0\u5f55", (String)"TaxFileDeleteValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            for (Object object : query) {
                taxFileId = object.getLong("taxfile.boid");
                if (!auditFileIds.remove(taxFileId)) continue;
                this.addFatalErrorMessage((ExtendedDataEntity)taxFileMap.get(taxFileId), message);
                this.taxFileOpContext.taxFileFail(Long.valueOf(taxFileId), message);
            }
        }
    }
}

