/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public class TaxFileImportPersonValidator
extends AbstractValidator {
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileImportPersonValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u53f7\u3002", (String)"TaxFileImportPersonValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String personErrMsg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u5bf9\u5e94\u7684\u59d3\u540d\u3001\u5de5\u53f7\u548c\u586b\u5199\u7684\u59d3\u540d\u3001\u5de5\u53f7\u4e0d\u4e00\u81f4\u8bf7\u68c0\u67e5\u3002", (String)"TaxFileImportPersonValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        if (!dataEntities[0].getDataEntity().getDataEntityType().getProperties().containsKey((Object)"personnumber")) {
            String message = ResManager.loadKDString((String)"\u53c2\u6570\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5actionWay\u662f\u5426\u7b26\u5408\u5f53\u524d\u573a\u666f\uff080:\u9875\u9762\u65b0\u589e\uff1b1\uff1a\u85aa\u8d44\u6838\u7b97\u5e94\u7528\u5185\u5bfc\u5165\uff1b2\uff1a\u4e2d\u56fd\u4e2a\u7a0e\u5e94\u7528\u5185\u5bfc\u5165\uff1b-1\uff1a\u5176\u4ed6\uff09", (String)"TaxFileImportPersonValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            for (Object dataEntity : dataEntities) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, message);
            }
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (Object dataEntity : dataEntities) {
            boolean numberErr;
            if (StringUtils.isEmpty((String)dataEntity.getDataEntity().getString("number"))) {
                if (StringUtils.isEmpty((String)dataEntity.getDataEntity().getString("personnumber"))) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                    continue;
                }
                List listTemp = map.computeIfAbsent(dataEntity.getDataEntity().getString("personnumber"), k1 -> Lists.newArrayListWithExpectedSize((int)10));
                listTemp.add(dataEntity);
                continue;
            }
            DynamicObject person = dataEntity.getDataEntity().getDynamicObject("person");
            if (null == person) {
                List listTemp = map.computeIfAbsent(dataEntity.getDataEntity().getString("personnumber"), k1 -> Lists.newArrayListWithExpectedSize((int)10));
                listTemp.add(dataEntity);
                continue;
            }
            boolean nameErr = StringUtils.isNotEmpty((String)dataEntity.getDataEntity().getString("personname")) && !dataEntity.getDataEntity().getString("personname").equals(person.getString("name"));
            boolean bl = numberErr = StringUtils.isNotEmpty((String)dataEntity.getDataEntity().getString("personnumber")) && !dataEntity.getDataEntity().getString("personnumber").equals(person.getString("number"));
            if (!nameErr && !numberErr) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity, personErrMsg);
        }
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Map personMap = TaxFileServiceHelper.getPersonIdOrPIDsByNumber(map.keySet());
        Map result = TaxFileServiceHelper.getEmpposorgrelByPersonNumber(map.keySet());
        String empErrMessage = ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u4e3b\u4efb\u804c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileImportPersonValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String noPersonMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileSavePersonInfoValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        for (Map.Entry entry : map.entrySet()) {
            List taxFileBillDys = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Map)personMap) || !personMap.containsKey(entry.getKey())) {
                taxFileBillDys.forEach(taxBillDy -> {
                    this.addFatalErrorMessage((ExtendedDataEntity)taxBillDy, noPersonMessage);
                    this.taxFileOpContext.taxFileFail(Long.valueOf(taxBillDy.getDataEntity().getLong("id")), empErrMessage);
                });
                continue;
            }
            if (CollectionUtils.isEmpty((Map)result) || CollectionUtils.isEmpty((Collection)((Collection)result.get(entry.getKey())))) {
                taxFileBillDys.forEach(taxBillDy -> {
                    this.addFatalErrorMessage((ExtendedDataEntity)taxBillDy, empErrMessage);
                    this.taxFileOpContext.taxFileFail(Long.valueOf(taxBillDy.getDataEntity().getLong("id")), empErrMessage);
                });
                continue;
            }
            this.getMatchedEmpposorgrel(taxFileBillDys, (List)result.get(entry.getKey()), empErrMessage);
        }
    }

    private void getMatchedEmpposorgrel(List<ExtendedDataEntity> dataEntities, List<DynamicObject> empposorgrelDys, String empErrMessage) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject tempDy = TaxFileServiceHelper.getLastEmpPosorgrel(empposorgrelDys);
            if (null == tempDy) {
                this.addFatalErrorMessage(dataEntity, empErrMessage);
                this.taxFileOpContext.taxFileFail(Long.valueOf(dataEntity.getDataEntity().getLong("id")), empErrMessage);
                continue;
            }
            String errMsg = ResManager.loadKDString((String)"\u5de5\u53f7\u5bf9\u5e94\u7684\u59d3\u540d\u548c\u586b\u5199\u7684\u59d3\u540d\u4e0d\u4e00\u81f4\u3002", (String)"TaxFileImportPersonValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)dataEntity.getDataEntity().getString("personname")) && !dataEntity.getDataEntity().getString("personname").equals(tempDy.getString("person.name"))) {
                this.addFatalErrorMessage(dataEntity, errMsg);
                dataEntity.getDataEntity().set("person", (Object)tempDy.getDynamicObject("person"));
                continue;
            }
            dataEntity.getDataEntity().set("person", (Object)tempDy.getDynamicObject("person"));
        }
    }
}

