/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.model.EffectLogger;
import org.apache.commons.lang3.StringUtils;

public class TaxFileNumberValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileNumberValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final String msg = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u65e0\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"TaxFileNumberValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.effectLogger.start("TaxFileNumberValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileNumberValidator validate");
    }

    private void dealData() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String actionWay = this.getOption().getVariableValue("ITCFILE_ACTIONWAY", "");
        String action = this.getOption().getVariableValue("action", "");
        if (StringUtils.equals((CharSequence)action, (CharSequence)"2")) {
            return;
        }
        ArrayList addNewDataEntitys = Lists.newArrayListWithCapacity((int)dataEntities.length);
        HashSet<Integer> errorDataIndexs = this.getErrorDataIndexs();
        for (int i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity dataEntity;
            DynamicObject taxFile;
            if (errorDataIndexs.contains(i) || (taxFile = (dataEntity = dataEntities[i]).getDataEntity()).getDataEntityState().getFromDatabase() || !taxFile.getBoolean("iscurrentversion") && taxFile.getLong("boid") != 0L) continue;
            addNewDataEntitys.add(dataEntity);
        }
        if (CollectionUtils.isEmpty((Collection)addNewDataEntitys)) {
            return;
        }
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"itc_taxfile", (DynamicObject)((ExtendedDataEntity)addNewDataEntitys.get(0)).getDataEntity(), null);
        if (StringUtils.equals((CharSequence)actionWay, (CharSequence)"2")) {
            this.injectNumber(addNewDataEntitys, codeRuleService, codeRule);
        }
        HashMap newNumberEntityMap = Maps.newHashMapWithExpectedSize((int)addNewDataEntitys.size());
        for (ExtendedDataEntity dataEntity : addNewDataEntitys) {
            DynamicObject taxFile = dataEntity.getDataEntity();
            String fileNum = taxFile.getString("number");
            if (StringUtils.isEmpty((CharSequence)fileNum)) {
                if (codeRule == null) {
                    this.addErrorMessage(dataEntity, this.msg);
                    continue;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]));
                continue;
            }
            newNumberEntityMap.put(fileNum, dataEntity);
        }
        if (CollectionUtils.isEmpty((Map)newNumberEntityMap)) {
            return;
        }
        DynamicObject[] query = this.queryExistNumbers(newNumberEntityMap.keySet());
        if (query == null || query.length == 0) {
            return;
        }
        Set existNumbers = Arrays.stream(query).map(obj -> obj.getString("number")).collect(Collectors.toSet());
        for (String existNumber : existNumbers) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)newNumberEntityMap.get(existNumber);
            if (codeRule != null && codeRuleService.checkNumber(dataEntity.getDataEntity(), existNumber, codeRule)) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u751f\u6210\u7684\u7f16\u7801\u201c%s\u201d\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u65ad\u53f7\u8868\u5e76\u91cd\u8bd5\u3002", (String)"TaxFileNumberValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]), existNumber));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"TaxFileNumberValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]), existNumber));
        }
    }

    private void injectNumber(List<ExtendedDataEntity> addNewDataEntitys, ICodeRuleService codeRuleService, CodeRuleInfo codeRule) {
        if (codeRule == null) {
            return;
        }
        ArrayList needNumberFiles = Lists.newArrayListWithCapacity((int)this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : addNewDataEntitys) {
            DynamicObject taxFile = dataEntity.getDataEntity();
            String fileNum = taxFile.getString("number");
            if (!StringUtils.isEmpty((CharSequence)fileNum) && !codeRuleService.checkNumber(taxFile, fileNum, codeRule)) continue;
            needNumberFiles.add(taxFile);
        }
        if (!CollectionUtils.isEmpty((Collection)needNumberFiles)) {
            CodeRuleServiceHelper.injectNumbers((String)"itc_taxfile", (List)needNumberFiles);
        }
    }

    private HashSet<Integer> getErrorDataIndexs() {
        HashSet errorDataIndexs = null;
        ValidateResultCollection validateResults = this.getValidateContext().getValidateResults();
        if (validateResults != null) {
            errorDataIndexs = validateResults.getErrorDataIndexs();
        }
        if (errorDataIndexs == null) {
            errorDataIndexs = Sets.newHashSetWithExpectedSize((int)0);
        }
        return errorDataIndexs;
    }

    private DynamicObject[] queryExistNumbers(Set<String> newNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter filter = new QFilter("number", "in", newNumbers);
        filter.and("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("number", new QFilter[]{filter});
    }
}

