/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.TaxFileImportInfo;
import kd.sit.sitbp.common.model.EffectLogger;
import org.apache.commons.lang3.StringUtils;

public class TaxFilePermissionValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFilePermissionValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileImportInfo importInfo = new TaxFileImportInfo();

    public void validate() {
        this.effectLogger.start("TaxFilePermissionValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFilePermissionValidator validate");
    }

    private void dealData() {
        String action = this.getOption().getVariableValue("action", "");
        if (StringUtils.equals((CharSequence)action, (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject taxFile = dataEntity.getDataEntity();
            String msg = "";
            if (!taxFile.getDataEntityState().getFromDatabase() && (taxFile.getBoolean("iscurrentversion") || taxFile.getLong("boid") == 0L)) {
                this.taxFileNewDefaultSet(taxFile);
            } else {
                msg = this.validateFileStatue(taxFile);
            }
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = this.validatePerm(taxFile);
            }
            if (StringUtils.isEmpty((CharSequence)msg)) continue;
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private void taxFileNewDefaultSet(DynamicObject taxFile) {
        if (StringUtils.isEmpty((CharSequence)taxFile.getString("taxregion"))) {
            taxFile.set("taxregion", (Object)this.importInfo.getCountryDyn());
        }
    }

    private String validatePerm(DynamicObject taxFile) {
        String fieldCode = "empgroup.id";
        String tipFieldCode = "empgroup.number";
        String fieldName = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u7ec4", (String)"TaxFileImportValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String msg = this.hasPermission(fieldCode, fieldName, tipFieldCode, this.importInfo.getEmpGroupIds(), taxFile);
        if (!this.importInfo.isSuperUser().booleanValue()) {
            fieldCode = "org.id";
            tipFieldCode = "org.number";
            fieldName = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"TaxFileImportValidator_6", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            msg = msg + this.hasPermission(fieldCode, fieldName, tipFieldCode, this.importInfo.getOrgIds(), taxFile);
            Set taxUnitIds = this.importInfo.getTaxUnitIds();
            fieldCode = "taxunit.id";
            tipFieldCode = "taxunit.number";
            fieldName = ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxFileImportValidator_7", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            msg = msg + this.hasPermission(fieldCode, fieldName, tipFieldCode, taxUnitIds, taxFile);
        }
        return msg;
    }

    private String hasPermission(String fieldCode, String fieldName, String tipFieldCode, Set<Long> permissionIds, DynamicObject taxFile) {
        boolean isHasePerm;
        String msg = "";
        if (permissionIds == null) {
            return msg;
        }
        long permId = taxFile.getLong(fieldCode);
        boolean bl = isHasePerm = permId == 0L || permissionIds.contains(permId);
        if (!isHasePerm) {
            msg = StringUtils.equals((CharSequence)fieldCode, (CharSequence)"empgroup.id") && !CollectionUtils.isEmpty((Collection)this.importInfo.getAppEmpGroupIds()) && !this.importInfo.getAppEmpGroupIds().contains(permId) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u4e2a\u7a0e\u7ba1\u7406\u201d\u7684\u4e2a\u7a0e\u4eba\u5458\u7ec4\u3002", (String)"TaxFileImportValidator_8", (String)"sit-itc-opplugin", (Object[])new Object[0]) : MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5{0}\u201c{1}\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxFileImportValidator_9", (String)"sit-itc-opplugin", (Object[])new Object[0]), fieldName, taxFile.getString(tipFieldCode));
        }
        return msg;
    }

    private String validateFileStatue(DynamicObject taxFile) {
        String msg = "";
        if (StringUtils.equals((CharSequence)taxFile.getString("status"), (CharSequence)"E")) {
            msg = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"TaxFileImportValidator_11", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        }
        return msg;
    }
}

