/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class TaxFileRelateSalaryFileValidator
extends AbstractValidator {
    protected static final Log LOGGER = LogFactory.getLog(TaxFileRelateSalaryFileValidator.class);

    public void validate() {
        block16: {
            Map res;
            HashSet failPersonIds;
            HashMap fileIdToExtend;
            HashMap personIdToFileId;
            block15: {
                boolean success;
                QFilter statusFilter;
                QFilter currentVersionFilter;
                QFilter notFileFilter;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                personIdToFileId = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
                fileIdToExtend = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
                String msgAbandon = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u4e3a\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u5173\u8054\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"TaxFileRelateSalaryFileValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                String msgPersonRepeat = ResManager.loadKDString((String)"\u540c\u4e00\u7ba1\u7406\u5c5e\u5730\u4e0b\uff0c\u4e2a\u7a0e\u4eba\u5458{0}\u5b58\u5728\u591a\u4e2a\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\uff0c\u65e0\u6cd5\u6279\u91cf\u5173\u8054\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"TaxFileRelateSalaryFileValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                failPersonIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
                for (ExtendedDataEntity entity : dataEntities) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    if ("E".equals(dataEntity.getString("status"))) {
                        this.addFatalErrorMessage(entity, msgAbandon);
                        continue;
                    }
                    long personId = dataEntity.getLong("person.id");
                    long fileId2 = dataEntity.getLong("boid");
                    if (personIdToFileId.putIfAbsent(personId, fileId2) != null) {
                        this.addFatalErrorMessage(entity, MessageFormat.format(msgPersonRepeat, dataEntity.getString("person.name")));
                        failPersonIds.add(personId);
                        continue;
                    }
                    fileIdToExtend.put(fileId2, entity);
                }
                if (!CollectionUtils.isEmpty((Collection)failPersonIds)) {
                    for (Long personId : failPersonIds) {
                        ExtendedDataEntity entity;
                        Long fileId3 = (Long)personIdToFileId.remove(personId);
                        entity = (ExtendedDataEntity)fileIdToExtend.get(fileId3);
                        this.addFatalErrorMessage(entity, MessageFormat.format(msgPersonRepeat, entity.getDataEntity().getString("person.name")));
                    }
                }
                if (CollectionUtils.isEmpty((Map)personIdToFileId)) {
                    return;
                }
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
                QFilter personFilter = new QFilter("person.id", "in", personIdToFileId.keySet());
                Object[] query = serviceHelper.query("id,person.id,person.name", new QFilter[]{personFilter, notFileFilter = new QFilter("boid", "not in", personIdToFileId.values()), currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1"), statusFilter = new QFilter("status", "!=", (Object)"E")});
                if (!ArrayUtils.isEmpty((Object[])query)) {
                    for (Object object : query) {
                        long personId = object.getLong("person.id");
                        Object[] fileId4 = (Object[])personIdToFileId.remove(personId);
                        if (fileId4 == null) continue;
                        this.addFatalErrorMessage((ExtendedDataEntity)fileIdToExtend.get(fileId4), MessageFormat.format(msgPersonRepeat, object.getString("person.name")));
                        failPersonIds.add(personId);
                    }
                }
                if (CollectionUtils.isEmpty((Map)personIdToFileId)) {
                    return;
                }
                HashMap param = Maps.newHashMapWithExpectedSize((int)4);
                param.put("data", personIdToFileId);
                param.put("region", 1000001L);
                HashMap dateMap = Maps.newHashMapWithExpectedSize((int)personIdToFileId.size());
                param.put("dateMap", dateMap);
                QFilter fileFilter = new QFilter("boid", "in", personIdToFileId.values());
                QFilter taxStatusFilter = new QFilter("taxstatus", "=", (Object)"1");
                QFilter dataStatusFilter = new QFilter("datastatus", "not in", (Object)new String[]{"-1", "-2"});
                Object[] objects = serviceHelper.queryOriginalArray("boid,bsed,bsled", new QFilter[]{fileFilter, taxStatusFilter, dataStatusFilter});
                if (!ArrayUtils.isEmpty((Object[])objects)) {
                    for (Object object : objects) {
                        Map map = dateMap.computeIfAbsent(object.getLong("boid"), fileId -> Maps.newHashMapWithExpectedSize((int)2));
                        map.put(object.getDate("bsed"), object.getDate("bsled"));
                    }
                }
                if (success = ((Boolean)(res = (Map)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"batchRelateSalaryTaxFile", (Object[])new Object[]{param})).get("success")).booleanValue()) break block15;
                String message = (String)res.get("message");
                for (Map.Entry entry : personIdToFileId.entrySet()) {
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)fileIdToExtend.get(entry.getValue());
                    this.addFatalErrorMessage(dataEntity, MessageFormat.format(message, dataEntity.getDataEntity().getString("person.name"), dataEntity.getDataEntity().getString("number")));
                    failPersonIds.add(entry.getKey());
                }
                break block16;
            }
            List data = (List)res.get("data");
            if (CollectionUtils.isEmpty((Collection)data)) break block16;
            for (Map datum : data) {
                Boolean itemSuccess = (Boolean)datum.get("success");
                if (itemSuccess == null || itemSuccess.booleanValue()) continue;
                String itemMessage = (String)datum.get("message");
                Long personId = (Long)datum.get("person");
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)fileIdToExtend.get(personIdToFileId.get(personId));
                if (null == dataEntity) {
                    LOGGER.info("TaxFileRelateSalaryFileValidator ---- dataEntity empty itemMessage:{}, personId:{}", (Object)itemMessage, (Object)personId);
                    continue;
                }
                if (null == dataEntity.getDataEntity()) {
                    LOGGER.info("TaxFileRelateSalaryFileValidator ---- dataEntity.getDataEntity() is empty itemMessage:{}, personId:{}", (Object)itemMessage, (Object)personId);
                    continue;
                }
                this.addFatalErrorMessage(dataEntity, MessageFormat.format(itemMessage, dataEntity.getDataEntity().getString("person.name"), dataEntity.getDataEntity().getString("number")));
                failPersonIds.add(personId);
            }
        }
    }
}

