/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import org.apache.commons.lang3.StringUtils;

public class TaxFileSaveFillIdValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSaveFillIdValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSaveFillIdValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSaveFillIdValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSaveFillIdValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        this.taxFileOpContext.setOpKey(this.getOperateKey());
        if (!"save".equals(this.getOperateKey())) {
            return;
        }
        this.fillId(this.getDataEntities());
    }

    private void fillId(ExtendedDataEntity[] dataEntities) {
        List noIdFiles = Arrays.stream(dataEntities).filter(obj -> obj.getDataEntity().getLong("id") == 0L).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(noIdFiles)) {
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds("itc_taxfile", noIdFiles.size());
            for (int i = 0; i < noIdFiles.size(); ++i) {
                DynamicObject dataEntity = ((ExtendedDataEntity)noIdFiles.get(i)).getDataEntity();
                this.taxFileOpContext.fillId(dataEntity, Long.valueOf(ids[i]));
            }
        }
    }
}

