/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import org.apache.commons.lang3.StringUtils;

public class TaxFileSaveInfoGatherValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSaveInfoGatherValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSaveInfoGatherValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSaveInfoGatherValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSaveInfoGatherValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        if (!"save".equals(this.getOperateKey()) && !"saveafteraudit".equals(this.getOperateKey())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap map = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        ArrayList successFiles = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            if (StringUtils.equals((CharSequence)entity.getString("status"), (CharSequence)"E")) continue;
            map.put(entity, dataEntity);
            successFiles.add(entity);
        }
        if (successFiles.isEmpty()) {
            return;
        }
        BatchResult batchResult = TaxFileServiceHelper.gatherExtraInfo((List)successFiles, (TaxFileOpContext)this.taxFileOpContext);
        if (!batchResult.isSuccess()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, batchResult.getMessage());
            }
            return;
        }
        List failResult = batchResult.getFailResultOriginal();
        if (!CollectionUtils.isEmpty((Collection)failResult)) {
            for (ResultItem item : failResult) {
                this.addFatalErrorMessage((ExtendedDataEntity)map.get(item), item.getMessage());
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxcrdltype");
        QFilter countryFilter = new QFilter("apprelatecountry", "in", (Object)new Long[]{1000001L});
        countryFilter.and("enable", "=", (Object)YesOrNoEnum.YES.getCode());
        DynamicObject[] taxCredentialTypes = serviceHelper.query("id, nationality.id, nationalitytype, credentialstype.id", new QFilter[]{countryFilter});
        if (null == taxCredentialTypes || taxCredentialTypes.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> taxCredentialTypesMap = Arrays.stream(taxCredentialTypes).collect(Collectors.groupingBy(dy -> dy.getLong("credentialstype.id")));
        String msg = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4e2a\u7a0e\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"TaxFileSaveInfoGatherValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String empErrMessage = ResManager.loadKDString((String)"\u4eba\u5458\u65e0\u4e3b\u4efb\u804c\uff0c\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileImportPersonValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        for (DynamicObject successFile : successFiles) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)map.get(successFile);
            if (null == dataEntity) continue;
            if (!successFile.getDataEntityState().getFromDatabase() && null == successFile.get("empposorgrel")) {
                this.addFatalErrorMessage(dataEntity, empErrMessage);
            }
            long credentialstype = successFile.getLong("percre.credentialstype.id");
            long nationality = successFile.getLong("pernontsprop.nationality.id");
            if (0L == nationality) continue;
            DynamicObject credentialsType = this.getCredentialsType(taxCredentialTypesMap, credentialstype, nationality);
            if (null == credentialsType) {
                this.addFatalErrorMessage((ExtendedDataEntity)map.get(successFile), msg);
                continue;
            }
            successFile.set("taxcrdltype", (Object)credentialsType);
        }
    }

    private DynamicObject getCredentialsType(Map<Long, List<DynamicObject>> taxCredentialTypesMap, long credentialstypeId, long nationality) {
        this.effectLogger.log(String.valueOf(credentialstypeId));
        this.effectLogger.log(String.valueOf(nationality));
        List<DynamicObject> list = taxCredentialTypesMap.get(credentialstypeId);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        DynamicObject result = null;
        for (DynamicObject dy : list) {
            if ("1".equals(dy.getString("nationalitytype")) && dy.getLong("nationality.id") == nationality) {
                result = dy;
                break;
            }
            if (!"0".equals(dy.getString("nationalitytype"))) continue;
            result = dy;
        }
        return result;
    }
}

