/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxFileSavePersonInfoValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSavePersonInfoValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSavePersonInfoValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSavePersonInfoValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSavePersonInfoValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        if (!"save".equals(this.getOperateKey())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap personIdToFiles = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashMap map = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            personIdToFiles.put(entity.getLong("id"), dataEntity);
            HashMap personAndDateRangeMap = Maps.newHashMapWithExpectedSize((int)2);
            personAndDateRangeMap.put("personId", entity.getLong("person.id"));
            DateRange dateRange = new DateRange(entity.getDate("bsed"), entity.getDate("bsled"));
            personAndDateRangeMap.put("dateRange", dateRange);
            map.put(entity.getLong("id"), personAndDateRangeMap);
        }
        HashMap personMap = (HashMap)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdsAndDateRanges", (Object[])new Object[]{map, null});
        String noPersonMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileSavePersonInfoValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Map)personMap)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, noPersonMessage);
            }
            return;
        }
        HashMap successPersonMap = Maps.newHashMapWithExpectedSize((int)personMap.size());
        for (Map.Entry dataEntityEntry : personIdToFiles.entrySet()) {
            Long taxFileId = (Long)dataEntityEntry.getKey();
            if (this.taxFileOpContext.isFailed(taxFileId)) continue;
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityEntry.getValue();
            DynamicObject personObject = (DynamicObject)personMap.get(taxFileId);
            if (personObject != null) {
                String notCompleteMsg = TaxFileServiceHelper.validatePersonMustInput((DynamicObject)personObject, (String)"-1");
                if (!Strings.isNullOrEmpty((String)notCompleteMsg)) {
                    this.addFatalErrorMessage(dataEntity, notCompleteMsg);
                    continue;
                }
                successPersonMap.put(taxFileId, personObject);
                continue;
            }
            this.addFatalErrorMessage(dataEntity, noPersonMessage);
        }
        if (!successPersonMap.isEmpty()) {
            this.taxFileOpContext.addExtraInfo("iit_person", (Map)successPersonMap);
        }
    }
}

