/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.sitbp.common.enums.EmpTypeEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbp.common.util.SitDateUtil;
import org.apache.commons.lang.StringUtils;

public class TaxFileSaveQuitTaxValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSaveQuitTaxValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSaveQuitTaxValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSaveQuitTaxValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSaveQuitTaxValidator validate");
    }

    private void dealData() {
        Map<Long, ExtendedDataEntity> taxFileMap;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        OperateOption option = this.getOption();
        String bsed = option.getVariableValue("bsed", null);
        if (bsed != null) {
            Date bsedDate = DateUtils.parseDate((Object)bsed);
            for (ExtendedDataEntity dataEntity2 : dataEntities) {
                dataEntity2.setValue("bsed", (Object)bsedDate);
                dataEntity2.setValue("bsled", null);
                dataEntity2.setValue("taxstatus", (Object)"0");
            }
        }
        if (CollectionUtils.isEmpty(taxFileMap = Stream.of(dataEntities).filter(entity -> "0".equals(entity.getDataEntity().getString("taxstatus")) && !this.taxFileOpContext.isFailed(Long.valueOf(entity.getDataEntity().getLong("id")))).collect(Collectors.toMap(dataEntity -> 0L == dataEntity.getDataEntity().getLong("boid") ? dataEntity.getDataEntity().getLong("id") : dataEntity.getDataEntity().getLong("boid"), dataEntity -> dataEntity)))) {
            return;
        }
        this.validateTaxFile(taxFileMap);
        if (CollectionUtils.isEmpty(taxFileMap)) {
            return;
        }
        this.validateEmployment(taxFileMap);
        if (CollectionUtils.isEmpty(taxFileMap)) {
            return;
        }
        String skipValidateTaxRecord = this.getOption().getVariableValue("skipValidateTaxRecord", "0");
        if (!"1".equals(skipValidateTaxRecord)) {
            this.validateTaxRecord(taxFileMap);
        }
    }

    private void validateTaxFile(Map<Long, ExtendedDataEntity> taxFileMap) {
        Map allFileMap = SitCommonServiceHelper.getTaxFileEffectRecords(taxFileMap.keySet());
        OperateOption option = this.getOption();
        String src = option.getVariableValue("src", "");
        Iterator<Map.Entry<Long, ExtendedDataEntity>> fileIterator = taxFileMap.entrySet().iterator();
        block0: while (fileIterator.hasNext()) {
            Map.Entry<Long, ExtendedDataEntity> fileEntry = fileIterator.next();
            ExtendedDataEntity dataEntity = fileEntry.getValue();
            DynamicObject taxFile = dataEntity.getDataEntity();
            long fileId = taxFile.getLong("id");
            Date fileFirstBsed = null;
            List fileList = (List)allFileMap.get(fileEntry.getKey());
            if (!CollectionUtils.isEmpty((Collection)fileList)) {
                int firstBsedDate;
                for (DynamicObject fileObj : fileList) {
                    if (fileFirstBsed == null) {
                        fileFirstBsed = fileObj.getDate("bsed");
                    }
                    if (!fileObj.getBoolean("iscurrentversion") || "C".equals(fileObj.getString("status"))) continue;
                    String notAuditMsg = ResManager.loadKDString((String)"\u6863\u6848\u72b6\u6001\u4e3a\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u6216\u5df2\u5e9f\u5f03\uff0c\u4e0d\u5141\u8bb8\u505c\u6b62\u7b97\u7a0e\u3002", (String)"TaxFileSaveQuitTaxValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(dataEntity, notAuditMsg);
                    fileIterator.remove();
                    this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), notAuditMsg);
                    continue block0;
                }
                int newBsedDate = SitDateUtil.toYearMonth((Date)taxFile.getDate("bsed"));
                if (newBsedDate > (firstBsedDate = SitDateUtil.toYearMonth(fileFirstBsed))) continue;
                String firstFileMsg = MessageFormat.format(ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e\u751f\u6548\u65e5\u671f\u6240\u5728\u5e74\u6708\u987b\u665a\u4e8e\u6863\u6848\u7b2c\u4e00\u4e2a\u7248\u672c\u751f\u6548\u65e5\u671f\u6240\u5728\u5e74\u6708{0}\u3002", (String)"TaxFileSaveQuitTaxValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]), DateUtils.formatDate((Date)fileFirstBsed, (Object[])new Object[]{"yyyyMM"}));
                this.addFatalErrorMessage(dataEntity, firstFileMsg);
                fileIterator.remove();
                this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), firstFileMsg);
                continue;
            }
            if (!StringUtils.equals((String)src, (String)"SYNAPI")) continue;
            String notAuditMsg = ResManager.loadKDString((String)"\u65b0\u589e\u6863\u6848\u7684\u65f6\u5019\uff0c\u4e0d\u5141\u8bb8\u505c\u6b62\u7b97\u7a0e\u3002", (String)"TaxFileSaveQuitTaxValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, notAuditMsg);
            fileIterator.remove();
            this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), notAuditMsg);
        }
    }

    private Map<Long, List<DynamicObject>> getEmployMap(Set<Long> taxFileIds) {
        HRBaseServiceHelper employHelper = new HRBaseServiceHelper("itc_employment");
        QFilter employFilter = new QFilter("taxfile.boid", "in", taxFileIds);
        employFilter.and("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        DynamicObject[] employObjects = employHelper.query("taxfile.boid,bsed,bsled,quitdate,emptype,datastatus", new QFilter[]{employFilter});
        HashMap employMap = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        for (DynamicObject employObject : employObjects) {
            long taxFileId = employObject.getLong("taxfile.boid");
            employMap.computeIfAbsent(taxFileId, key -> new ArrayList()).add(employObject);
        }
        return employMap;
    }

    private void validateEmployment(Map<Long, ExtendedDataEntity> taxFileMap) {
        Map<Long, List<DynamicObject>> employMap = this.getEmployMap(taxFileMap.keySet());
        Iterator<Map.Entry<Long, ExtendedDataEntity>> fileIterator = taxFileMap.entrySet().iterator();
        while (fileIterator.hasNext()) {
            Map.Entry<Long, ExtendedDataEntity> fileEntry = fileIterator.next();
            ExtendedDataEntity dataEntity = fileEntry.getValue();
            DynamicObject taxFile = dataEntity.getDataEntity();
            long fileId = taxFile.getLong("id");
            Date fileBSed = taxFile.getDate("bsed");
            List<DynamicObject> employObjects = employMap.get(fileEntry.getKey());
            String noQuitDateMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u4fe1\u606f\u4e2d\u7684\u79bb\u804c\u65e5\u671f\u3002", (String)"TaxFileSaveQuitTaxValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]);
            if (CollectionUtils.isEmpty(employObjects)) {
                this.addFatalErrorMessage(dataEntity, noQuitDateMsg);
                fileIterator.remove();
                this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), noQuitDateMsg);
                continue;
            }
            Date quitDate = null;
            long empType = 0L;
            int priority = 0;
            for (DynamicObject employObject : employObjects) {
                Date employBSed = employObject.getDate("bsed");
                Date employBSled = employObject.getDate("bsled");
                if (!employBSed.after(fileBSed) && !fileBSed.after(employBSled) && priority < 9) {
                    if (quitDate == null) {
                        quitDate = employObject.getDate("quitdate");
                    } else if (null != employObject.getDate("quitdate") && quitDate.after(employObject.getDate("quitdate"))) {
                        quitDate = employObject.getDate("quitdate");
                    }
                    empType = employObject.getLong("emptype.id");
                    priority = 9;
                    continue;
                }
                if (empType == 0L && priority < 5) {
                    empType = employObject.getLong("emptype.id");
                    priority = 5;
                    continue;
                }
                employObject.getString("datastatus");
            }
            if (quitDate == null) {
                if (empType == EmpTypeEnum.EMP_TYPE_1050.getId()) continue;
                this.addFatalErrorMessage(dataEntity, noQuitDateMsg);
                fileIterator.remove();
                this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), noQuitDateMsg);
                continue;
            }
            if (!fileBSed.before(quitDate)) continue;
            String tooEarlyBsedMsg = MessageFormat.format(ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u7a0e\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u4fe1\u606f\u7684\u79bb\u804c\u65e5\u671f{0}\u3002", (String)"TaxFileSaveQuitTaxValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]), SITInteDateTimeUtil.formatDate((String)"itc_employment", (String)"quitdate", quitDate));
            this.addFatalErrorMessage(dataEntity, tooEarlyBsedMsg);
            fileIterator.remove();
            this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), tooEarlyBsedMsg);
        }
    }

    private void validateTaxRecord(Map<Long, ExtendedDataEntity> taxFileMap) {
        Date fileBSedMinDate = DateUtils.parseDate((Object)"2999-12-31");
        Date fileBSedMaxDate = DateUtils.parseDate((Object)"1900-01-01");
        for (Map.Entry<Long, ExtendedDataEntity> fileEntry : taxFileMap.entrySet()) {
            DynamicObject dataEntity = fileEntry.getValue().getDataEntity();
            Date fileBsed = dataEntity.getDate("bsed");
            if (fileBsed == null) continue;
            if (fileBsed.before(fileBSedMinDate)) {
                fileBSedMinDate = fileBsed;
            }
            if (!fileBsed.after(fileBSedMaxDate)) continue;
            fileBSedMaxDate = fileBsed;
        }
        HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
        QFilter taskFilter = new QFilter("taxstartdate", "<=", (Object)fileBSedMaxDate);
        taskFilter.and("taxenddate", ">=", (Object)fileBSedMinDate);
        DynamicObject[] taxTasks = taxTaskHelper.query("id,taxperiod,taxstartdate,taxenddate", new QFilter[]{taskFilter});
        if (taxTasks == null || taxTasks.length == 0) {
            return;
        }
        HashSet taxTaskIds = Sets.newHashSetWithExpectedSize((int)taxTasks.length);
        HashSet yearmonth = Sets.newHashSetWithExpectedSize((int)taxTasks.length);
        for (DynamicObject taxTask : taxTasks) {
            taxTaskIds.add(taxTask.getLong("id"));
            yearmonth.add(SitDateUtil.toYearMonth((Date)taxTask.getDate("taxperiod.perioddate")));
        }
        HRBaseServiceHelper rawDataHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
        QFilter rawDataFilter = new QFilter("taxtask.id", "in", (Object)taxTaskIds);
        rawDataFilter.and("yearmonth", "in", (Object)yearmonth);
        rawDataFilter.and("taxfile.boid", "in", taxFileMap.keySet());
        rawDataFilter.and("status", "!=", (Object)"E");
        DynamicObject[] taxRawData = rawDataHelper.query("id,taxtask,yearmonth,taxfile", new QFilter[]{rawDataFilter});
        if (taxRawData == null || taxRawData.length == 0) {
            return;
        }
        HashMap rawDataInfoMap = Maps.newHashMapWithExpectedSize((int)taxFileMap.size());
        for (DynamicObject data : taxRawData) {
            long taxFileId = data.getLong("taxfile.boid");
            rawDataInfoMap.computeIfAbsent(taxFileId, key -> new ArrayList()).add(data);
        }
        block3: for (Map.Entry entry : taxFileMap.entrySet()) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)entry.getValue();
            DynamicObject taxFile = dataEntity.getDataEntity();
            long fileId = taxFile.getLong("id");
            int bsedYearmonth = SitDateUtil.toYearMonth((Date)taxFile.getDate("bsed"));
            List rawData = (List)rawDataInfoMap.get(taxFile.getLong("boid"));
            if (CollectionUtils.isEmpty((Collection)rawData)) continue;
            for (DynamicObject data : rawData) {
                int rawYearmonth = data.getInt("yearmonth");
                if (bsedYearmonth != rawYearmonth) continue;
                String dataRecordMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u505c\u6b62\u7b97\u7a0e\u751f\u6548\u65e5\u671f\u6240\u5728\u7684\u4e2a\u7a0e\u671f\u95f4\u5b58\u5728\u4e2a\u7a0e\u6e90\u6570\u636e\u8bb0\u5f55\u3002", (String)"TaxFileSaveQuitTaxValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, dataRecordMsg);
                this.taxFileOpContext.taxFileFail(Long.valueOf(fileId), dataRecordMsg);
                continue block3;
            }
        }
    }
}

