/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public class TaxFileSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSaveValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSaveValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSaveValidator validate");
    }

    private void dealData() {
        String s1 = "by cyh  TaxFileSaveValidator validate : file.id" + this.getDataEntities()[0].getDataEntity().get("id");
        this.effectLogger.log(s1);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        this.validateBusinessKey(this.getDataEntities());
    }

    private void validateBusinessKey(ExtendedDataEntity[] dataEntities) {
        ArrayList newTaxFiles = Lists.newArrayListWithCapacity((int)dataEntities.length);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject taxFile = dataEntity.getDataEntity();
            if (taxFile.getDataEntityState().getFromDatabase() || !taxFile.getBoolean("iscurrentversion") && taxFile.getLong("boid") != 0L) continue;
            newTaxFiles.add(dataEntity);
            personIds.add(taxFile.getLong("person.id"));
        }
        if (CollectionUtils.isEmpty((Collection)personIds)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter personFilter = new QFilter("person.id", "in", (Object)personIds);
        QFilter defaultFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        defaultFilter.and(new QFilter("status", "!=", (Object)"E"));
        DynamicObject[] existTaxFiles = serviceHelper.query("id,boid,person.id,taxregion.id,taxunit.id", new QFilter[]{personFilter, defaultFilter});
        HashMap existsBizKeyMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        Arrays.stream(existTaxFiles).forEach(obj -> existsBizKeyMap.put(this.bizKey((DynamicObject)obj), obj.getString("boid")));
        String messageBizRepeat = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u4e2a\u7a0e\u7ba1\u7406\u5c5e\u5730\u76f8\u540c\u3001\u7eb3\u7a0e\u5355\u4f4d\u76f8\u540c\u7684\u4e2a\u7a0e\u6863\u6848\u5b58\u5728\u3002", (String)"TaxFileSaveValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : newTaxFiles) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String businessKey = this.bizKey(dynamicObject);
            String boid = dynamicObject.getString("boid");
            String existBoid = (String)existsBizKeyMap.get(businessKey);
            if (!StringUtils.isEmpty((CharSequence)existBoid) && !StringUtils.equals((CharSequence)boid, (CharSequence)existBoid)) {
                long taxFileId = dynamicObject.getLong("boid");
                this.taxFileOpContext.taxFileFail(Long.valueOf(taxFileId), messageBizRepeat);
                this.addMessage(dataEntity, messageBizRepeat);
                continue;
            }
            existsBizKeyMap.put(businessKey, StringUtils.isEmpty((CharSequence)boid) ? "1" : boid);
        }
    }

    private String bizKey(DynamicObject obj) {
        return obj.getString("person.id") + "-" + obj.getString("taxregion.id") + "-" + obj.getString("taxunit.id");
    }
}

