/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import org.apache.commons.lang3.StringUtils;

public class TaxFileSubInfoValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSubInfoValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext;

    public TaxFileSubInfoValidator(TaxFileOpContext taxFileOpContext) {
        this.taxFileOpContext = taxFileOpContext;
    }

    public void validate() {
        this.effectLogger.start("TaxFileSubInfoValidator validate");
        this.dealData();
        this.effectLogger.end("TaxFileSubInfoValidator validate");
    }

    private void dealData() {
        this.taxFileOpContext.setOpKey(this.getOperateKey());
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashMap objectMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashSet errorDataIndexes = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        HashSet errorEntities = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            long l;
            ExtendedDataEntity dataEntity = dataEntities[i];
            if (errorDataIndexes.contains(i)) {
                errorEntities.add(dataEntity);
            }
            if (this.taxFileOpContext.isFailed(Long.valueOf(l = dataEntity.getDataEntity().getLong("id")))) continue;
            DynamicObject dy = dataEntity.getDataEntity();
            entityMap.put(l, dataEntity);
            objectMap.put(dy.getLong("boid"), dy);
        }
        if (CollectionUtils.isEmpty((Map)objectMap)) {
            return;
        }
        this.effectLogger.start("TaxFileSubInfoValidator validate validateSubInfo");
        TaxFileInfoServiceFactory.validateSubInfo((Map)objectMap, (TaxFileOpContext)this.taxFileOpContext);
        this.effectLogger.end("TaxFileSubInfoValidator validate validateSubInfo");
        Map errorMsg = this.taxFileOpContext.getErrorMsg();
        if (!CollectionUtils.isEmpty((Map)errorMsg)) {
            for (Map.Entry entry : errorMsg.entrySet()) {
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)entityMap.get(entry.getKey());
                if (dataEntity == null || errorEntities.contains(dataEntity)) continue;
                this.addFatalErrorMessage(dataEntity, (String)entry.getValue());
            }
        }
        if (!CollectionUtils.isEmpty((Map)errorMsg)) {
            String s1 = "by cyh validateSubInfo end  errorMsg.size = " + errorMsg.size();
            this.effectLogger.log(s1);
        }
        if ("save".equals(this.getOperateKey())) {
            this.validateBsed(this.getDataEntities());
        }
    }

    private void validateBsed(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject taxFileDy = dataEntity.getDataEntity();
            String status = taxFileDy.getString("status");
            if (!"A".equals(status) || 0L != taxFileDy.getLong("sourcevid")) continue;
            Date taxFileBsed = taxFileDy.getDate("bsed");
            Long taxFileId = taxFileDy.getLong("id");
            Map extraInfo = this.taxFileOpContext.getExtraInfo();
            for (Map.Entry entry : extraInfo.entrySet()) {
                Date childEntityBsed;
                DynamicObject childEntityDy;
                MainEntityType dataEntityType;
                DataEntityPropertyCollection properties;
                if (!Strings.isNullOrEmpty((String)((String)entry.getKey())) && ((String)entry.getKey()).endsWith("taxfile") || !(properties = (dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)entry.getKey()))).getProperties()).containsKey((Object)"bsed") || !Objects.nonNull(childEntityDy = (DynamicObject)((Map)entry.getValue()).get(taxFileId)) || (childEntityBsed = childEntityDy.getDate("bsed")) == null || taxFileBsed == null || !childEntityBsed.before(taxFileBsed)) continue;
                String bsedMessage = ResManager.loadKDString((String)"{0}\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"TaxFileSubInfoValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[]{dataEntityType.getDisplayName().getLocaleValue()});
                this.taxFileOpContext.taxFileFail(taxFileId, bsedMessage);
                this.addFatalErrorMessage(dataEntity, bsedMessage);
            }
        }
    }
}

