/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.DateConverter;
import org.apache.commons.lang.StringUtils;

public class TaxDataBasicUmarkValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArray = this.getDataEntities();
        String declareStatuMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u62a5\u9001\u72b6\u6001\u4e3a\u201c\u5df2\u62a5\u9001\u201d\u7684\u8bb0\u5f55\u3002", (String)"TaxFileUnmarkValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String taxTaskPeriodNullMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u4e2a\u7a0e\u4efb\u52a1\u8d77\u6b62\u65e5\u671f\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u3002", (String)"TaxFileUnmarkValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String dateParseError = ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5f02\u5e38\u3002", (String)"TaxFileUnmarkValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String taxTaskPeriodMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u672c\u671f\u53d8\u52a8\u7684\u8bb0\u5f55\u3002", (String)"TaxFileUnmarkValidator_3", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String bizStatuMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u5df2\u5bfc\u5165\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u3002", (String)"TaxFileUnmarkValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String prepareStatuMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u5df2\u6570\u636e\u51c6\u5907\u5b8c\u6210\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u3002", (String)"TaxFileUnmarkValidator_5", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String calStatuMess = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7%s\uff1a\u5df2\u5bfc\u5165\u7b97\u85aa\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6807\u8bb0\u62a5\u9001\u3002", (String)"TaxFileUnmarkValidator_6", (String)"sit-itc-opplugin", (Object[])new Object[0]);
        String taskStart = this.getOption().getVariableValue("taxstartdate");
        String taskEnd = this.getOption().getVariableValue("taxenddate");
        if (StringUtils.isEmpty((String)taskStart) || StringUtils.isEmpty((String)taskEnd)) {
            Arrays.stream(dataEntityArray).forEach(entity -> this.addFatalErrorMessage((ExtendedDataEntity)entity, taxTaskPeriodNullMess));
            return;
        }
        Date taskStartDate = (Date)DateConverter.convert((Object)taskStart, Date.class);
        Date taskEndDate = (Date)DateConverter.convert((Object)taskEnd, Date.class);
        if (taskStartDate == null || taskEndDate == null) {
            Arrays.stream(dataEntityArray).forEach(entity -> this.addFatalErrorMessage((ExtendedDataEntity)entity, dateParseError));
            return;
        }
        ArrayList basicIds = Lists.newArrayListWithCapacity((int)dataEntityArray.length);
        Arrays.stream(dataEntityArray).forEach(obj -> basicIds.add(obj.getDataEntity().getLong("id")));
        Map<Long, DynamicObject> declareInfoMap = this.queryDeclareInfos(basicIds);
        for (ExtendedDataEntity dataEntity : dataEntityArray) {
            DynamicObject basicDyn = dataEntity.getDataEntity();
            Date declareMonth = null;
            DynamicObject declareInfo = declareInfoMap.get(basicDyn.getLong("id"));
            if (declareInfo != null) {
                declareMonth = declareInfo.getDate("declaremonth");
            }
            String declareStatus = basicDyn.getString("declarestatus");
            String bizStatus = basicDyn.getString("bizstatus");
            String prepareStatus = basicDyn.getString("preparestatus");
            String srcRefNumStr = basicDyn.getString("srcrefnum");
            Integer srcRefNum = 0;
            if (!StringUtils.isEmpty((String)srcRefNumStr)) {
                srcRefNum = Integer.valueOf(srcRefNumStr);
            }
            if (!StringUtils.equals((String)declareStatus, (String)"1")) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, declareStatuMess, basicDyn.getString("taxfile.number")));
                continue;
            }
            if (!SitDateUtil.isCover((Date)declareMonth, (Date)taskStartDate, (Date)taskEndDate)) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, taxTaskPeriodMess, basicDyn.getString("taxfile.number")));
                continue;
            }
            if (StringUtils.equals((String)bizStatus, (String)"1") && YesOrNoEnum.YES.getCode().equals(basicDyn.getString("taxfile.taxstatus"))) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, bizStatuMess, basicDyn.getString("taxfile.number")));
                continue;
            }
            if (StringUtils.equals((String)prepareStatus, (String)"1") && YesOrNoEnum.YES.getCode().equals(basicDyn.getString("taxfile.taxstatus"))) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, prepareStatuMess, basicDyn.getString("taxfile.number")));
                continue;
            }
            if (srcRefNum <= 0) continue;
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, calStatuMess, basicDyn.getString("taxfile.number")));
        }
    }

    private Map<Long, DynamicObject> queryDeclareInfos(List<Long> basicIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        DynamicObject[] query = serviceHelper.query("taxdatabasicid,declaremonth,declarestatus,declareway", new QFilter[]{new QFilter("taxdatabasicid", "in", basicIds)});
        HashMap map = Maps.newHashMapWithExpectedSize((int)basicIds.size());
        if (query != null && query.length > 0) {
            Arrays.stream(query).forEach(obj -> map.put(obj.getLong("taxdatabasicid.id"), obj));
        }
        return map;
    }
}

