/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.web.tax;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileAuditValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSubInfoValidator;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public class TaxFileAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log LOGGER = LogFactory.getLog(TaxFileAuditOp.class);
    private final TaxFileOpContext taxFileOpContext = new TaxFileOpContext();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber((String)"itc_taxfile");
        fieldKeys.addAll(infoService.propMappings().values());
        fieldKeys.add("bsled");
        fieldKeys.add("status");
        fieldKeys.add("declarestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaxFileSubInfoValidator(this.taxFileOpContext));
        args.addValidator((AbstractValidator)new TaxFileAuditValidator(this.taxFileOpContext));
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] taxFiles = args.getDataEntities();
        if (taxFiles == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        TaxFileInfoServiceFactory.invokeSubInfoOp((DynamicObject[])taxFiles, (TaxFileOpContext)this.taxFileOpContext);
        LOGGER.info("TaxFileInfoServiceFactory.invokeSubInfoOp use time:{}", (Object)(System.currentTimeMillis() - startTime));
        List taxFileIds = Arrays.stream(taxFiles).filter(taxfile -> DataStatusEnum.EFFECTING.getCode().equals(taxfile.get("datastatus")) || DataStatusEnum.TO_EFFECT.getCode().equals(taxfile.get("datastatus")) && "1".equals(taxfile.getString("taxstatus"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(taxFileIds)) {
            startTime = System.currentTimeMillis();
            TaxFileServiceHelper.applyPersonCert(taxFileIds);
            LOGGER.info("TaxFileServiceHelper.applyPersonCert use time:{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }
}

