/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.web.tax;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileDeleteValidator;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxFileDeleteOp
extends AbstractOperationServicePlugIn {
    private final TaxFileOpContext taxFileOpContext = new TaxFileOpContext();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("person.personindexid");
        fieldKeys.add("bred");
        fieldKeys.add("bsled");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaxFileDeleteValidator(this.taxFileOpContext));
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] delDatas = args.getDataEntities();
        if (delDatas == null) {
            return;
        }
        ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>();
        HashMap delIdAndNumMap = Maps.newHashMapWithExpectedSize((int)delDatas.length);
        ArrayList<DynamicObject> abandonList = new ArrayList<DynamicObject>();
        for (DynamicObject delDyn : delDatas) {
            if (this.taxFileOpContext.isFailed(Long.valueOf(delDyn.getLong("id")))) continue;
            if ("A".equals(delDyn.getString("status"))) {
                deleteList.add(delDyn);
                delIdAndNumMap.put(delDyn.getLong("id"), delDyn.getString("number"));
                continue;
            }
            abandonList.add(delDyn);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
            DynamicObject[] deleteFiles = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", delIdAndNumMap.keySet())});
            String[] numArry = new String[deleteFiles.length];
            for (int i = 0; i < deleteFiles.length; ++i) {
                numArry[i] = (String)delIdAndNumMap.get(deleteFiles[i].getLong("id"));
            }
            CodeRuleServiceHelper.recycleBatchNumber((String)this.billEntityType.getName(), (DynamicObject[])deleteFiles, null, (String[])numArry);
            BaseResult result = TaxFileInfoServiceFactory.deleteTaxFiles(deleteList);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(abandonList)) {
            BaseResult result = TaxFileInfoServiceFactory.abandonTaxFiles(abandonList);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            TaxFileServiceHelper.releasePersonCert((List)Lists.newArrayList((Iterable)abandonList.stream().map(ele -> ele.getLong("id")).collect(Collectors.toList())));
        }
    }
}

