/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.web.tax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.opplugin.validator.taxfile.PersonCertValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileBillSplitValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileImportPersonValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileNumberValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFilePermissionValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSaveFillIdValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSaveInfoGatherValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSavePersonInfoValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSaveQuitTaxValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSaveValidator;
import kd.sit.itc.opplugin.validator.taxfile.TaxFileSubInfoValidator;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SitDateUtil;
import org.apache.commons.lang3.StringUtils;

public class TaxFileSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(TaxFileSaveOp.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final TaxFileOpContext taxFileOpContext = new TaxFileOpContext();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber((String)"itc_taxfile");
        fieldKeys.addAll(infoService.propMappings().values());
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        String outerInfoStr = this.getOption().getVariableValue("outerInfo", "");
        if (StringUtils.isNotEmpty((CharSequence)outerInfoStr)) {
            this.taxFileOpContext.putOptionPara("outerInfo", outerInfoStr);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        String actionWay;
        Map variables = this.getOption().getVariables();
        LOGGER.info("Trace by Quinn TaxFileSaveOp.onAddValidators: {}", (Object)SerializationUtils.toJsonString((Object)variables));
        String outerInfoStr = this.getOption().getVariableValue("outerInfo", "");
        this.taxFileOpContext.putOptionPara("sourceFrom", "save");
        if (StringUtils.isNotEmpty((CharSequence)outerInfoStr)) {
            this.taxFileOpContext.putOptionPara("outerInfo", outerInfoStr);
            this.taxFileOpContext.putOptionPara("status", this.getOption().getVariableValue("status"));
            this.taxFileOpContext.putOptionPara("src", this.getOption().getVariableValue("src"));
        }
        if (StringUtils.equals((CharSequence)(actionWay = this.getOption().getVariableValue("ITCFILE_ACTIONWAY", "0")), (CharSequence)"2") || StringUtils.equals((CharSequence)actionWay, (CharSequence)"1")) {
            args.addValidator((AbstractValidator)new TaxFilePermissionValidator());
        }
        args.addValidator((AbstractValidator)new TaxFileSaveFillIdValidator(this.taxFileOpContext));
        if (StringUtils.equals((CharSequence)actionWay, (CharSequence)"2")) {
            args.addValidator((AbstractValidator)new TaxFileImportPersonValidator(this.taxFileOpContext));
        }
        args.addValidator((AbstractValidator)new TaxFileSavePersonInfoValidator(this.taxFileOpContext));
        if (StringUtils.equals((CharSequence)actionWay, (CharSequence)"2")) {
            args.addValidator((AbstractValidator)new TaxFileBillSplitValidator(this.taxFileOpContext));
        }
        args.addValidator((AbstractValidator)new TaxFileSaveQuitTaxValidator(this.taxFileOpContext));
        args.addValidator((AbstractValidator)new TaxFileSaveInfoGatherValidator(this.taxFileOpContext));
        args.addValidator((AbstractValidator)new TaxFileSaveValidator(this.taxFileOpContext));
        args.addValidator((AbstractValidator)new TaxFileSubInfoValidator(this.taxFileOpContext));
        String statusParam = this.getOption().getVariableValue("status", null);
        if ("C".equals(statusParam)) {
            args.addValidator((AbstractValidator)new PersonCertValidator());
        }
        args.addValidator((AbstractValidator)new TaxFileNumberValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        LOGGER.info("by cyh endOperationTransaction file.id = {}", dataEntities[0].get("id"));
        this.effectLogger.start("TaxFileSaveOp endOperationTransaction");
        if ("saveafteraudit".equals(operationKey)) {
            ArrayList stopTaxIds = Lists.newArrayListWithCapacity((int)dataEntities.length);
            ArrayList normalTaxIds = Lists.newArrayListWithCapacity((int)dataEntities.length);
            int today = SitDateUtil.toYearMonthDay((Date)new Date());
            Arrays.stream(dataEntities).filter(ele -> DataStatusEnum.EFFECTING.getCode().equals(ele.getString("datastatus")) || DataStatusEnum.TO_EFFECT.getCode().equals(ele.getString("datastatus"))).forEach(ele -> {
                int bsed = SitDateUtil.toYearMonthDay((Date)ele.getDate("bsed"));
                if ("0".equals(ele.getString("taxstatus"))) {
                    if (bsed <= today) {
                        stopTaxIds.add(ele.getLong("id"));
                    }
                } else if ("1".equals(ele.getString("taxstatus"))) {
                    normalTaxIds.add(ele.getLong("id"));
                }
            });
            TaxFileServiceHelper.releasePersonCert((List)stopTaxIds);
            TaxFileServiceHelper.applyPersonCert((List)normalTaxIds);
            String src = this.getOption().getVariableValue("src", "");
            if (StringUtils.endsWithIgnoreCase((CharSequence)src, (CharSequence)"SYNAPI")) {
                this.effectLogger.start("TaxFileSaveOp endOperationTransaction invokeSubInfoOp");
                TaxFileInfoServiceFactory.invokeSubInfoOp((DynamicObject[])dataEntities, (TaxFileOpContext)this.taxFileOpContext);
                this.effectLogger.end("TaxFileSaveOp endOperationTransaction invokeSubInfoOp");
            }
        } else {
            this.taxFileOpContext.reMappingFileId();
            this.saveNewVersionFile(dataEntities);
            this.effectLogger.start("TaxFileSaveOp endOperationTransaction invokeSubInfoOp");
            TaxFileInfoServiceFactory.invokeSubInfoOp((DynamicObject[])dataEntities, (TaxFileOpContext)this.taxFileOpContext);
            this.effectLogger.end("TaxFileSaveOp endOperationTransaction invokeSubInfoOp");
            String statusParam = this.getOption().getVariableValue("status", null);
            if (statusParam != null && "C".equals(statusParam)) {
                List taxIds = Arrays.stream(dataEntities).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                TaxFileServiceHelper.applyPersonCert(taxIds);
            }
        }
        this.effectLogger.end("TaxFileSaveOp endOperationTransaction");
    }

    private void saveNewVersionFile(DynamicObject[] dataEntities) {
        String action = this.getOption().getVariableValue("ITCFILE_ACTIONWAY", "");
        DynamicObject currUser = new HRBaseServiceHelper("bos_user").generateEmptyDynamicObject();
        currUser.set("id", (Object)RequestContext.get().getCurrUserId());
        Date currDate = new Date();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"2")) {
            ArrayList newVersions = Lists.newArrayListWithCapacity((int)dataEntities.length);
            for (DynamicObject value : dataEntities) {
                if (value.getBoolean("iscurrentversion") || !StringUtils.equals((CharSequence)value.getString("status"), (CharSequence)"A")) continue;
                value.set("creator", (Object)currUser);
                value.set("createtime", (Object)currDate);
                value.set("modifier", (Object)currUser);
                value.set("modifytime", (Object)currDate);
                newVersions.add(value);
            }
            if (CollectionUtils.isEmpty((Collection)newVersions)) {
                return;
            }
            String entityCode = ((DynamicObject)newVersions.get(0)).getDataEntityType().getName();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
            List<Object> ids = newVersions.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            serviceHelper.delete(ids.toArray(new Object[ids.size()]));
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setHisDyns(newVersions.toArray(new DynamicObject[newVersions.size()]));
            hisVersionParamBo.setEntityNumber(entityCode);
            hisVersionParamBo.setEffImmediately(true);
            hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
            HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        }
    }
}

