/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.web.taxdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.opplugin.validator.taxtask.TaxDataBasicUmarkValidator;

public class TaxDataBasicUmmarkOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("taxfile");
        fieldKeys.add("taxfile.boid");
        fieldKeys.add("taxfile.number");
        fieldKeys.add("taxfile.declaremonth");
        fieldKeys.add("declarestatus");
        fieldKeys.add("bizstatus");
        fieldKeys.add("preparestatus");
        fieldKeys.add("srcrefnum");
        fieldKeys.add("calstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaxDataBasicUmarkValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] basicDyns = args.getDataEntities();
        ArrayList<Long> basicIds = new ArrayList<Long>(10);
        long creator = RequestContext.get().getCurrUserId();
        Date operateDate = new Date();
        for (DynamicObject basic : basicDyns) {
            basicIds.add(basic.getLong("id"));
            basic.set("declarestatus", (Object)"0");
            basic.set("modifytime", (Object)operateDate);
            basic.set("modifier", (Object)creator);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        serviceHelper.save(basicDyns);
        this.updateDeclareInfo(basicIds);
    }

    private void updateDeclareInfo(List<Long> basicIds) {
        DynamicObject[] existDeclareInfos;
        long creator = RequestContext.get().getCurrUserId();
        Date operateDate = new Date();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        String fileds = "declaremonth,declarestatus,declareway,modifytime,modifier";
        for (DynamicObject declareInfo : existDeclareInfos = serviceHelper.query(fileds, new QFilter[]{new QFilter("taxdatabasicid", "in", basicIds)})) {
            declareInfo.set("declaremonth", null);
            declareInfo.set("declarestatus", (Object)"0");
            declareInfo.set("declareway", null);
            declareInfo.set("modifytime", (Object)operateDate);
            declareInfo.set("modifier", (Object)creator);
        }
        serviceHelper.save(existDeclareInfos);
    }
}

