/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.web.taxtask;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.opplugin.validator.taxtask.TaxTaskSaveValidator;

public class TaxTaskSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("taxtaskcatgentry");
        fieldKeys.add("taxtasktype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaxTaskSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = args.getDataEntities()) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("taxtaskunitentry");
            DynamicObjectCollection taxUnitDys = dynamicObject.getDynamicObjectCollection("taxunitcol");
            taxUnitDys.clear();
            for (DynamicObject entity : entryEntity) {
                DynamicObject taxUnitDy = entity.getDynamicObject("taxunit");
                DynamicObject dy = taxUnitDys.addNew();
                dy.set("fbasedataid_id", (Object)taxUnitDy.getLong("id"));
            }
            dynamicObject.set("taxunitcol", (Object)taxUnitDys);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = args.getDataEntities()) {
            long id = dynamicObject.getLong("id");
            TaxTaskServiceHelper.clearCache((Long)id);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Set ids = Arrays.asList(dataEntities).stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] currDys = helper.query("id,taxtaskcatgentry.taxcategory,taxtaskcatgentry.taxdatanum", new QFilter[]{filter});
        TaxTaskServiceHelper.createTaxTaskSnapshot((DynamicObject[])currDys);
    }
}

