/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;

public class ITCFixedFieldListPlugin
extends AbstractListPlugin {
    private Map<String, List<String>> fixFieldListMap;
    private static final String PARAM_ISFIXED = "param_isfixed";

    public void initialize() {
        super.initialize();
        this.initFixFieldListMap();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List<String> fixedFieldKeyList = this.getFixedFieldKeyList();
        if (CollectionUtils.isEmpty(fixedFieldKeyList)) {
            return;
        }
        List<IListColumn> columns = args.getListColumns().stream().filter(column -> fixedFieldKeyList.contains(column.getListFieldKey())).collect(Collectors.toList());
        columns.forEach(column -> column.setFixed(true));
    }

    private List<String> getFixedFieldKeyList() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getBillFormId();
        return this.fixFieldListMap.get(formId);
    }

    private void initFixFieldListMap() {
        this.fixFieldListMap = new HashMap<String, List<String>>(16);
        ArrayList<String> taxFileGuideBlockFixFieldList = new ArrayList<String>(3);
        taxFileGuideBlockFixFieldList.add("person.name");
        taxFileGuideBlockFixFieldList.add("person.number");
        taxFileGuideBlockFixFieldList.add("number");
        this.fixFieldListMap.put("itc_taxfile", taxFileGuideBlockFixFieldList);
        ArrayList<String> taxTaskList = new ArrayList<String>(3);
        taxTaskList.add("taxfile.taxperson.name");
        taxTaskList.add("taxfile.taxperson.number");
        taxTaskList.add("taxfile.number");
        this.fixFieldListMap.put("itc_taxpreparedata", taxTaskList);
        this.fixFieldListMap.put("itc_taxdatastep1", taxTaskList);
        this.fixFieldListMap.put("itc_taxdatastep2", taxTaskList);
        this.fixFieldListMap.put("itc_taxdatastep05", taxTaskList);
        this.fixFieldListMap.put("itc_taxdatastep3", taxTaskList);
        ArrayList<String> taxTaskBlockFixFieldList = new ArrayList<String>();
        taxTaskBlockFixFieldList.add("number");
        taxTaskBlockFixFieldList.add("name");
        this.fixFieldListMap.put("itc_taxtask", taxTaskBlockFixFieldList);
        ArrayList<String> taxRawList = new ArrayList<String>(3);
        taxRawList.add("taxfile.taxperson.name");
        taxRawList.add("taxfile.taxperson.number");
        taxRawList.add("taxfile.number");
        this.fixFieldListMap.put("itc_taxrawdata", taxRawList);
    }
}

