/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.accresult;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.itc.business.accresult.AccResultHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataPrecisionEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;

public class AccResultEditPlugin
extends HRDataBaseEdit
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(AccResultEditPlugin.class);
    private static final String TAXFILE = "taxfile";
    private static final String ACCUMULATOR = "accumulator";
    private static final String INSTANCENUM = "instancenum";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String CURRENCY = "currency";
    private static final String RESULTVALUE = "resultvalue";
    private static final String ACCRESULTENTRY = "accresultentry";
    private static final String BAR_MODIFY = "bar_modify";

    public void initialize() {
        super.initialize();
        EntryGrid entry = (EntryGrid)this.getControl(ACCRESULTENTRY);
        entry.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        if (formShowParameter != null && OperationStatus.ADDNEW.equals((Object)formShowParameter.getStatus())) {
            formShowParameter.getFormConfig().setCaption(ResManager.getLocaleString((String)"\u65b0\u589e\u7d2f\u52a0\u5b9e\u4f8b", (String)"AccResultEditPlugin_8", (String)"sit-itc-formplugin"));
        }
    }

    public void registerListener(EventObject eventObject) {
        BasedataEdit taxFileBE = (BasedataEdit)this.getControl(TAXFILE);
        BasedataEdit accumulatorBE = (BasedataEdit)this.getControl(ACCUMULATOR);
        taxFileBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        accumulatorBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        switch (key = basedataEdit.getKey()) {
            case "taxfile": {
                this.showTaxFileF7(evt);
                break;
            }
            case "accumulator": {
                this.showAccF7(evt);
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        DynamicObject accumulator;
        super.afterBindData(eventObject);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String op = (String)this.getView().getFormShowParameter().getCustomParam("op");
        if (OperationStatus.EDIT.equals((Object)status) && !"hyper".equals(op)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "entrytoolbar", "addnew", "deletenew"});
            this.setForeColor(OperationStatus.EDIT);
        } else if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_MODIFY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "entrytoolbar", "addnew", "deletenew"});
            this.setForeColor(OperationStatus.VIEW);
        } else if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_MODIFY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "entrytoolbar", "addnew", "deletenew"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "entrytoolbar", "addnew", "deletenew"});
        }
        int amtPrecision = 2;
        if ("addnewaccresult".equals(op) && OperationStatus.ADDNEW.equals((Object)status)) {
            this.updateResultValueScale(0);
            accumulator = this.getModel().getDataEntity().getDynamicObject(ACCUMULATOR);
            if (Objects.isNull(accumulator)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{INSTANCENUM});
            }
        } else {
            accumulator = this.getModel().getDataEntity().getDynamicObject(ACCUMULATOR);
            if (Objects.nonNull(accumulator)) {
                long dataTypeId = accumulator.getLong("datatype.id");
                if (SitDataTypeEnum.AMOUNT == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                    DynamicObject currency = AccResultHelper.getCurrency((Long)1L);
                    if (Objects.nonNull(currency)) {
                        amtPrecision = currency.getInt("amtprecision");
                    }
                } else if (SitDataTypeEnum.NUMBER == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                    long dataPrecisionId = accumulator.getLong("dataprecision.id");
                    amtPrecision = DataPrecisionEnum.scaleById((long)dataPrecisionId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{CURRENCY});
                }
                this.updateResultValueScale(amtPrecision);
            }
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ACCRESULTENTRY, "setColEditorProp", new Object[]{"changevalue", "sc", amtPrecision});
    }

    private void setForeColor(OperationStatus status) {
        HashMap item = Maps.newHashMap();
        if (OperationStatus.VIEW == status) {
            item.put("fc", "#212121");
        } else if (OperationStatus.EDIT == status) {
            item.put("fc", "#999");
        }
        HashMap props = Maps.newHashMap();
        props.put("item", item);
        props.put("fc", "#666");
        this.getView().updateControlMetadata(TAXFILE, (Map)props);
        this.getView().updateControlMetadata("personnumber", (Map)props);
        this.getView().updateControlMetadata("personname", (Map)props);
        this.getView().updateControlMetadata(ACCUMULATOR, (Map)props);
        this.getView().updateControlMetadata("accnumber", (Map)props);
        this.getView().updateControlMetadata("frequency", (Map)props);
        this.getView().updateControlMetadata(INSTANCENUM, (Map)props);
        this.getView().updateControlMetadata(STARTDATE, (Map)props);
        this.getView().updateControlMetadata(ENDDATE, (Map)props);
        this.getView().updateControlMetadata(CURRENCY, (Map)props);
        this.getView().updateControlMetadata(RESULTVALUE, (Map)props);
    }

    private void showAccF7(BeforeF7SelectEvent evt) {
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter countryQFilter = new QFilter("country", "=", (Object)1000001L);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{enableFilter, statusQFilter, countryQFilter});
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setQFilters((List)filters);
    }

    private void showTaxFileF7(BeforeF7SelectEvent evt) {
        QFilter dataRuleForBdProp;
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter taxStatusQFilter = new QFilter("taxstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter taxRegionQFilter = new QFilter("taxregion", "=", (Object)1000001L);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{enableFilter, statusQFilter, taxStatusQFilter, taxRegionQFilter});
        HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"30", (String)"17/+CT1QBPNP", (String)"itc_accresult", (String)"47156aff000000ac");
        LOGGER.info("AccResultEditPlugin.permOrgs.hasAllOrgPerm: {} - {}", (Object)permOrgResult.hasAllOrgPerm(), (Object)permOrgResult.getHasPermOrgs());
        if (!permOrgResult.hasAllOrgPerm()) {
            if (CollectionUtils.isEmpty((Collection)permOrgResult.getHasPermOrgs())) {
                filters.add(new QFilter("1", "=", (Object)2));
            } else {
                filters.add(new QFilter("org.id", "in", (Object)permOrgResult.getHasPermOrgs()));
            }
        }
        if ((dataRuleForBdProp = SITPermissionServiceHelper.getDataRuleForBdProp((String)"17/+CT1QBPNP", (String)"itc_accresult", (String)TAXFILE)) != null) {
            filters.add(dataRuleForBdProp);
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setQFilters((List)filters);
        listShowParameter.setCustomParam("isShowUsed", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "accumulator": {
                this.unlockAndSetDateAndCurrency(args);
                break;
            }
            case "instancenum": {
                this.setAndCheckStartDateAndEndDate(args);
                break;
            }
        }
    }

    private void setAndCheckStartDateAndEndDate(PropertyChangedArgs args) {
        int startDay;
        BaseResult result;
        int inputMonthValue;
        int startMonthVal;
        LocalDate inputStartDate;
        ChangeData[] changeData = args.getChangeSet();
        Integer newInstanceNum = (Integer)changeData[0].getNewValue();
        Integer oldInstanceNum = (Integer)changeData[0].getOldValue();
        try {
            inputStartDate = AccResultHelper.checkInstanceNum((Integer)newInstanceNum);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u7684\u683c\u5f0f\u6709\u8bef\u3002", (String)"AccResultEditPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(INSTANCENUM, (Object)oldInstanceNum);
            return;
        }
        DynamicObject accDy = this.getModel().getDataEntity().getDynamicObject(ACCUMULATOR);
        String periodType = accDy.getString("periodtype");
        if ("1".equals(periodType)) {
            startMonthVal = accDy.getInt("startmonthval");
            inputMonthValue = inputStartDate.getMonthValue();
            if (inputMonthValue != startMonthVal) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u4e0e\u6240\u9009\u7d2f\u52a0\u5668\u7684\u5f00\u59cb\u6708\u503c\u4e0d\u540c\u3002", (String)"AccResultEditPlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(INSTANCENUM, (Object)oldInstanceNum);
                return;
            }
        }
        if ("2".equals(periodType) && !(result = AccResultHelper.checkMonthValueInQuarterAcc((int)(startMonthVal = accDy.getInt("startmonthval")), (int)(inputMonthValue = inputStartDate.getMonthValue()))).isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            this.getModel().setValue(INSTANCENUM, (Object)oldInstanceNum);
            return;
        }
        this.getModel().beginInit();
        int actualStartDay = startDay = accDy.getInt("startday");
        int lastDayOfMonth = inputStartDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
        startDay = Math.min(startDay, lastDayOfMonth);
        LocalDateTime tmpStartDate = LocalDateTime.of(inputStartDate.getYear(), inputStartDate.getMonthValue(), startDay, 0, 0, 0);
        Date startDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        this.getModel().setValue(STARTDATE, (Object)startDate);
        LocalDateTime tmpEndDate = "1".equals(periodType) ? AccResultHelper.setYearPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay) : ("2".equals(periodType) ? AccResultHelper.setQuarterPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay) : ("3".equals(periodType) ? AccResultHelper.setMonthPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay) : LocalDateTime.of(2999, 12, 31, 0, 0, 0)));
        tmpEndDate = tmpEndDate.plusHours(23L).plusMinutes(59L).plusSeconds(59L);
        Date endDate = Date.from(tmpEndDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        this.getModel().setValue(ENDDATE, (Object)endDate);
        this.getModel().endInit();
        this.getView().updateView(STARTDATE);
        this.getView().updateView(ENDDATE);
    }

    private void unlockAndSetDateAndCurrency(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        DynamicObject newAcc = (DynamicObject)changeData[0].getNewValue();
        if (Objects.nonNull(newAcc)) {
            long dataTypeId = newAcc.getLong("datatype.id");
            int amtPrecision = 2;
            if (SitDataTypeEnum.AMOUNT == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CURRENCY});
                this.getModel().setValue(CURRENCY, (Object)1L);
                DynamicObject currency = AccResultHelper.getCurrency((Long)1L);
                if (Objects.nonNull(currency)) {
                    amtPrecision = currency.getInt("amtprecision");
                }
            } else if (SitDataTypeEnum.NUMBER == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CURRENCY});
                this.getModel().setValue(CURRENCY, null);
                long dataPrecisionId = newAcc.getLong("dataprecision.id");
                amtPrecision = DataPrecisionEnum.scaleById((long)dataPrecisionId);
            }
            this.updateResultValueScale(amtPrecision);
            this.getModel().beginInit();
            String periodType = newAcc.getString("periodtype");
            if ("1".equals(periodType) || "2".equals(periodType)) {
                int startDay;
                int startMonthVal = newAcc.getInt("startmonthval");
                int actualStartDay = startDay = newAcc.getInt("startday");
                int lastDayOfMonth = LocalDate.of(Year.now().getValue(), startMonthVal, 1).with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                startDay = Math.min(startDay, lastDayOfMonth);
                LocalDateTime tmpStartDate = LocalDateTime.of(Year.now().getValue(), startMonthVal, startDay, 0, 0, 0);
                Date startDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
                this.getModel().setValue(STARTDATE, (Object)startDate);
                LocalDateTime tmpEndDate = "1".equals(periodType) ? AccResultHelper.setYearPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay) : AccResultHelper.setQuarterPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay);
                tmpEndDate = tmpEndDate.plusHours(23L).plusMinutes(59L).plusSeconds(59L);
                Date endDate = Date.from(tmpEndDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
                this.getModel().setValue(ENDDATE, (Object)endDate);
                this.getView().setEnable(Boolean.TRUE, new String[]{INSTANCENUM});
            } else if ("3".equals(periodType)) {
                int startDay;
                int actualStartDay = startDay = newAcc.getInt("startday");
                int lastDayOfMonth = LocalDate.of(Year.now().getValue(), YearMonth.now().getMonth(), 1).with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                startDay = Math.min(startDay, lastDayOfMonth);
                LocalDateTime tmpStartDate = LocalDateTime.of(Year.now().getValue(), YearMonth.now().getMonth(), startDay, 0, 0, 0);
                Date startDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
                this.getModel().setValue(STARTDATE, (Object)startDate);
                LocalDateTime tmpEndDate = AccResultHelper.setMonthPeriodTypeAccEndDate((LocalDateTime)tmpStartDate, (int)actualStartDay);
                tmpEndDate = tmpEndDate.plusHours(23L).plusMinutes(59L).plusSeconds(59L);
                Date endDate = Date.from(tmpEndDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
                this.getModel().setValue(ENDDATE, (Object)endDate);
                this.getView().setEnable(Boolean.TRUE, new String[]{INSTANCENUM});
            } else {
                Date startDate = newAcc.getDate(STARTDATE);
                this.getModel().setValue(STARTDATE, (Object)startDate);
                LocalDateTime endDate = LocalDateTime.of(2999, 12, 31, 23, 59, 59);
                this.getModel().setValue(ENDDATE, (Object)Date.from(endDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
                this.getView().setEnable(Boolean.FALSE, new String[]{INSTANCENUM});
            }
            Date startDate = this.getModel().getDataEntity().getDate(STARTDATE);
            int instanceNum = AccResultHelper.getInstanceNum((Date)startDate);
            this.getModel().setValue(INSTANCENUM, (Object)instanceNum);
            this.getModel().endInit();
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(ACCRESULTENTRY, "setColEditorProp", new Object[]{"changevalue", "sc", amtPrecision});
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(STARTDATE, null);
            this.getModel().setValue(ENDDATE, null);
            this.getModel().setValue(CURRENCY, null);
            this.getModel().setValue(INSTANCENUM, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{INSTANCENUM});
            this.updateResultValueScale(0);
            this.getModel().endInit();
            this.getModel().deleteEntryData(ACCRESULTENTRY);
        }
        this.getView().updateView(STARTDATE);
        this.getView().updateView(INSTANCENUM);
        this.getView().updateView(ENDDATE);
        this.getView().updateView(CURRENCY);
        this.getView().updateView(ACCRESULTENTRY);
    }

    private void updateResultValueScale(int amtPrecision) {
        HashMap map = Maps.newHashMap();
        map.put("sc", amtPrecision);
        HashMap item = Maps.newHashMap();
        item.put("item", map);
        this.getView().updateControlMetadata(RESULTVALUE, (Map)item);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject accDy;
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        if ("newentry".equals(operateKey) && Objects.isNull(accDy = this.getModel().getDataEntity().getDynamicObject(ACCUMULATOR))) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7d2f\u52a0\u5668\u518d\u6dfb\u52a0\u8c03\u6574\u8bb0\u5f55\u3002", (String)"AccResultEditPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        if ("save".equals(operateKey)) {
            OperateOption option = fo.getOption();
            option.setVariableValue("op", "frompage");
            return;
        }
        if ("deleteentry".equals(operateKey)) {
            EntryGrid accResultEntry = (EntryGrid)this.getControl(ACCRESULTENTRY);
            int[] selectRows = accResultEntry.getSelectRows();
            ArrayList rows = Lists.newArrayListWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject accResultEntryDy = this.getModel().getEntryRowEntity(ACCRESULTENTRY, selectRow);
                long id = accResultEntryDy.getLong("id");
                if (0L == id) continue;
                rows.add(String.valueOf(selectRow + 1));
            }
            if (!CollectionUtils.isEmpty((Collection)rows)) {
                String join = String.join((CharSequence)"\u3001", rows);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u6570\u636e\u5df2\u4fdd\u5b58\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AccResultEditPlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{join}));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && (operationResult = args.getOperationResult()).isSuccess()) {
            this.getView().setStatus(OperationStatus.EDIT);
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().updateView();
            this.lockEntry();
            this.getPageCache().put("entrysize", SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(ACCRESULTENTRY).size()));
        }
        if ("modify".equals(operateKey)) {
            this.getView().getFormShowParameter().setCustomParam("op", null);
            this.getView().updateView();
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        String sizeStr = this.getPageCache().get("entrysize");
        if (Strings.isNullOrEmpty((String)sizeStr)) {
            this.lockEntry();
            this.getPageCache().put("entrysize", SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(ACCRESULTENTRY).size()));
        } else {
            int size = Integer.parseInt(sizeStr);
            for (int i = 0; i < size; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"changevalue", "changereason"});
            }
        }
    }

    private void lockEntry() {
        DynamicObjectCollection entryentities = this.getModel().getEntryEntity(ACCRESULTENTRY);
        for (int i = 0; i < entryentities.size(); ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"changevalue", "changereason"});
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            return;
        }
        String key = this.getPageCache().get("close");
        if ("continue_close".equals(key)) {
            return;
        }
        boolean isChange = this.getModel().getDataChanged();
        if (isChange && event.isCheckDataChange()) {
            event.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AccResultEditPlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AccResultEditPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AccResultEditPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            String changeDesc = this.getModel().getChangeDesc();
            this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "continue_close": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.getPageCache().put("close", "continue_close");
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void beforeAddRow(BeforeAddRowEventArgs eventArgs) {
    }

    public void afterAddRow(AfterAddRowEventArgs args) {
    }
}

