/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.accresult;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.accresult.AccResultHelper;
import kd.sit.itc.business.taxtaskguide.task.SitLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataPrecisionEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AccResultListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(AccResultListPlugin.class);
    private static final String CALLBACK_IMPORT = "callBack_import";

    public void packageData(PackageDataEvent event) {
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        if ("resultvalue".equals(columnDesc.getFieldKey())) {
            int precision = 2;
            DynamicObject rowData = event.getRowData();
            long dataTypeId = rowData.getLong("accumulator.datatype.id");
            if (SitDataTypeEnum.AMOUNT == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                DynamicObject currency = rowData.getDynamicObject("currency");
                if (Objects.nonNull(currency)) {
                    precision = currency.getInt("amtprecision");
                }
            } else if (SitDataTypeEnum.NUMBER == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
                long dataPrecisionId = rowData.getLong("accumulator.dataprecision.id");
                precision = DataPrecisionEnum.scaleById((long)dataPrecisionId);
            }
            BigDecimal resultValue = rowData.getBigDecimal("resultvalue");
            BigDecimal bigDecimal = resultValue.setScale(precision, RoundingMode.valueOf(DataRoundEnum.roundById((long)rowData.getLong("accumulator.dataround.id"))));
            event.setFormatValue((Object)bigDecimal.toPlainString());
        }
    }

    private void openAddNewAccResultPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("itc_accresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("op", (Object)"addnewaccresult");
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("accumulator_number".equals(fieldName)) {
            args.setCancel(true);
            Long pkId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("itc_accresult");
            baseShowParameter.setPkId((Object)pkId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setCustomParam("op", (Object)"hyper");
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        if ("new".equals(operateKey)) {
            args.setCancel(true);
            long userId = RequestContext.get().getCurrUserId();
            BillList list = (BillList)this.getControl("billlistap");
            String entityName = list.getEntityType().getName();
            boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)userId, (String)"17/+CT1QBPNP", (String)entityName, (String)"2YNU1A=ZE69+");
            if (hasPerm) {
                SitLogServiceHelper.addLog((IFormView)this.getView(), (String)fo.getOperateName().getLocaleValue(), (String)ResManager.loadKDString((String)"\u521b\u5efa\u7d2f\u52a0\u5b9e\u4f8b", (String)"AccResultListPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                this.openAddNewAccResultPage();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7d2f\u52a0\u7ed3\u679c\u201d\u7684\u201c\u521b\u5efa\u7d2f\u52a0\u5b9e\u4f8b\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AccResultListPlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if ("modify".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (listSelectedData.size() != 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AccResultListPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!AccResultHelper.checkSingleTaxStatus((ListSelectedRowCollection)listSelectedData)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u7684\u7b97\u7a0e\u72b6\u6001\u4e3a\u505c\u6b62\u7b97\u7a0e\uff0c\u4e0d\u80fd\u4fee\u6539\u7d2f\u52a0\u7ed3\u679c\u3002", (String)"AccResultListPlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("import_data".equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("itc_accresultimport");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
            showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
            showParameter.setCustomParam("BillFormId", (Object)"itc_accresult");
            showParameter.setCustomParam("ListName", (Object)this.getView().getFormShowParameter().getCaption());
            showParameter.setCustomParam("ImportPlugin", (Object)"kd.sit.itc.business.accresult.AccResultBatchImportPlugin");
            showParameter.setCustomParam("RealPermissionEntityId", (Object)"itc_accresult");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT));
            this.getView().showForm(showParameter);
            return;
        }
        if ("delete".equals(operateKey)) {
            fo.getOption().setVariableValue("ignorerefentityids", "itc_accdetail");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CALLBACK_IMPORT.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExportFile(ExportFileEvent event) {
        BillList control = (BillList)this.getControl("billlistap");
        int billDataCount = control.getListModel().getBillDataCount();
        Map qingData = control.getListModel().getQingData(0, billDataCount);
        Map dataIndex = (Map)qingData.get("dataindex");
        if (dataIndex.containsKey("instancenum") || dataIndex.containsKey("resultvalue")) {
            List rowsLists = (List)qingData.get("rows");
            ListSelectedRowCollection selectedRows = control.getSelectedRows();
            if (selectedRows.size() != 0) {
                Long id;
                ArrayList tempList = Lists.newArrayListWithExpectedSize((int)rowsLists.size());
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)rowsLists.size());
                Integer idIndex = (Integer)dataIndex.get("itc_accresult_id");
                for (List rowsList : rowsLists) {
                    id = (Long)BaseDataConverter.convert(rowsList.get(idIndex), Long.class);
                    tempMap.put(id, rowsList);
                }
                for (ListSelectedRow selectedRow : selectedRows) {
                    id = (Long)BaseDataConverter.convert((Object)selectedRow.getPrimaryKeyValue(), Long.class);
                    tempList.add(tempMap.get(id));
                }
                if (!CollectionUtils.isEmpty((Collection)tempList)) {
                    rowsLists = tempList;
                }
            }
            List listFieldsControlColumns = control.getListFieldsControlColumns();
            HashMap listColumnData = Maps.newHashMapWithExpectedSize((int)listFieldsControlColumns.size());
            int index = 0;
            for (Map listFieldsControlColumn : listFieldsControlColumns) {
                String listFieldKey;
                int visible = (Integer)listFieldsControlColumn.get("visible");
                if (11 == visible) {
                    ++index;
                }
                if (!"instancenum".equals(listFieldKey = (String)listFieldsControlColumn.get("listFieldKey")) && !"resultvalue".equals(listFieldKey)) continue;
                HashMap columnInfo = Maps.newHashMapWithExpectedSize((int)2);
                columnInfo.put("visible", visible);
                columnInfo.put("columnIndex", index);
                listColumnData.put(listFieldKey, columnInfo);
            }
            File file = event.getFile();
            if (file != null) {
                XSSFWorkbook wb = null;
                FileOutputStream out = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    wb = new XSSFWorkbook((InputStream)fis);
                    Sheet sheet = wb.getSheetAt(0);
                    Iterator rowIterator = sheet.rowIterator();
                    while (rowIterator.hasNext()) {
                        Integer resultValueIndex;
                        int columnIndex;
                        Cell cell;
                        Row row = (Row)rowIterator.next();
                        int rowNum = row.getRowNum();
                        if (rowNum == 0) continue;
                        Integer instanceNumIndex = (Integer)dataIndex.get("instancenum");
                        if (Objects.nonNull(instanceNumIndex) && 11 == (Integer)((Map)listColumnData.get("instancenum")).get("visible") && (cell = row.getCell(columnIndex = ((Integer)((Map)listColumnData.get("instancenum")).get("columnIndex")).intValue())) != null) {
                            List rowData = (List)rowsLists.get(rowNum - 1);
                            Object[] instanceNumArr = (Object[])rowData.get(instanceNumIndex);
                            String instanceNumStr = (String)BaseDataConverter.convert((Object)instanceNumArr[0], String.class);
                            cell.setCellValue(instanceNumStr);
                        }
                        if (!Objects.nonNull(resultValueIndex = (Integer)dataIndex.get("resultvalue")) || 11 != (Integer)((Map)listColumnData.get("resultvalue")).get("visible")) continue;
                        int columnIndex2 = (Integer)((Map)listColumnData.get("resultvalue")).get("columnIndex");
                        Cell cell2 = row.getCell(columnIndex2);
                        List rowData = (List)rowsLists.get(rowNum - 1);
                        String resultValueStr = (String)BaseDataConverter.convert(rowData.get(resultValueIndex), String.class);
                        if (cell2 != null) {
                            cell2.setCellValue(resultValueStr);
                            continue;
                        }
                        Cell newCell = row.createCell(columnIndex2);
                        CellStyle cellStyle = wb.createCellStyle();
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        newCell.setCellValue(resultValueStr);
                        newCell.setCellStyle(cellStyle);
                    }
                    out = new FileOutputStream(file);
                    wb.write((OutputStream)out);
                }
                catch (Throwable ex) {
                    logger.error(ex);
                }
                finally {
                    try {
                        if (wb != null) {
                            wb.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioE) {
                        logger.error((Throwable)ioE);
                    }
                }
            }
        }
    }
}

