/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.accresult;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.sit.itc.business.accresult.AccResultHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;

public class AccResultReportListPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BasedataEditListener {
    private static final String TAXFILE = "taxfile";
    private static final String ACC = "acc";
    private static final Log LOGGER = LogFactory.getLog(AccResultReportListPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit taxFileEdit = (BasedataEdit)this.getControl(TAXFILE);
        taxFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxFileEdit.addBasedataEditListener((BasedataEditListener)this);
        BasedataEdit accEdit = (BasedataEdit)this.getControl(ACC);
        accEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldName = args.getProperty().getName();
        if (TAXFILE.equals(fieldName)) {
            ListShowParameter taxFileParameter = (ListShowParameter)args.getFormShowParameter();
            taxFileParameter.setCustomParam("isShowUsed", (Object)Boolean.TRUE);
            if (!SITPermissionServiceHelper.isSuperUser()) {
                QFilter dataRuleForBdProp;
                HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"30", (String)"17/+CT1QBPNP", (String)"itc_accresult", (String)"47150e89000000ac");
                LOGGER.info("AccResultReportListPlugin.permOrgs.hasAllOrgPerm: {} - {}", (Object)permOrgResult.hasAllOrgPerm(), (Object)permOrgResult.getHasPermOrgs());
                if (!permOrgResult.hasAllOrgPerm()) {
                    if (CollectionUtils.isEmpty((Collection)permOrgResult.getHasPermOrgs())) {
                        taxFileParameter.getListFilterParameter().setFilter(new QFilter("1", "=", (Object)2));
                    } else {
                        taxFileParameter.getListFilterParameter().setFilter(new QFilter("org.id", "in", (Object)permOrgResult.getHasPermOrgs()));
                    }
                }
                if ((dataRuleForBdProp = SITPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_accresult", (String)TAXFILE, (String)"47150e89000000ac")) != null) {
                    LOGGER.info("AccResultReportListPlugin dataRuleForBdProp is {}", (Object)dataRuleForBdProp.toString());
                    taxFileParameter.getListFilterParameter().setFilter(dataRuleForBdProp);
                }
            }
        }
        if (ACC.equals(fieldName)) {
            QFilter qFilter = new QFilter("country.id", "=", (Object)1000001L);
            qFilter.or(new QFilter("countrytype", "=", (Object)"0"));
            ListShowParameter accParameter = (ListShowParameter)args.getFormShowParameter();
            accParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void afterBindData(EventObject eventObject) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap");
        formShowParameter.setBillFormId("itc_accresultrpt");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm((FormShowParameter)formShowParameter);
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("accresultpageid", pageId);
        PageCache accResultPageCache = new PageCache(pageId);
        accResultPageCache.put("init", "1");
        accResultPageCache.put("parentpageid", this.getView().getPageId());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterItemInfo accFilterItem;
        Object accValue;
        DynamicObjectCollection accDys;
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo taxFileFilterItem = filterInfo.getFilterItem(TAXFILE);
        Object taxFileValue = taxFileFilterItem.getValue();
        DynamicObjectCollection taxFileDys = (DynamicObjectCollection)taxFileValue;
        if (CollectionUtils.isEmpty((Collection)taxFileDys)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2a\u7a0e\u6863\u6848\u3002", (String)"AccResultReportListPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!SITPermissionServiceHelper.isSuperUser()) {
            Set taxFileBoIdSet = AccResultHelper.getTaxFileBoIdSetWithPermissionInAccResult((String)"47150e89000000ac");
            for (DynamicObject taxFileDy : taxFileDys) {
                long taxFileId = taxFileDy.getLong("id");
                if (taxFileBoIdSet.contains(taxFileId)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u9009\u62e9\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"AccResultReportListPlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(accDys = (DynamicObjectCollection)(accValue = (accFilterItem = filterInfo.getFilterItem(ACC)).getValue()))) && accDys.size() > 100000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7d2f\u52a0\u5668\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100000\u4e2a\u3002", (String)"AccResultReportListPlugin_8", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo startDateFilterItem = filterInfo.getFilterItem("startdate");
        FilterItemInfo endDateFilterItem = filterInfo.getFilterItem("enddate");
        Date startDate = startDateFilterItem.getDate();
        Date endDate = endDateFilterItem.getDate();
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate) && startDate.getTime() > endDate.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"AccResultReportListPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        HashMap queryParamMap = Maps.newHashMapWithExpectedSize((int)4);
        FilterItemInfo taxFileFilterItem = filterInfo.getFilterItem(TAXFILE);
        Object taxFileValue = taxFileFilterItem.getValue();
        if (Objects.nonNull(taxFileValue)) {
            DynamicObjectCollection taxFileList = (DynamicObjectCollection)taxFileValue;
            ArrayList list = Lists.newArrayListWithExpectedSize((int)taxFileList.size());
            if (!CollectionUtils.isEmpty((Collection)taxFileList)) {
                for (DynamicObject dynamicObject : taxFileList) {
                    list.add(dynamicObject.getLong("id"));
                }
            }
            queryParamMap.put(TAXFILE, list);
        } else {
            queryParamMap.put(TAXFILE, Lists.newArrayListWithExpectedSize((int)0));
        }
        FilterItemInfo accFilterItem = filterInfo.getFilterItem(ACC);
        Object accValue = accFilterItem.getValue();
        if (Objects.nonNull(accValue)) {
            DynamicObjectCollection accList = (DynamicObjectCollection)accValue;
            ArrayList list = Lists.newArrayListWithExpectedSize((int)accList.size());
            if (!CollectionUtils.isEmpty((Collection)accList)) {
                for (DynamicObject dynamicObject : accList) {
                    list.add(dynamicObject.getLong("id"));
                }
            }
            queryParamMap.put(ACC, list);
        } else {
            queryParamMap.put(ACC, Lists.newArrayListWithExpectedSize((int)0));
        }
        FilterItemInfo startDateFilterItem = filterInfo.getFilterItem("startdate");
        FilterItemInfo endDateFilterItem = filterInfo.getFilterItem("enddate");
        Date startDate = startDateFilterItem.getDate();
        Date endDate = endDateFilterItem.getDate();
        queryParamMap.put("startdate", startDate);
        queryParamMap.put("enddate", endDate);
        String pageId = this.getPageCache().get("accresultpageid");
        IFormView accResultPage = this.getView().getView(pageId);
        accResultPage.getPageCache().put("queryParamMap", SerializationUtils.toJsonString((Object)queryParamMap));
        accResultPage.invokeOperation("refresh");
        this.getView().sendFormAction(accResultPage);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IDataModel service = (IDataModel)this.getView().getService(IDataModel.class);
        DynamicObject dataEntity = service.getDataEntity();
        DynamicObjectCollection taxFileDys = dataEntity.getDynamicObjectCollection(TAXFILE);
        for (DynamicObject taxFileDy : taxFileDys) {
            DynamicObject object = taxFileDy.getDynamicObject("fbasedataid");
            String pName = object.getString("person.name");
            object.set("name", (Object)pName);
        }
    }

    public void afterBindingData(AfterBindingDataEvent evt) {
        BasedataEdit edit = (BasedataEdit)evt.getSource();
        if (TAXFILE.equals(edit.getKey())) {
            DynamicObject dataEntity = (DynamicObject)evt.getDataEntity();
            String personName = dataEntity.getString("person.name");
            String number = dataEntity.getString("number");
            String displayProp = String.format(Locale.ROOT, " %s", personName);
            String editSearchProp1 = String.format("%s %s", number, personName);
            String editSearchProp = this.getEditSearchProp(edit.getProperty());
            if (StringUtils.isNotBlank((CharSequence)editSearchProp)) {
                editSearchProp = editSearchProp1;
            }
            evt.setDisplayProp(displayProp);
            evt.setEditSearchProp(editSearchProp == null ? "" : editSearchProp);
        }
    }

    private String getEditSearchProp(IDataEntityProperty property) {
        BasedataProp basedataProp = null;
        if (property instanceof BasedataProp) {
            basedataProp = (BasedataProp)property;
        } else if (property instanceof MulBasedataProp) {
            basedataProp = (BasedataProp)((MulBasedataProp)property).getRefBaseProp();
        }
        if (basedataProp != null) {
            return basedataProp.getEditSearchProp();
        }
        return null;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        Date endDate;
        FilterInfo filterInfo = evt.getFilter();
        StringBuilder formatStringBuilder = new StringBuilder();
        String accStr = ResManager.loadKDString((String)"\u7d2f\u52a0\u5668", (String)"AccResultReportListPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        String startDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"AccResultReportListPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        String endDateStr = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"AccResultReportListPlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection accDys = filterInfo.getDynamicObjectCollection(ACC);
        if (!CollectionUtils.isEmpty((Collection)accDys)) {
            if (accDys.size() <= 50) {
                StringBuilder allAccStr = new StringBuilder();
                for (DynamicObject accDy : accDys) {
                    String name = accDy.getString("name");
                    allAccStr.append(name).append(';').append(' ');
                }
                formatStringBuilder.append(accStr).append(" : ").append((CharSequence)allAccStr);
            } else {
                evt.setFormatedFilterString("");
                return;
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = filterInfo.getDate("startdate");
        if (Objects.nonNull(startDate)) {
            formatStringBuilder.append(startDateStr).append(" : ").append(SITInteDateTimeUtil.formatTimeWithUserZone((Date)startDate)).append(';').append(' ');
        }
        if (Objects.nonNull(endDate = filterInfo.getDate("enddate"))) {
            formatStringBuilder.append(endDateStr).append(" : ").append(format.format(endDate)).append(';').append(' ');
        }
        evt.setFormatedFilterString(formatStringBuilder.toString());
    }
}

