/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.accresult;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class AccResultRptListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent event) {
        String init = this.getPageCache().get("init");
        if (!Strings.isNullOrEmpty((String)init)) {
            this.getPageCache().remove("init");
            event.addCustomQFilter(new QFilter("taxfile.id", "=", (Object)-1));
            return;
        }
        String queryParamMapStr = this.getPageCache().get("queryParamMap");
        if (!Strings.isNullOrEmpty((String)queryParamMapStr)) {
            QFilter dateFilter;
            Map queryParamMap = (Map)SerializationUtils.fromJsonString((String)queryParamMapStr, HashMap.class);
            List taxFileList = (List)queryParamMap.get("taxfile");
            ArrayList taxFileIdList = Lists.newArrayListWithExpectedSize((int)taxFileList.size());
            for (Object obj : taxFileList) {
                taxFileIdList.add((Long)obj);
            }
            if (!CollectionUtils.isEmpty((Collection)taxFileIdList)) {
                QFilter taxFileFilter = new QFilter("taxfile.id", "in", (Object)taxFileIdList);
                event.getQFilters().add(taxFileFilter);
            }
            List accList = (List)queryParamMap.get("acc");
            ArrayList accIdList = Lists.newArrayListWithExpectedSize((int)accList.size());
            for (Object obj : accList) {
                accIdList.add((Long)obj);
            }
            if (!CollectionUtils.isEmpty((Collection)accIdList)) {
                QFilter accFilter = new QFilter("accumulator.id", "in", (Object)accIdList);
                event.getQFilters().add(accFilter);
            }
            String startDateStr = (String)queryParamMap.get("startdate");
            Date startDate = (Date)BaseDataConverter.convert((Object)startDateStr, Date.class);
            String endDateStr = (String)queryParamMap.get("enddate");
            Date endDate = (Date)BaseDataConverter.convert((Object)endDateStr, Date.class);
            if (Objects.nonNull(endDate)) {
                LocalDateTime tempLDT = LocalDateTime.ofInstant(endDate.toInstant(), KDDateUtils.getSysTimeZone().toZoneId());
                LocalDateTime plusLDT = tempLDT.plusHours(23L).plusMinutes(59L).plusSeconds(59L).plus(999999L, ChronoUnit.MICROS);
                endDate = Date.from(plusLDT.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            }
            if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
                dateFilter = new QFilter("startdate", "<=", (Object)endDate);
                dateFilter.and(new QFilter("enddate", ">=", (Object)startDate));
                event.getQFilters().add(dateFilter);
            } else if (Objects.nonNull(startDate)) {
                dateFilter = new QFilter("enddate", ">=", (Object)startDate);
                event.getQFilters().add(dateFilter);
            } else if (Objects.nonNull(endDate)) {
                dateFilter = new QFilter("startdate", "<=", (Object)endDate);
                event.getQFilters().add(dateFilter);
            }
        } else {
            event.addCustomQFilter(new QFilter("taxfile.id", "=", (Object)-1));
            return;
        }
        event.setOrderBy("taxfile.person.number asc,taxfile.number asc,accumulator.number asc,startdate desc");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblclose": {
                this.closePage();
                break;
            }
        }
    }

    private void closePage() {
        String parentPageId = this.getPageCache().get("parentpageid");
        IFormView reportView = this.getView().getView(parentPageId);
        reportView.close();
        this.getView().sendFormAction(reportView);
    }
}

