/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.basedata.cloudcollaplugin;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.api.DataSync;
import kd.sit.itc.business.datasync.BaseDataSync;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.sit.sitbp.common.vo.CollaRuleExecuteContext;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.MapUtils;

public class CloudCollaTaxFileDataAssemblePlugin
implements AbstractCloudCollaExecutePlugin,
Serializable {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaTaxFileDataAssemblePlugin.class);
    private static final long serialVersionUID = 4419972446972325097L;
    public static final int SUCCESS_CODE = 200;
    private Map<String, Object> commonParams;
    private Map<String, Object> taskDataMap;
    private Long existSalaryFileId;
    private CollaRuleExecuteContext executeInfo;
    private Map<String, Object> executeResult = null;
    private List<String> relWarnMsg = new ArrayList<String>(10);

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        LOGGER.info("[colla] CloudCollaTaxFileDataAssemblePlugin.afterAssembleData begin");
        this.executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (this.executeInfo == null) {
            return Collections.emptyList();
        }
        Date effectTime = (Date)commonParams.get("effectTime");
        Map<String, List<DynamicObject>> apiConvertedData = this.getApiConvertedData(commonParams);
        Optional<DynamicObject> employeeOp = this.getCurrentEntity(apiConvertedData, "hsas_employee");
        String empNumber = employeeOp.isPresent() ? employeeOp.get().getString("empnumber") : "";
        Optional<DynamicObject> personOp = this.getCurrentEntity(apiConvertedData, "hsas_personhr");
        String personName = personOp.isPresent() ? personOp.get().getString("name") : "";
        Optional<DynamicObject> depEmpOp = this.getCurrentEntity(apiConvertedData, "hsas_depemp");
        String depEmpNumber = depEmpOp.isPresent() ? depEmpOp.get().getString("number") : "";
        DynamicObject existSalaryFile = this.getExistSalaryFile();
        if (existSalaryFile == null) {
            List<Object> matchSalaryFileObjects = new ArrayList(10);
            if (depEmpOp.isPresent()) {
                matchSalaryFileObjects = this.getSalaryFileByDepEmp(depEmpOp.get().getLong("id"), true);
            }
            if (CollectionUtils.isEmpty(matchSalaryFileObjects)) {
                this.relWarnMsg.add(ResManager.loadKDString((String)"{0}({1})\u7684\u5c97\u4f4d({2})\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u5173\u8054\u4e2a\u7a0e\u6863\u6848\u3002", (String)"CloudCollaTaxFileDataAssemblePlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[]{personName, empNumber, depEmpNumber}));
            }
            if (matchSalaryFileObjects.size() > 1) {
                this.relWarnMsg.add(ResManager.loadKDString((String)"\u540c\u4e00\u7ba1\u7406\u5c5e\u5730\u4e0b\uff0c{0}({1})\u5b58\u5728\u591a\u4e2a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff0c\u8bf7\u624b\u5de5\u5173\u8054\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"CloudCollaTaxFileDataAssemblePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{empNumber, depEmpNumber}));
            }
            if (matchSalaryFileObjects.size() == 1) {
                existSalaryFile = (DynamicObject)matchSalaryFileObjects.get(0);
            }
        }
        this.commonParams = commonParams;
        this.taskDataMap = new HashMap<String, Object>(10);
        this.taskDataMap.put("fieldMap", fieldMapResult);
        this.taskDataMap.put("fieldRule", fieldRuleResult);
        this.taskDataMap.put("ruleEngineData", ruleEngineData);
        this.taskDataMap.put("apiDataList", apiConvertedData);
        if (existSalaryFile != null) {
            this.existSalaryFileId = existSalaryFile.getLong("id");
            this.taskDataMap.put("salaryFileBoId", existSalaryFile.getLong("id"));
        }
        assembleSaveData.put("itc_taxfile", (List)fieldRuleResult.get("itc_taxfile"));
        return super.afterAssembleData(fieldMapResult, fieldRuleResult, assembleSaveData, commonParams, ruleEngineData, currentTriggerObjectName);
    }

    private DynamicObject getExistSalaryFile() {
        List preExeResult = this.executeInfo.getPreExeResult();
        if (CollectionUtils.isEmpty((Collection)preExeResult)) {
            return null;
        }
        for (Map objectMap : preExeResult) {
            List salaryFiles;
            if (CollectionUtils.isEmpty((Map)objectMap) || CollectionUtils.isEmpty((Collection)(salaryFiles = (List)objectMap.get("hsas_salaryfile")))) continue;
            return (DynamicObject)salaryFiles.get(0);
        }
        Map batchTaskCenterData = this.executeInfo.getBatchTaskCenterData();
        if (CollectionUtils.isEmpty((Map)batchTaskCenterData)) {
            return null;
        }
        Long taskCenterId = this.executeInfo.getTaskCenterId();
        String flowType = this.executeInfo.getFlowType();
        List taskCenterList = (List)MapUtils.getObject((Map)batchTaskCenterData, (Object)flowType, Collections.emptyList());
        Optional<Long> depEmpIdOp = taskCenterList.stream().filter(item -> taskCenterId.equals(MapUtils.getLong((Map)item, (Object)"taskCenterId"))).findFirst().map(item -> MapUtils.getLong((Map)item, (Object)"depEmpId"));
        if (!depEmpIdOp.isPresent()) {
            return null;
        }
        Long depEmpId = depEmpIdOp.get();
        Long salaryFileId = null;
        block1: for (Map taskCenterMap : taskCenterList) {
            List entryEntity;
            if (salaryFileId != null) break;
            if (!depEmpId.equals(MapUtils.getLong((Map)taskCenterMap, (Object)"depEmpId")) || CollectionUtils.isEmpty((Collection)(entryEntity = (List)MapUtils.getObject((Map)taskCenterMap, (Object)"entryEntity", Collections.emptyList())))) continue;
            for (Map entryRowMap : entryEntity) {
                JSONObject parseMap;
                List fileMaps;
                String result = MapUtils.getString((Map)entryRowMap, (Object)"result");
                if (SITStringUtils.isEmpty((String)result) || CollectionUtils.isEmpty((Collection)(fileMaps = (List)MapUtils.getObject((Map)(parseMap = JSONObject.fromObject((Object)result)), (Object)"hsas_salaryfile", Collections.emptyList())))) continue;
                salaryFileId = MapUtils.getLong((Map)((Map)fileMaps.get(0)), (Object)"dataId");
                continue block1;
            }
        }
        if (salaryFileId == null) {
            return null;
        }
        return new HRBaseServiceHelper("hsas_salaryfile").queryOne(SITBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), salaryFileId);
    }

    private Map<String, List<DynamicObject>> getApiConvertedData(Map<String, Object> commonParams) {
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        if (executeInfo == null) {
            return Collections.emptyMap();
        }
        Map convertedApiDatas = executeInfo.getConvertedApiDatas();
        if (CollectionUtils.isEmpty((Map)convertedApiDatas)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(convertedApiDatas.size());
        convertedApiDatas.forEach((key, value) -> {
            if (CollectionUtils.isEmpty((Collection)value)) {
                return;
            }
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>();
            for (Object element : value) {
                if (!(element instanceof DynamicObject)) continue;
                tempList.add((DynamicObject)element);
            }
            if (CollectionUtils.isEmpty(tempList)) {
                return;
            }
            String name = ((DynamicObject)tempList.get(0)).getDataEntityType().getName();
            result.put(name, tempList);
        });
        return result;
    }

    public List<String> execute(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        LOGGER.info("[colla] CloudCollaTaxFileDataAssemblePlugin.execute start");
        try {
            if (CollectionUtils.isEmpty(executeData)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e2a\u7a0e\u534f\u4f5c\u63d2\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u534f\u4f5c\u7684\u4e2a\u7a0e\u6863\u6848\u6570\u636e\u3002", (String)"CloudCollaTaxFileDataAssemblePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            }
            DynamicObject data = executeData.get(0);
            DataSync service = BaseDataSync.getService((String)"ITC_TAXFILE_DATASYNC");
            if (service == null) {
                LOGGER.info("[colla][tax] invoke mservice service is null.");
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e2d\u56fd\u4e2a\u7a0e\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloudCollaTaxFileDataAssemblePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, Object> taxFileParam = new HashMap<String, Object>(this.commonParams);
            taxFileParam.put("requestFrom", "itc");
            taxFileParam.put("flowOutResult", this.getFlowOutResult(this.executeInfo));
            this.executeResult = service.handleData(taxFileParam, this.taskDataMap);
        }
        catch (KDException kdEx) {
            LOGGER.info("[colla][tax] invoke mservice KDBizException.", (Object)kdEx);
            throw new KDBizException((Throwable)kdEx, new ErrorCode("CloudCollaTaxFileDataAssemblePluginError_1", ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e2d\u56fd\u4e2a\u7a0e\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloudCollaTaxFileDataAssemblePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.info("[colla][tax] invoke mservice error.", (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("CloudCollaTaxFileDataAssemblePluginError_2", ex.getMessage()), new Object[0]);
        }
        Integer code = MapUtils.getInteger(this.executeResult, (Object)"code");
        if (200 != code) {
            throw new KDBizException(MapUtils.getString(this.executeResult, (Object)"errorMsg"));
        }
        String errorMsg = MapUtils.getString(this.executeResult, (Object)"errorMsg");
        if (!SITStringUtils.isEmpty((String)errorMsg)) {
            this.executeInfo.getWarnMsgs().add(errorMsg);
        }
        List data = (List)MapUtils.getObject(this.executeResult, (Object)"executeResult", Collections.emptyList());
        Map executeInfoResult = this.executeInfo.getResult();
        for (Map datum : data) {
            String entityNumber = MapUtils.getString((Map)datum, (Object)"entityNumber");
            if (SITStringUtils.isEmpty((String)entityNumber)) continue;
            List maps = executeInfoResult.computeIfAbsent(entityNumber.toLowerCase(Locale.ROOT), item -> new ArrayList(10));
            maps.add(datum);
        }
        return super.execute(executeData, ruleEngineData);
    }

    private Map<String, Object> getFlowOutResult(CollaRuleExecuteContext executeInfo) {
        Map batchTaskCenterData = executeInfo.getBatchTaskCenterData();
        String flowType = executeInfo.getFlowType();
        if (!"1".equalsIgnoreCase(flowType)) {
            return Collections.emptyMap();
        }
        List taskCenterList = (List)MapUtils.getObject((Map)batchTaskCenterData, (Object)"2", Collections.emptyList());
        HashMap<String, Object> result = new HashMap<String, Object>(taskCenterList.size() * 2);
        for (Map taskCenter : taskCenterList) {
            List entryEntity = (List)MapUtils.getObject((Map)taskCenter, (Object)"entryEntity", (Object)Collections.emptyList().toString());
            for (Map entry : entryEntity) {
                Map parseResult;
                String executeResult = MapUtils.getString((Map)entry, (Object)"result");
                if (SITStringUtils.isEmpty((String)executeResult) || CollectionUtils.isEmpty((Map)(parseResult = (Map)JSON.parse((String)executeResult)))) continue;
                parseResult.forEach((entityNumber, dataMap) -> {
                    List tempList = (List)result.computeIfAbsent((String)entityNumber, item -> new ArrayList(10));
                    if (!CollectionUtils.isEmpty((Collection)((List)dataMap))) {
                        tempList.addAll((Collection)dataMap);
                    }
                });
            }
        }
        return result;
    }

    public void afterCommit(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        block6: {
            super.afterCommit(executeData, ruleEngineData);
            try {
                if (!CollectionUtils.isEmpty(this.relWarnMsg)) {
                    this.executeInfo.getWarnMsgs().addAll(this.relWarnMsg);
                    return;
                }
                Map dataMap = MapUtils.getMap(this.executeResult, (Object)"data");
                if (CollectionUtils.isEmpty((Map)dataMap)) {
                    LOGGER.info("[colla][tax] result->data is null.");
                    return;
                }
                Long itcTaxFileBoId = (Long)dataMap.get("itcTaxFileBoId");
                this.executeInfo.getExeResult().put("itcTaxFileBoId", itcTaxFileBoId);
                if (itcTaxFileBoId == null || itcTaxFileBoId == 0L || this.existSalaryFileId == null || this.existSalaryFileId == 0L) {
                    return;
                }
                Map relResult = (Map)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"relateSalaryTaxFile", (Object[])new Object[]{itcTaxFileBoId, this.existSalaryFileId});
                Boolean isSuccess = MapUtils.getBoolean((Map)relResult, (Object)"success", (Boolean)Boolean.TRUE);
                if (!isSuccess.booleanValue()) {
                    this.executeInfo.getWarnMsgs().add(MapUtils.getString((Map)relResult, (Object)"errorMsg"));
                }
            }
            catch (Exception ex) {
                LOGGER.info("[colla][tax] add file relation error.", (Object)ex);
                if (this.executeInfo == null) break block6;
                this.executeInfo.getWarnMsgs().add(ex.getMessage());
            }
        }
    }

    private Optional<DynamicObject> getCurrentEntity(Map<String, List<DynamicObject>> commonDatas, String entityName) {
        if (commonDatas == null) {
            return Optional.empty();
        }
        List<DynamicObject> datas = commonDatas.get(entityName);
        if (datas == null || datas.size() == 0) {
            return Optional.empty();
        }
        return datas.stream().filter(item -> item.getBoolean("iscurrentversion")).findFirst();
    }

    public List<DynamicObject> getSalaryFileByDepEmp(Long depEmpId, boolean isAudited) {
        List<Map<String, Object>> result = this.getSalaryFile(depEmpId, null, isAudited);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        List resultList = (List)result.get(0).get("matchSalaryFileVers");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Collections.emptyList();
        }
        return resultList;
    }

    private List<Map<String, Object>> getSalaryFile(Long depEmpId, Date effectTime, boolean isAudited) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("depEmpId", depEmpId);
        params.put("endDate", effectTime);
        params.put("status", isAudited ? Collections.singletonList("C") : Arrays.asList("A", "B", "C"));
        return (List)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"ISalaryFileService", (String)"matchSalaryFile", (Object[])new Object[]{Collections.singletonList(params)});
    }
}

