/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.ComboListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideDifferenceReportDownLoadTask;
import kd.sit.itc.formplugin.web.taskguide.TaxDataForStep70List;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataDiffReportList
extends TaxDataForStep70List {
    private final Set<Long> noCalDiffItemMap = Sets.newHashSet((Object[])new Long[]{1123912110976296960L, 1123912111093736448L});
    private static final String FILTER_ITEM = "1123912112880510976,1287527446161246208,1123912110850466816,1123912110976296960,1123912111093736448";

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
        List allColumn = args.getListColumns();
        List groupColumns = args.getListGroupColumns();
        for (TaxItemEntity taxItem : taxItemEntities) {
            if (taxItem.isIncomeItem() || !this.isCalDifference(taxItem) || FILTER_ITEM.contains(String.valueOf(taxItem.getId())) || SitDataTypeEnum.AMOUNT.getId() != taxItem.getDatatypeId() && SitDataTypeEnum.NUMBER.getId() != taxItem.getDatatypeId() || CalTaxTypeEnum.RETURN.getId() != taxItem.getCaltaxtypeId()) continue;
            this.createTaxItemGroupColumnList(allColumn, groupColumns, taxItem);
        }
    }

    private void createTaxItemGroupColumnList(List<IListColumn> columns, List<ListColumnGroup> groupColumns, TaxItemEntity taxItem) {
        String key = "rp_" + taxItem.getId();
        ListColumnGroup listColumnGroup = new ListColumnGroup();
        ArrayList<ListColumn> items = new ArrayList<ListColumn>();
        listColumnGroup.setKey(key);
        listColumnGroup.setName(LocaleString.fromMap((Map)taxItem.getName()));
        listColumnGroup.setParentViewKey("gridview");
        listColumnGroup.setVisible(63);
        String taxRes = ResManager.loadKDString((String)"\u7a0e\u5c40\u7ed3\u679c", (String)"TaxDataDiffReportList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        String calRes = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c", (String)"TaxDataDiffReportList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        String diffRes = ResManager.loadKDString((String)"\u5dee\u503c", (String)"TaxDataDiffReportList_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        ListColumn itemValueCol = this.createListColumn(taxRes, key + "_t", (Container)listColumnGroup);
        items.add(itemValueCol);
        ListColumn calValueCol = this.createListColumn(calRes, key + "_c", (Container)listColumnGroup);
        items.add(calValueCol);
        ListColumn diffValueCol = this.createListColumn(diffRes, key + "_d", (Container)listColumnGroup);
        items.add(diffValueCol);
        listColumnGroup.getItems().addAll(items);
        ArrayList<ListColumnGroup> newGroupColumnList = new ArrayList<ListColumnGroup>();
        newGroupColumnList.add(listColumnGroup);
        columns.add((IListColumn)itemValueCol);
        columns.add((IListColumn)calValueCol);
        columns.add((IListColumn)diffValueCol);
        groupColumns.addAll(newGroupColumnList);
    }

    private ListColumn createListColumn(String columnName, String columnKey, Container parentContainer) {
        ComboListColumn col = new ComboListColumn();
        col.setListFieldKey(columnKey);
        col.setCaption(new LocaleString(columnName));
        col.setFieldName(columnKey);
        col.setParent(parentContainer);
        col.setParentViewKey(parentContainer.getKey());
        col.setKey(columnKey);
        col.setVisible(11);
        col.setColumnFilter(false);
        col.setColumnOrder(false);
        return col;
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaxDiffReportDataProviderImpl());
    }

    private void setCustomSeq(DynamicObjectCollection data, int start) {
        for (DynamicObject obj : data) {
            obj.set("customseq", (Object)(++start));
        }
    }

    private void addItemProps(DynamicObjectType mainType, Set<String> listFields) {
        List<TaxItemEntity> taxItems = this.taxItemEntities();
        DataEntityPropertyCollection properties = mainType.getProperties();
        for (String listField : listFields) {
            if (properties.containsKey((Object)listField)) continue;
            TextProp property = new TextProp();
            property.setName(listField);
            mainType.addProperty((DynamicProperty)property);
        }
        for (TaxItemEntity taxItem : taxItems) {
            String number = "rp_" + taxItem.getId();
            if (properties.containsKey((Object)number)) continue;
            TextProp property1 = new TextProp();
            property1.setName(number + 1);
            mainType.addProperty((DynamicProperty)property1);
            TextProp property2 = new TextProp();
            property2.setName(number + 2);
            mainType.addProperty((DynamicProperty)property2);
            TextProp property3 = new TextProp();
            property3.setName(number + 3);
            mainType.addProperty((DynamicProperty)property3);
        }
    }

    @Override
    protected MainEntityType extEntityType(MainEntityType extTypeTaxData) {
        try {
            if (extTypeTaxData == null) {
                extTypeTaxData = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxdata").clone();
            }
            List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
            for (TaxItemEntity taxItemEntity : taxItemEntities) {
                String prop = "rp_" + taxItemEntity.getId();
                if (extTypeTaxData.getProperties().containsKey((Object)prop)) continue;
                TextProp property1 = new TextProp();
                property1.setName(prop + "_t");
                extTypeTaxData.addProperty((DynamicProperty)property1);
                TextProp property2 = new TextProp();
                property2.setName(prop + "_c");
                extTypeTaxData.addProperty((DynamicProperty)property2);
                TextProp property3 = new TextProp();
                property3.setName(prop + "_d");
                extTypeTaxData.addProperty((DynamicProperty)property3);
            }
            extTypeTaxData.createPropIndexs();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u4e2a\u7a0e\u5dee\u503c\u62a5\u8868\u9875\u9762\u5b9e\u4f53\u6269\u5c55\u5931\u8d25", (String)"TaxDataDiffReportList_8", (String)"sit-itc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return extTypeTaxData;
    }

    public boolean isCalDifference(TaxItemEntity taxItem) {
        return !this.noCalDiffItemMap.contains(taxItem.getId());
    }

    public boolean isValidDataItem(DynamicObject taxDataItem, TaxItemEntity taxItem) {
        return !StringUtils.isEmpty((CharSequence)taxDataItem.getString("itemvalue")) && CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId()) && !taxItem.isIncomeItem();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent event) {
    }

    @Override
    protected boolean isNeedRawData() {
        return true;
    }

    @Override
    protected String tabFilterKey() {
        return "taxcategory.group.id";
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        PageCache pageCache = new PageCache(this.getView().getPageId());
        if (TaxTaskGuideOpEnum.EXPORT_DIFFREPORT.getCode().equals(operateKey)) {
            this.exportByList();
        } else if (TaxTaskGuideOpEnum.SHOW_DREXPORT_RESULT.getCode().equals(operateKey)) {
            this.showExportResult();
        }
    }

    private void exportByList() {
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskEntityRes.isSuccess()) {
            this.getView().showTipNotification(taxTaskEntityRes.getMessage());
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        TaskGuideDifferenceReportDownLoadTask task = new TaskGuideDifferenceReportDownLoadTask((TaxTaskEntity)taxTaskEntityRes.getData(), billList, this.stepCaseInfo((TaxTaskEntity)taxTaskEntityRes.getData()));
        task.setHandleCase(MultiThreadCase.BY_ACTION);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int total = CollectionUtils.isEmpty((Collection)selectedRows) ? billList.queryBillDataCount() : selectedRows.size();
        if (total == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxDataDiffReportList_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        task.addData(total, 500).ofKey(RequestContext.get().getTraceId());
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.getView().showErrorNotification(execute.getMessage());
        }
    }

    private void showExportResult() {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bos_exportlog");
        param.setFormId("bos_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("bizobject", "=", (Object)("itc_taxdatadiffreport" + this.taxTask().getId())));
        param.getListFilterParameter().setFilter(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()));
        this.getView().showForm((FormShowParameter)param);
    }

    private TaxTaskEntity taxTask() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        BaseResult taskResult = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taskResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u88ab\u5220\u9664\u3002", (String)"TaxDataDiffReportList_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        return (TaxTaskEntity)taskResult.getData();
    }

    private class TaxDiffReportDataProviderImpl
    extends ListDataProvider {
        private TaxDiffReportDataProviderImpl() {
        }

        public String getOrderByExpr() {
            String order = super.getOrderByExpr();
            if (kd.bos.util.StringUtils.isEmpty((String)order) || "id".equals(order)) {
                return "taxfile.taxunit.id asc, taxfile.number asc";
            }
            return order;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            TaxTaskGuideViewHelper.cacheFilterAndOrderBy((ListDataProvider)this, (IPageCache)TaxDataDiffReportList.this.getView().getPageCache());
            DynamicObjectCollection data = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            List listFields = this.getListFields();
            DynamicObjectType objectType = data.getDynamicObjectType();
            LinkedHashSet keySet = Sets.newLinkedHashSetWithExpectedSize((int)listFields.size());
            listFields.forEach(e1 -> {
                String listFieldKey = e1.getListFieldKey();
                keySet.add(listFieldKey);
            });
            TaxDataDiffReportList.this.addItemProps(objectType, (Set)keySet);
            Map<Long, DynamicObject> dataMap = data.stream().collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1, (k1, k2) -> k1));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
            DynamicObject[] query = serviceHelper.query("id,entryentity.taxitem.id,entryentity.taxitem,entryentity.itemvalue,entryentity.calvalue,entryentity.diffvalue", new QFilter[]{new QFilter("id", "in", dataMap.keySet())});
            Long taxTaskId = (Long)BaseDataConverter.convert((Object)TaxDataDiffReportList.this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
            TaxTaskEntity taxTaskRes = (TaxTaskEntity)TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId).getData();
            if (!data.getDynamicObjectType().getProperties().containsKey((Object)"customseq")) {
                return data;
            }
            TaxDataDiffReportList.this.setCustomSeq(data, start);
            for (DynamicObject queryObj : query) {
                DynamicObject dataObj = dataMap.get(queryObj.getLong("id"));
                DynamicObjectCollection entry = queryObj.getDynamicObjectCollection("entryentity");
                String incomeItem = taxTaskRes.getTaxCategory(Long.valueOf(dataObj.getLong("taxcategory.id"))).getIncomeItemLocaleString();
                dataObj.set("incomeitem", (Object)incomeItem);
                for (DynamicObject dynamicObject : entry) {
                    String itemId = dynamicObject.getString("taxitem.id");
                    if (!dataObj.getDataEntityType().getProperties().containsKey((Object)("rp_" + itemId + "_t"))) continue;
                    String itemvalue = dynamicObject.getString("itemvalue");
                    String calvalue = dynamicObject.getString("calvalue");
                    String diffvalue = dynamicObject.getString("diffvalue");
                    dataObj.set("rp_" + itemId + "_t", (Object)itemvalue);
                    dataObj.set("rp_" + itemId + "_c", (Object)calvalue);
                    if (StringUtils.isBlank((CharSequence)itemvalue) && StringUtils.isBlank((CharSequence)calvalue)) {
                        dataObj.set("rp_" + itemId + "_d", (Object)diffvalue);
                        continue;
                    }
                    dataObj.set("rp_" + itemId + "_d", (Object)(StringUtils.isBlank((CharSequence)diffvalue) ? "0.00" : diffvalue));
                }
            }
            return data;
        }
    }
}

