/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewFilter;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideStep0RawDataDownLoadTask;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;

public class TaxDataForStep10List
extends HRDataBaseList
implements TabSelectListener,
FilterContainerInitListener {
    private static final String GLOBAL_FILTER = "global_filter";
    private static final String EXPORT_DECLARE_AND_MARK = "exportdeclareandmark";
    private static final String UNMARK_DECLARE_STATUS = "unmarkdeclarestatus";
    private static final String BTN_EXPORT_DECLARE = "btn_exportdeclare";
    private static final String CHANGED_TAB = "changedtab";
    private static final String UNCHANGED_TAB = "unchangedtab";
    private static final String ALL_TAB = "alltab";
    private static final String[] FORBIDDEN_OP_AFTER_MUTEX_LOCK = new String[]{"exportdeclareandmark", "exportdeclare", "exportdetails_declare", "unmarkdeclarestatus", "updatepersonfile", "btn_exportdeclare"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        ControlFilters filters;
        List commonFilterColumns = evt.getCommonFilterColumns();
        List schemeFilterColumns = evt.getSchemeFilterColumns();
        String currentTab = this.getCurrentTab();
        SchemeFilterColumn declareStatusColumn = new SchemeFilterColumn("taxfile.declarestatus");
        SchemeFilterColumn changeTypeColumn = new SchemeFilterColumn("changetype");
        switch (currentTab) {
            case "unchangedtab": {
                commonFilterColumns.remove(evt.getFilterColumn("taxfile.declarestatus"));
                commonFilterColumns.remove(evt.getFilterColumn("changetype"));
                schemeFilterColumns.remove(declareStatusColumn);
                schemeFilterColumns.remove(changeTypeColumn);
                break;
            }
            case "alltab": {
                commonFilterColumns.remove(evt.getFilterColumn("changetype"));
                schemeFilterColumns.remove(changeTypeColumn);
                break;
            }
        }
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map cacheFilterMap = (Map)pageCache.get(GLOBAL_FILTER, Map.class);
        if (!CollectionUtils.isEmpty((Map)cacheFilterMap)) {
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                FilterField fieldName = commonFilterColumn.getFilterField();
                List values = (List)cacheFilterMap.get(fieldName.getFieldName());
                if (CollectionUtils.isEmpty((Collection)values)) continue;
                commonFilterColumn.setDefaultValues(values);
            }
        }
        if (null != (filters = this.getControlFilters())) {
            Map filtersMap = filters.getFilters();
            HashMap filterValueMap = new HashMap(16);
            for (Map.Entry keyMap : filtersMap.entrySet()) {
                filterValueMap.put(keyMap.getKey(), ((ControlFilter)keyMap.getValue()).getValue());
            }
            pageCache.put(GLOBAL_FILTER, filterValueMap);
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u62a5\u9001", (String)"TaxFileTreeList4GuidePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        this.getView().cacheFormShowParameter();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().clear();
        this.showTab();
        this.getView().updateView();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String currentTab = this.getCurrentTab();
        List columns = args.getListColumns();
        if (!HRStringUtils.equals((String)CHANGED_TAB, (String)currentTab)) {
            IListColumn changeTypeColumn = args.getListColumn("changetype");
            columns.remove(changeTypeColumn);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        Long taxDataBasicId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
        QFilter idFilter = new QFilter("id", "=", (Object)taxDataBasicId);
        DynamicObject taxDataBasicDy = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdatabasic"), (QFilter[])new QFilter[]{idFilter});
        DynamicObject taxFile = taxDataBasicDy.getDynamicObject("taxfile");
        SITPageCache pageCache = new SITPageCache(this.getView());
        pageCache.put("taxDataBasicForOpenTaxFile" + taxFile.getLong("id"), (Object)taxDataBasicDy.getLong("id"));
        TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.READ_ONLY, (IFormView)this.getView(), (long)0L);
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        List qFilters = evt.getQFilters();
        TaxTaskEntity taxTask = this.getTaxTask();
        if (taxTask == null) {
            qFilters.add(new QFilter("1", "=", (Object)"2"));
            return;
        }
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        QFilter qFilter = new QFilter("taxtask", "=", (Object)taxTask.getId());
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if (CHANGED_TAB.equals(currentTab)) {
            qFilter.and(new QFilter("changetype", "in", (Object)new Object[]{"1", "2", "3"}));
        } else if (UNCHANGED_TAB.equals(currentTab)) {
            qFilter.and(new QFilter("changetype", "in", (Object)new Object[]{"0"}));
        }
        qFilters.add(qFilter);
        TaxTaskGuideViewFilter.setPersonFilter((List)qFilters, (Long)taxTask.getId());
        TaxTaskGuideViewFilter.setTaxFileFilter((List)qFilters, (String)"itc_taxdatabasic", (long)taxTask.getId());
        evt.setOrderBy("taxunit.name asc,taxfile.number asc,taxfile.person.number asc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        TaxTaskGuideViewFilter.setSchemeFilter((FilterContainerSearchClickArgs)args, (Long)this.getTaxTask().getId());
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean hasLock = (Boolean)parameter.getCustomParam("hasLock");
        if (hasLock == null || !hasLock.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, FORBIDDEN_OP_AFTER_MUTEX_LOCK);
        }
        this.rebuildTabButton();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing_close".equals(operateKey) && (parentView = this.getView().getParentView()) != null) {
            parentView.close();
            this.getView().sendFormAction(parentView);
            IFormView taxTaskListView = parentView.getParentView();
            if (!ObjectUtils.isEmpty((Object)taxTaskListView)) {
                taxTaskListView.invokeOperation("refresh");
                this.getView().sendFormAction(taxTaskListView);
            }
        }
        if ("exportlistbyselectfields".equals(operateKey) || "exportdetails".equals(operateKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u62a5\u9001", (String)"TaxFileTreeList4GuidePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            this.getView().cacheFormShowParameter();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaxDataProviderImpl());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("exportlistbyselectfields".equals(operateKey)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            int total = CollectionUtils.isEmpty((Collection)selectedRows) ? billList.queryBillDataCount() : selectedRows.size();
            if (total == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxDataDiffReportList_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
            TaxTaskEntity taxTask = this.getTaxTask();
            if (taxTask == null) {
                args.setCancel(true);
                return;
            }
            TaskGuideStep0RawDataDownLoadTask task = new TaskGuideStep0RawDataDownLoadTask(taxTask, billList);
            task.setHandleCase(MultiThreadCase.BY_ACTION);
            String dataKey = ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"TaxTaskGuidePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            task.addData(dataKey, total, 500, 1).ofKey(RequestContext.get().getTraceId());
            MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        }
        if ("exportdetails".equals(operateKey)) {
            args.setCancel(true);
            this.showExportResult();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "taxfile.empgroup.name": {
                List empGroupFilters = args.getQfilters();
                this.addEmpGroupFilter(empGroupFilters);
                break;
            }
            case "org.name": {
                List orgFilters = args.getQfilters();
                this.addOrgFilter(orgFilters);
                break;
            }
            case "taxfile.number": {
                List numberFilters = args.getQfilters();
                TaxTaskGuideViewFilter.addOrgFilterForTaxFile((List)numberFilters);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("taxfile.empgroup.name".equals(fieldName)) {
            List empGroupFilters = args.getQFilters();
            this.addEmpGroupFilter(empGroupFilters);
        }
        if ("org.name".equals(fieldName)) {
            List orgFilter = args.getQFilters();
            this.addOrgFilter(orgFilter);
        }
    }

    private void showTab() {
        this.rebuildTabButton();
        this.getView().invokeOperation("refresh");
    }

    private void rebuildTabButton() {
        String currentTab;
        Tab tab = (Tab)this.getView().getControl("tabap");
        switch (currentTab = tab.getCurrentTab()) {
            case "changedtab": {
                this.getView().setVisible(Boolean.TRUE, new String[]{EXPORT_DECLARE_AND_MARK});
                this.getView().setVisible(Boolean.TRUE, new String[]{UNMARK_DECLARE_STATUS});
                this.getView().setVisible(Boolean.TRUE, new String[]{"updatepersonfile"});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EXPORT_DECLARE});
                break;
            }
            case "alltab": {
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPORT_DECLARE_AND_MARK});
                this.getView().setVisible(Boolean.TRUE, new String[]{UNMARK_DECLARE_STATUS});
                this.getView().setVisible(Boolean.TRUE, new String[]{"updatepersonfile"});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EXPORT_DECLARE});
                break;
            }
            case "unchangedtab": {
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPORT_DECLARE_AND_MARK});
                this.getView().setVisible(Boolean.FALSE, new String[]{UNMARK_DECLARE_STATUS});
                this.getView().setVisible(Boolean.FALSE, new String[]{"updatepersonfile"});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EXPORT_DECLARE});
                break;
            }
        }
    }

    private TaxTaskEntity getTaxTask() {
        IFormView view = this.getView().getParentView();
        BaseResult taxTaskRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)view);
        return (TaxTaskEntity)taxTaskRes.getData();
    }

    private String getCurrentTab() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        return StringUtils.isEmpty((String)currentTab) ? CHANGED_TAB : currentTab;
    }

    private void showExportResult() {
        TaxTaskEntity taxTaskEntity = this.getTaxTask();
        if (taxTaskEntity == null) {
            return;
        }
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String bizObject = "itc_taxdatabasic" + taxTaskEntity.getId() + currentTab;
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bos_exportlog");
        param.setFormId("bos_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("bizobject", "=", (Object)bizObject));
        param.getListFilterParameter().setFilter(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()));
        param.setCaption(this.setCaptionByTab());
        this.getView().showForm((FormShowParameter)param);
    }

    private String setCaptionByTab() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String caption = null;
        if (CHANGED_TAB.equals(currentTab)) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            caption = ResManager.loadKDString((String)"\u672c\u671f\u53d8\u52a8", (String)"TaxFileTreeList4GuidePlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            listShowParameter.setCaption(caption);
            this.getView().cacheFormShowParameter();
        } else if (UNCHANGED_TAB.equals(currentTab)) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            caption = ResManager.loadKDString((String)"\u672a\u53d8\u52a8", (String)"TaxFileTreeList4GuidePlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            listShowParameter.setCaption(caption);
            this.getView().cacheFormShowParameter();
        } else if (ALL_TAB.equals(currentTab)) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            caption = ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaxFileTreeList4GuidePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            listShowParameter.setCaption(caption);
            this.getView().cacheFormShowParameter();
        }
        return caption;
    }

    private void addOrgFilter(List<QFilter> originalFilters) {
    }

    private void addEmpGroupFilter(List<QFilter> originalFilters) {
        Set empGrpIds;
        List empGroupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"itc");
        QFilter qFilter = new QFilter("id", "in", (Object)empGroupIds);
        originalFilters.add(qFilter);
        if (!SITPermissionServiceHelper.isSuperUser() && (empGrpIds = SITPermissionServiceHelper.getEmpgrpSetByPermItem((String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)"47150e89000000ac")) != null) {
            QFilter empGroupFilter = new QFilter("id", "in", (Object)empGrpIds);
            originalFilters.add(empGroupFilter);
        }
    }

    private class TaxDataProviderImpl
    extends ListDataProvider {
        private TaxDataProviderImpl() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            TaxTaskGuideViewHelper.cacheFilterAndOrderBy((ListDataProvider)this, (IPageCache)TaxDataForStep10List.this.getView().getPageCache());
            return super.getData(start, limit);
        }
    }
}

