/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.sit.itc.business.taxfile.imports.TaxExportHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskDataExportViewHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRawDataReferRollbackTask;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRawDataReferTask;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRollbackLockTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.TaxDataForStepsList;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.DataHolder;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.lang.StringUtils;

public class TaxDataForStep40List
extends TaxDataForStepsList {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStep40List.class);
    private static final EnumSet<TaxTaskGuideOpEnum> OP_SUPPORTED = EnumSet.of(TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA, new TaxTaskGuideOpEnum[]{TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK, TaxTaskGuideOpEnum.EXPORT_REPORT, TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT, TaxTaskGuideOpEnum.LOCK, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK, TaxTaskGuideOpEnum.VIEW_CAL_REPORT, TaxTaskGuideOpEnum.AFTER_PROCESS_CLOSE});

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BatchResult result;
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
        if (!OP_SUPPORTED.contains(opEnum)) {
            return;
        }
        GlobalParam.remove();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = this.stepCaseInfo(taxTaskEntity);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] taxDataIds = selectedRows.getPrimaryKeyValues();
        switch (opEnum) {
            case REFER_ALL_SRC_DATA: {
                args.setCancel(true);
                BatchResult resultRefAll = TaxTaskGuideServiceHelper.validateReferSrcDataBasic((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Object[])new Object[0]);
                if (!resultRefAll.isContinue()) {
                    this.showErrorMsg(resultRefAll, opEnum);
                    GlobalParam.remove();
                    return;
                }
                Set categoryList = TaxTaskGuideServiceHelper.validateCategoryComplete((TaxTaskEntity)taxTaskEntity, new ArrayList(10));
                if (!CollectionUtils.isEmpty((Collection)categoryList)) {
                    this.showConfirmCategory(taxTaskEntity, categoryList, opEnum);
                    GlobalParam.remove();
                    return;
                }
                this.showConfirmMsgV1((BatchResult<Long>)resultRefAll, opEnum, taxTaskEntity, stepCaseInfo);
                return;
            }
            case REFER_SPECIAL_SRC_DATA: {
                args.setCancel(true);
                this.showFormOfDataSrcSelect(taxTaskEntity, stepCaseInfo);
                return;
            }
            case ROLLBACK_REFER_SRC_DATA_BY_PERSON: {
                args.setCancel(true);
                BatchResult validateRollbackReferPersonResult = TaxTaskGuideServiceHelper.validateRollbackReferSrcDataByPerson((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Object[])taxDataIds);
                if (!validateRollbackReferPersonResult.isContinue()) {
                    this.showErrorMsg(validateRollbackReferPersonResult, opEnum);
                    GlobalParam.remove();
                    return;
                }
                this.showConfirmMsgV1((BatchResult<Long>)validateRollbackReferPersonResult, opEnum, taxTaskEntity, stepCaseInfo);
                return;
            }
            case ROLLBACK_REFER_SRC_DATA_BY_TASK: {
                args.setCancel(true);
                this.showFormOfCalTaskSelect(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK);
                return;
            }
            case ROLLBACK_LOCK_BY_PERSON: {
                args.setCancel(true);
                BatchResult validateRollbackLockByPersonResult = TaxTaskGuideServiceHelper.validateRollbackLockByPerson((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Object[])taxDataIds);
                if (!validateRollbackLockByPersonResult.isContinue()) {
                    this.showErrorMsg(validateRollbackLockByPersonResult, opEnum);
                    GlobalParam.remove();
                    return;
                }
                this.showConfirmMsgV1((BatchResult<Long>)validateRollbackLockByPersonResult, opEnum, taxTaskEntity, stepCaseInfo);
                return;
            }
            case ROLLBACK_LOCK_BY_TASK: {
                args.setCancel(true);
                this.showFormOfCalTaskSelect(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK);
                return;
            }
            case EXPORT_REPORT: {
                DataHolder dealReport = new DataHolder((Object)Boolean.TRUE);
                result = TaxTaskDataExportViewHelper.validateExport((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (ListSelectedRowCollection)selectedRows, (DataHolder)dealReport, (AbstractFormPlugin)this);
                Boolean dealReportVal = (Boolean)dealReport.get();
                if (dealReportVal == null || dealReportVal.booleanValue()) break;
                args.setCancel(true);
                return;
            }
            case VIEW_CAL_REPORT: {
                this.showCalReport(taxTaskEntity);
                return;
            }
            default: {
                return;
            }
        }
        args.setCancel(true);
        if (result == null) {
            return;
        }
        if (!result.isContinue()) {
            this.showErrorMsg(result, opEnum);
            GlobalParam.remove();
            return;
        }
        this.showConfirmMsg((BatchResult<DynamicObject>)result, opEnum, taxTaskEntity, stepCaseInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
        if (!OP_SUPPORTED.contains(opEnum)) {
            return;
        }
        try {
            BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
            TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
            TaxTaskGuideStepCaseInfo stepCaseInfo = this.stepCaseInfo(taxTaskEntity);
            switch (opEnum) {
                case EXPORT_REPORT: {
                    DataHolder dealEx = new DataHolder((Object)Boolean.TRUE);
                    BatchResult result = TaxTaskDataExportViewHelper.openExportReportProgressBar((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (DataHolder)dealEx, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (AbstractFormPlugin)this);
                    Boolean dealExVal = (Boolean)dealEx.get();
                    if (dealExVal != null && !dealExVal.booleanValue()) {
                        return;
                    }
                    this.showResultMsgAfterOp((BatchResult<DynamicObject>)result, opEnum);
                    return;
                }
                case AFTER_PROCESS_CLOSE: {
                    String opkey = this.getPageCache().get("opkey");
                    if (!"reportexport".equals(opkey)) return;
                    this.getPageCache().remove("opkey");
                    String resultStr = this.getPageCache().get("export_result");
                    if (StringUtils.isEmpty((String)resultStr)) {
                        LOGGER.info("error: taxreport export result is null");
                        return;
                    }
                    String url = this.getPageCache().get("url");
                    if (!StringUtils.isEmpty((String)url)) {
                        LOGGER.info("taxreport url is {}", (Object)url);
                        this.getView().download(url);
                    }
                    BatchResult finalResult = (BatchResult)SerializationUtils.deSerializeFromBase64((String)resultStr);
                    String option = ResManager.loadKDString((String)"\u5bfc\u51fa\u7533\u62a5\u8868\u5e76\u9501\u5b9a", (String)"TaxDataForStep40List_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                    TaxTaskDataExportViewHelper.showResultMsgAfterOp((BatchResult)finalResult, (String)option, (IFormView)this.getView());
                    this.getView().invokeOperation("refresh");
                    return;
                }
            }
            return;
        }
        finally {
            GlobalParam.remove();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        GlobalParam.remove();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskEntityRes.isSuccess()) {
            this.getView().showErrorNotification(taxTaskEntityRes.getMessage());
            return;
        }
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = this.stepCaseInfo(taxTaskEntity);
        if ("selectSrcData".equals(actionId)) {
            TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA;
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            Object[] ids = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            this.refSrcData(taxTaskEntity, stepCaseInfo, opEnum, ids);
            return;
        }
        if ("confirmTaxExportTemplate".equals(actionId)) {
            Object templateId = closedCallBackEvent.getReturnData();
            if (null != templateId) {
                if (TaxExportHelper.checkTaxTemplateExportField((Long)((Long)templateId))) {
                    IPageCache pageCache = this.getView().getPageCache();
                    pageCache.put("templateId", SerializationUtils.toJsonString((Object)templateId));
                    if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(taxTaskEntity.getTaxTaskType())) {
                        TaxTaskDataExportViewHelper.validateAllReferedAndChecked((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (AbstractFormPlugin)this);
                    } else {
                        DataHolder dealEx = new DataHolder((Object)Boolean.FALSE);
                        TaxTaskDataExportViewHelper.openExportReportProgressBar((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (DataHolder)dealEx, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (AbstractFormPlugin)this);
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u6a21\u677f\u65e0\u5bfc\u51fa\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxTaskGuideStep1Plugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                }
            }
            return;
        }
        if ("selectCalTask:ROLLBACK_REFER_SRC_DATA_BY_TASK".equals(actionId)) {
            String opStr = actionId.substring("selectCalTask:".length());
            TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.valueOf((String)opStr);
            if (returnData == null) {
                return;
            }
            Long rawCalTaskId = (Long)BaseDataConverter.convert((Object)returnData, Long.class);
            BatchResult taxFileIdRes = TaxTaskGuideServiceHelper.validateRollbackReferSrcDataByTask((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)rawCalTaskId);
            if (!taxFileIdRes.isContinue()) {
                this.showErrorMsg(taxFileIdRes, opEnum);
                GlobalParam.remove();
                return;
            }
            TaskGuideRawDataReferRollbackTask taskGuideRawDataReferRollbackTask = new TaskGuideRawDataReferRollbackTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum, rawCalTaskId.longValue());
            taskGuideRawDataReferRollbackTask.addData(500, taxFileIdRes.getSuccessResult());
            BatchResult executeRollback = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRawDataReferRollbackTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
            if (!executeRollback.isSuccess()) {
                this.getView().showErrorNotification(executeRollback.getMessage());
            }
        } else if (returnData != null && actionId.startsWith("addCategoryForTaxTask:")) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("itc_taxtask");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.EDIT);
            JSONObject param = JSONObject.parseObject((String)BaseDataConverter.toString((Object)returnData));
            Object taxTaskId = param.remove((Object)"taxTaskId");
            parameter.setPkId(taxTaskId);
            parameter.setCustomParams((Map)param);
            CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "finish_" + actionId);
            parameter.setCloseCallBack(cb);
            MutexServiceHelper.release((String)"itc_taxtask", (String)String.valueOf(taxTaskId), (String)"calculateguide");
            this.getView().showForm((FormShowParameter)parameter);
        } else if (actionId.startsWith("finish_addCategoryForTaxTask:")) {
            Long taxTaskId = taxTaskEntity.getId();
            MutexServiceHelper.release((String)"itc_taxtask", (String)String.valueOf(taxTaskId), (String)"modify");
            String key = "taxTaskEntity" + taxTaskId;
            GlobalParam.remove((String)key);
            taxTaskEntity = (TaxTaskEntity)TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId).getData();
            if ("finish".equals(returnData)) {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                TabAp tabAp = this.createTab(parameter);
                this.getView().updateControlMetadata(tabAp.getKey(), tabAp.createControl());
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.selectTab((String)parameter.getCustomParam("defTab"));
                MutexServiceHelper.require((String)"itc_taxtask", (String)String.valueOf(taxTaskId), (String)"calculateguide");
                String opStr = actionId.substring("finish_addCategoryForTaxTask:".length());
                TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.valueOf((String)opStr);
                if (opEnum == TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA) {
                    List ids = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("REF_SRC_DATA_TAX_IDS"), Long.class);
                    this.refSrcData(taxTaskEntity, stepCaseInfo, opEnum, ids == null ? null : ids.toArray(new Object[0]));
                } else {
                    this.getView().invokeOperation(TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA.getCode());
                }
            } else {
                MutexServiceHelper.require((String)"itc_taxtask", (String)String.valueOf(taxTaskId), (String)"calculateguide");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        GlobalParam.remove();
        MessageBoxResult confirmResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        String[] items = actionId.split(":");
        if ("confirm".equals(items[0])) {
            if (MessageBoxResult.OK != confirmResult && MessageBoxResult.Yes != confirmResult) {
                return;
            }
            if (items.length < 2) {
                return;
            }
            TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)items[1]);
            if (opEnum == null) {
                return;
            }
            TaxTaskGuideCacheData taxTaskGuideCacheData = this.recoverRefDataFromCache(opEnum);
            if (taxTaskGuideCacheData == null) {
                return;
            }
            BaseResult taskRes = TaxTaskServiceHelper.reInitFromBd((TaxTaskEntity)taxTaskGuideCacheData.getTaxTaskEntity());
            taxTaskGuideCacheData.setTaxTaskEntity((TaxTaskEntity)taskRes.getData());
            BatchResult result = null;
            switch (opEnum) {
                case REFER_ALL_SRC_DATA: 
                case REFER_SPECIAL_SRC_DATA: {
                    TaskGuideRawDataReferTask taskGuideRawDataReferTask = new TaskGuideRawDataReferTask(this.getView(), taxTaskGuideCacheData.getTaxTaskEntity(), taxTaskGuideCacheData.getStepCaseInfo(), opEnum);
                    taskGuideRawDataReferTask.addData(500, taxTaskGuideCacheData.getSrcDataIds());
                    BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRawDataReferTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    if (!execute.isSuccess()) {
                        this.getView().showErrorNotification(execute.getMessage());
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)execute.getMessage());
                    }
                    return;
                }
                case ROLLBACK_REFER_SRC_DATA_BY_PERSON: {
                    TaskGuideRawDataReferRollbackTask taskGuideRawDataReferRollbackTask = new TaskGuideRawDataReferRollbackTask(this.getView(), taxTaskGuideCacheData.getTaxTaskEntity(), taxTaskGuideCacheData.getStepCaseInfo(), opEnum, 0L);
                    taskGuideRawDataReferRollbackTask.addData(500, taxTaskGuideCacheData.getTaxDataIds());
                    BatchResult executeRollback = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRawDataReferRollbackTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    if (!executeRollback.isSuccess()) {
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollback.getMessage());
                        this.getView().showErrorNotification(executeRollback.getMessage());
                    }
                    return;
                }
                case ROLLBACK_LOCK_BY_PERSON: {
                    TaskGuideRollbackLockTask taskGuideRollbackLockTask = new TaskGuideRollbackLockTask(this.getView(), taxTaskGuideCacheData.getTaxTaskEntity(), taxTaskGuideCacheData.getStepCaseInfo(), opEnum, 0L);
                    taskGuideRollbackLockTask.addData(500, taxTaskGuideCacheData.getTaxDataIds());
                    BatchResult executeRollbackLock = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRollbackLockTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    if (!executeRollbackLock.isSuccess()) {
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollbackLock.getMessage());
                        this.getView().showErrorNotification(executeRollbackLock.getMessage());
                    }
                    return;
                }
                case EXPORT_REPORT: {
                    String customValue = messageBoxClosedEvent.getCustomVaule();
                    result = TaxTaskDataExportViewHelper.confirmCallBackMethods((IFormView)this.getView(), (TaxTaskEntity)taxTaskGuideCacheData.getTaxTaskEntity(), (TaxTaskGuideStepCaseInfo)taxTaskGuideCacheData.getStepCaseInfo(), (String)customValue, (AbstractFormPlugin)this);
                    break;
                }
            }
            if (result != null) {
                this.showResultMsgAfterOp(result, opEnum);
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        TaxTaskEntity taxTask = (TaxTaskEntity)SerializationUtils.fromJsonString((String)((String)parameter.getCustomParam("taxTaskEntity")), TaxTaskEntity.class);
        if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(taxTask.getTaxTaskType())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_referallsalarydata", "btn_rollbackrefersalary"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_referspecialsalaryda1", "btn_viewcalreport"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_referallsalarydata", "btn_rollbackrefersalary"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_referspecialsalaryda1", "btn_viewcalreport"});
        }
    }

    protected String tabFilterKey() {
        return "taxcategory.id";
    }

    @Override
    protected String propNameOfTaxValue() {
        return "calvalue";
    }

    @Override
    protected boolean tabByGroup() {
        return false;
    }

    private void showCalReport(TaxTaskEntity taxTaskEntity) {
        IFormView view = this.getView();
        Long taxTaskId = taxTaskEntity.getId();
        ListShowParameter listShowParameter = new ListShowParameter();
        Map customParams = view.getFormShowParameter().getCustomParams();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId("itc_taxcalreport");
        listShowParameter.setCustomParam("type", (Object)"list");
        listShowParameter.setCustomParams(customParams);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("taxtask.id", "=", (Object)taxTaskId));
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void refSrcData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, Object[] ids) {
        BatchResult result = TaxTaskGuideServiceHelper.validateReferSrcDataBasic((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Object[])ids);
        if (!result.isSuccess()) {
            this.showErrorMsg(result, opEnum);
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "in", (Object)ids));
        Set categoryList = TaxTaskGuideServiceHelper.validateCategoryComplete((TaxTaskEntity)taxTaskEntity, qFilters);
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            this.getView().getPageCache().put("REF_SRC_DATA_TAX_IDS", SerializationUtils.toJsonString((Object)ids));
            this.showConfirmCategory(taxTaskEntity, categoryList, opEnum);
            GlobalParam.remove();
            return;
        }
        TaskGuideRawDataReferTask taskGuideRawDataReferTask = new TaskGuideRawDataReferTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum);
        taskGuideRawDataReferTask.addData(500, result.getSuccessResult());
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRawDataReferTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.getView().showErrorNotification(execute.getMessage());
        }
    }

    private void showConfirmCategory(TaxTaskEntity taxTaskEntity, Collection<Long> categoryList, TaxTaskGuideOpEnum opEnum) {
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "addCategoryForTaxTask:" + opEnum.name());
        String msg = ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u7684\u4e2a\u7a0e\u6e90\u6570\u636e\u8fd8\u6709\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u672a\u9009\u62e9\u7684\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u8bf7\u5728\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u6dfb\u52a0\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxDataForStep40List_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        FormShowParameter operationConfirmParameter = SITShowFormServiceHelper.getConfirmParameter((CloseCallBack)cb, (String)msg, null);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("taxTaskId", taxTaskEntity.getId());
        param.put("addTaxCategoryIds", categoryList.toArray(new Long[0]));
        operationConfirmParameter.setCustomParam("callbackContent", (Object)JSONObject.toJSONString(param));
        operationConfirmParameter.setCustomParam("btnCustom", (Object)Boolean.TRUE);
        operationConfirmParameter.setCustomParam("btnCancelShow", (Object)Boolean.FALSE);
        HashMap<String, LocaleString> btnOkMeta = new HashMap<String, LocaleString>(2);
        btnOkMeta.put("text", ResManager.getLocaleString((String)"\u524d\u5f80\u6dfb\u52a0", (String)"TaxDataForStep40List_0", (String)"sit-itc-formplugin"));
        operationConfirmParameter.setCustomParam("btnOkMeta", btnOkMeta);
        GlobalParam.remove();
        this.getView().showForm(operationConfirmParameter);
    }
}

