/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideDeclareTask;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRollbackImportTask;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRollbackLockTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.TaxDataForStepsList;
import kd.sit.itc.formplugin.web.taskguide.task.TaxDataFeedbackTask;
import kd.sit.itc.formplugin.web.taskguide.task.TaxDataRollbackFeedbackTask;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataForStep60List
extends TaxDataForStepsList {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStep60List.class);
    private static final EnumSet<TaxTaskGuideOpEnum> OP_SUPPORTED = EnumSet.of(TaxTaskGuideOpEnum.DECLARE, new TaxTaskGuideOpEnum[]{TaxTaskGuideOpEnum.IMPORT, TaxTaskGuideOpEnum.ROLLBACK_IMPORT, TaxTaskGuideOpEnum.FEEDBACK, TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK});

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TaxTaskGuideOpEnum.FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getBtnFlag()});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TaxTaskGuideOpEnum.FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getBtnFlag()});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
        if (opEnum == null || !OP_SUPPORTED.contains(opEnum)) {
            return;
        }
        GlobalParam.remove();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] taxDataIds = selectedRows.getPrimaryKeyValues();
        switch (opEnum) {
            case IMPORT: {
                args.setCancel(true);
                this.importExcel();
                return;
            }
            case ROLLBACK_IMPORT: {
                args.setCancel(true);
                this.showConfirmForRollbackImport(taxTaskEntity, opEnum, stepCaseInfo);
                return;
            }
            case DECLARE: {
                args.setCancel(true);
                this.showConfirmForDeclare(taxTaskEntity, opEnum, stepCaseInfo);
                return;
            }
            case FEEDBACK: {
                args.setCancel(true);
                this.showConfirmForFeedback();
                return;
            }
            case ROLLBACK_FEEDBACK: {
                args.setCancel(true);
                this.showFormOfCalTaskSelect(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK);
                return;
            }
            case ROLLBACK_LOCK_BY_PERSON: {
                args.setCancel(true);
                BatchResult validateRollbackLockByPersonResult = TaxTaskGuideServiceHelper.validateRollbackLockByPerson((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Object[])taxDataIds);
                if (!validateRollbackLockByPersonResult.isContinue()) {
                    this.showErrorMsg(validateRollbackLockByPersonResult, opEnum);
                    GlobalParam.remove();
                    return;
                }
                this.showConfirmMsgV1((BatchResult<Long>)validateRollbackLockByPersonResult, opEnum, taxTaskEntity, stepCaseInfo);
                return;
            }
            case ROLLBACK_LOCK_BY_TASK: {
                args.setCancel(true);
                this.showFormOfCalTaskSelect(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String[] items;
        MessageBoxResult confirmResult = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.OK != confirmResult && MessageBoxResult.Yes != confirmResult) {
            return;
        }
        String actionId = messageBoxClosedEvent.getCallBackId();
        if ("TaxItemConfirm".equals(actionId)) {
            this.showImportPage(confirmResult);
        }
        if ((items = actionId.split(":")).length < 2) {
            return;
        }
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)items[1]);
        if (opEnum == null) {
            return;
        }
        if ("confirm".equals(items[0]) || "PERSON_DECLARE_CONFIRM".equals(items[0]) || "PREPARE_STATUS_CONFIRM".equals(items[0])) {
            BatchResult result = null;
            BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
            TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
            TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
            SITPageCache pageCache = new SITPageCache(this.getView());
            Long taxUnitId = (Long)pageCache.get("taxUnitId", Long.class);
            String successLog = MessageFormat.format(ResManager.loadKDString((String)"{0}\u6210\u529f", (String)"TaxDataForStep60List_0", (String)"sit-itc-formplugin", (Object[])new Object[0]), opEnum.loadKDString());
            switch (opEnum) {
                case ROLLBACK_IMPORT: {
                    result = TaxTaskGuideServiceHelper.validateRollbackImport((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)taxUnitId);
                    if (!result.isSuccess()) {
                        this.showErrorMsg(result, opEnum);
                        break;
                    }
                    TaskGuideRollbackImportTask taskGuideRollbackImportTask = new TaskGuideRollbackImportTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum, taxUnitId.longValue());
                    taskGuideRollbackImportTask.addData(500, result.getSuccessResult());
                    BatchResult executeRollbackImport = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRollbackImportTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getImportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getImportHanddataThreadPool());
                    if (!executeRollbackImport.isSuccess()) {
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollbackImport.getMessage());
                        this.getView().showErrorNotification(executeRollbackImport.getMessage());
                        break;
                    }
                    SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)successLog);
                    break;
                }
                case DECLARE: {
                    if ("PERSON_DECLARE_CONFIRM".equals(items[0]) || "PREPARE_STATUS_CONFIRM".equals(items[0])) {
                        pageCache.put(items[0], (Object)taxUnitId);
                    }
                    this.validateDeclare(taxUnitId, taxTaskEntity, stepCaseInfo, opEnum, false);
                    break;
                }
                case FEEDBACK: {
                    this.feedback(taxTaskEntity, stepCaseInfo, opEnum);
                    break;
                }
                case ROLLBACK_LOCK_BY_PERSON: {
                    TaxTaskGuideCacheData taxTaskGuideCacheData = this.recoverRefDataFromCache(opEnum);
                    if (taxTaskGuideCacheData == null) {
                        return;
                    }
                    BaseResult taskRes = TaxTaskServiceHelper.reInitFromBd((TaxTaskEntity)taxTaskGuideCacheData.getTaxTaskEntity());
                    taxTaskGuideCacheData.setTaxTaskEntity((TaxTaskEntity)taskRes.getData());
                    TaskGuideRollbackLockTask taskGuideRollbackLockTask = new TaskGuideRollbackLockTask(this.getView(), taxTaskGuideCacheData.getTaxTaskEntity(), taxTaskGuideCacheData.getStepCaseInfo(), opEnum, 0L);
                    taskGuideRollbackLockTask.addData(500, taxTaskGuideCacheData.getTaxDataIds());
                    BatchResult executeRollbackLock = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRollbackLockTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    if (!executeRollbackLock.isSuccess()) {
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollbackLock.getMessage());
                        this.getView().showErrorNotification(executeRollbackLock.getMessage());
                    } else {
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)successLog);
                    }
                    return;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        TaxTaskGuideOpEnum opEnum;
        String opStr;
        GlobalParam.remove();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        if ("taxTemplateCallback".equals(actionId)) {
            if (null != returnData) {
                String opName = TaxTaskGuideOpEnum.of((String)"importtaxresult").loadKDString();
                TaxTaskGuideImportServiceHelper.openImportingPage((Map)((Map)returnData), (IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (String)((Object)((Object)this)).getClass().getName(), (String)"taxImportCallback", (String)"itc_taxdata", (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)opName, (AbstractFormPlugin)this);
            } else {
                this.getView().invokeOperation("refresh");
            }
        }
        if ("taxImportCallback".equals(actionId)) {
            MutexServiceHelper.release((String)"itc_taxtask", (String)String.valueOf(taxTaskEntity.getId()), (String)"calculateguide");
            this.getView().invokeOperation("refresh");
        }
        if ("prepareAndPersonDeclareConfirm".equals(actionId) && returnData instanceof Boolean) {
            SITPageCache pageCache = new SITPageCache(this.getView());
            Long taxUnitId = (Long)pageCache.get("taxUnitId", Long.class);
            this.validateDeclare(taxUnitId, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.DECLARE, true);
        }
        if ("selectTaxUnit:DECLARE".equals(actionId) || "selectTaxUnit:ROLLBACK_IMPORT".equals(actionId)) {
            opStr = actionId.substring("selectCalTask:".length());
            opEnum = TaxTaskGuideOpEnum.valueOf((String)opStr);
            if (returnData == null) {
                return;
            }
            this.getPageCache().put("taxUnitId", (String)returnData);
            this.getView().showConfirm(opEnum.confirmMsgI18n(new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
        } else if (actionId.startsWith("selectCalTask:")) {
            opStr = actionId.substring("selectCalTask:".length());
            opEnum = TaxTaskGuideOpEnum.valueOf((String)opStr);
            if (returnData == null) {
                return;
            }
            switch (opEnum) {
                case ROLLBACK_FEEDBACK: {
                    HashMap dataMap = (HashMap)returnData;
                    Long rawCalTaskId = (Long)BaseDataConverter.convert(dataMap.get("caltask"), Long.class);
                    String option = (String)dataMap.get("option");
                    HashMap fileAndTaxDataIdMap = Maps.newHashMapWithExpectedSize((int)16);
                    BatchResult taxFileIdRes = TaxTaskGuideServiceHelper.basicValidateForRollbackFeedBackByTask((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)rawCalTaskId, (Map)fileAndTaxDataIdMap);
                    if (!taxFileIdRes.isContinue()) {
                        this.showErrorMsg(taxFileIdRes, opEnum);
                        GlobalParam.remove();
                        return;
                    }
                    TaxDataRollbackFeedbackTask task = new TaxDataRollbackFeedbackTask(this.getView(), taxTaskEntity, stepCaseInfo, rawCalTaskId, option, fileAndTaxDataIdMap);
                    task.addData(500, taxFileIdRes.getSuccessResult());
                    LOGGER.info("by cyh: TaxDataRollbackFeedbackTask begin");
                    MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)false, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    return;
                }
                case ROLLBACK_LOCK_BY_TASK: {
                    Long rawCalTaskId = (Long)BaseDataConverter.convert((Object)returnData, Long.class);
                    BatchResult taxDataRes = TaxTaskGuideServiceHelper.validateRollbackLockByTask((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)rawCalTaskId);
                    if (!taxDataRes.isContinue()) {
                        this.showErrorMsg(taxDataRes, opEnum);
                        GlobalParam.remove();
                        return;
                    }
                    TaskGuideRollbackLockTask taskGuideRollbackLockTask = new TaskGuideRollbackLockTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum, rawCalTaskId.longValue());
                    taskGuideRollbackLockTask.addData(500, taxDataRes.getSuccessResult());
                    BatchResult executeRollbackLock = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRollbackLockTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                    if (!executeRollbackLock.isSuccess()) {
                        this.getView().showErrorNotification(executeRollbackLock.getMessage());
                    }
                    return;
                }
            }
        }
    }

    protected String tabFilterKey() {
        return "taxcategory.group.id";
    }

    @Override
    protected TabPageAp[] getTabPage(FormShowParameter parameter) {
        return this.tabPageFromGroup(parameter);
    }

    private void importExcel() {
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        int dataCount = billList.queryBillDataCount();
        if (dataCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u53ef\u4ee5\u5bfc\u5165\u7a0e\u5c40\u6570\u636e\u3002", (String)"TaxTaskGuideStep2Plugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        Long taxGroupId = stepCaseInfo.getTabValue();
        TaxTaskGuideImportServiceHelper.showSelectForm((IFormView)this.getView(), (long)taxGroupId, (String)"3", (String)((Object)((Object)this)).getClass().getName(), (String)"taxTemplateCallback", (TaxTaskEntity)taxTaskEntity);
    }

    private void showConfirmForFeedback() {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedIds = billlist.getSelectedRows();
        int count = selectedIds.size();
        boolean selectAll = false;
        String msg = "";
        if (count != 0) {
            msg = ResManager.loadKDString((String)"\u5c06\u4f1a\u5bf9\u9009\u4e2d\u4e2a\u7a0e\u8bb0\u5f55\u8fdb\u884c\u63a8\u9001\u7b97\u85aa\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxTaskGuideStep2Plugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        } else {
            count = billlist.queryBillDataCount();
            if (count != 0) {
                selectAll = true;
                msg = ResManager.loadKDString((String)"\u5c06\u4f1a\u5bf9\u6240\u6709\u4e2a\u7a0e\u8bb0\u5f55\u8fdb\u884c\u63a8\u9001\u7b97\u85aa\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxTaskGuideStep2Plugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().getPageCache().put("CACHE_SELECTALL", String.valueOf(selectAll));
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm:feedback", (IFormPlugin)this));
    }

    private void feedback(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        BatchResult taxDataRes;
        boolean selectAll = Boolean.parseBoolean(this.getPageCache().get("CACHE_SELECTALL"));
        Object[] selectIds = null;
        if (!selectAll) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            selectIds = selectedRows.getPrimaryKeyValues();
        }
        if (!(taxDataRes = TaxTaskGuideServiceHelper.basicValidateForRollbackOpByPerson((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, selectIds, (TaxTaskGuideOpEnum)TaxTaskGuideOpEnum.FEEDBACK)).isContinue()) {
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)taxDataRes.getMessage());
            this.showErrorMsg(taxDataRes, opEnum);
            GlobalParam.remove();
            return;
        }
        String successLog = MessageFormat.format(ResManager.loadKDString((String)"{0}\u6210\u529f", (String)"TaxTaskGuideStep2Plugin_7", (String)"sit-itc-formplugin", (Object[])new Object[0]), opEnum.loadKDString());
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)successLog);
        TaxDataFeedbackTask taxDataFeedbackTask = new TaxDataFeedbackTask(this.getView(), taxTaskEntity, stepCaseInfo);
        taxDataFeedbackTask.addData(500, taxDataRes.getSuccessResult());
        MultiThreadTaskExecutor.execute((MultiThreadTask)taxDataFeedbackTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
    }

    private void showConfirmForRollbackImport(TaxTaskEntity taxTaskEntity, TaxTaskGuideOpEnum opEnum, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        int count = billlist.queryBillDataCount();
        if (count == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u4e2a\u7a0e\u8bb0\u5f55\u7684\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxTaskGuideStep2Plugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.showConfirmMsgForTaxUnit(taxTaskEntity, opEnum, msg, stepCaseInfo);
    }

    private void showConfirmForDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideOpEnum opEnum, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        DynamicObject dynamicObject = TaxTaskGuideServiceHelper.queryStep3OneTaxData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)TaxTaskGuideOpEnum.LOCK.getCode(), null);
        if (null == dynamicObject && TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5bfc\u5165\u7a0e\u5c40\u6570\u636e\u4e0d\u53ef\u6807\u8bb0\u7533\u62a5\u3002", (String)"TaxDataForStep60List_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == dynamicObject) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6807\u8bb0\u7533\u62a5\u7684\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxTaskGuideStep2Plugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.showConfirmMsgForTaxUnit(taxTaskEntity, opEnum, msg, stepCaseInfo);
    }

    private void showImportPage(MessageBoxResult confirmResult) {
        if (MessageBoxResult.Yes == confirmResult) {
            BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
            TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
            TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
            IPageCache pageCache = this.getView().getPageCache();
            String url = pageCache.get("importUrl");
            String taxUnitId = pageCache.get("importTaxUnit");
            TaxTaskGuideImportServiceHelper.openImportingPage((String)url, (IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity, (String)((Object)((Object)this)).getClass().getName(), (String)"taxImportCallback", (String)"itc_taxdata", (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)TaxTaskGuideOpEnum.of((String)"importtaxresult").loadKDString(), (Long)((Long)BaseDataConverter.convert((Object)taxUnitId, Long.class)));
        }
    }

    private void validateDeclare(Long taxUnitId, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, boolean isColseCallBack) {
        List list;
        BatchResult result = TaxTaskGuideServiceHelper.validateDeclare((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)taxUnitId);
        if (!result.isSuccess() && ResultStatusEnum.ERROR.getCode() == result.getStatus()) {
            this.showErrorMsg(result, opEnum);
            return;
        }
        if (!isColseCallBack && !CollectionUtils.isEmpty((Collection)(list = TaxTaskGuideServiceHelper.validatePrepareAndPersonDeclareForDeclare((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)taxUnitId))) && list.size() > 0) {
            String title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u90e8\u5206\u4eba\u5458\u672a\u62a5\u9001\uff0c\u5c06\u5bfc\u81f4\u4e1a\u52a1\u4e0d\u5b8c\u6574\uff0c\u786e\u8ba4\u7ee7\u7eed\u6807\u8bb0\u7533\u62a5\u5417\uff1f", (String)"TaxDataForStep60List_3", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType())) {
                title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u90e8\u5206\u4eba\u5458\u672a\u62a5\u9001\u6216\u7b97\u7a0e\u6570\u636e\u672a\u51c6\u5907\u5b8c\u6210\uff0c\u5c06\u5bfc\u81f4\u4e1a\u52a1\u4e0d\u5b8c\u6574\uff0c\u786e\u8ba4\u7ee7\u7eed\u6807\u8bb0\u7533\u62a5\u5417\uff1f", (String)"TaxDataForStep60List_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            }
            FormShowParameter operationResultParameter = SITShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, "prepareAndPersonDeclareConfirm"), (String)opEnum.getSitI18nParam().getDescription(), (String)title, (List)list, (boolean)true);
            this.getView().showForm(operationResultParameter);
            return;
        }
        TaskGuideDeclareTask taskGuideDeclareTask = new TaskGuideDeclareTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum, taxUnitId.longValue());
        taskGuideDeclareTask.addData(result.getSuccessResult().size(), result.getSuccessResult());
        BatchResult executeDeclare = MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideDeclareTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
        if (!executeDeclare.isSuccess()) {
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeDeclare.getMessage());
            this.getView().showErrorNotification(executeDeclare.getMessage());
        }
    }
}

