/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaxGuideConfirmTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.TaxDataForStepsList;
import kd.sit.sitbp.business.api.StepSwitcher;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.DiffReportSwitcher;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;

public class TaxDataForStep70List
extends TaxDataForStepsList {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStep70List.class);

    protected String tabFilterKey() {
        return "taxcategory.group.id";
    }

    @Override
    protected TabPageAp[] getTabPage(FormShowParameter parameter) {
        return this.tabPageFromGroup(parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        switch (opEnum) {
            case VIEW_DIF_REPORT: {
                args.setCancel(true);
                this.showFormOfDiffReport(taxTaskEntity, this.stepCaseInfo(taxTaskEntity));
                return;
            }
            case CONFIRM: {
                args.setCancel(true);
                this.showConfirmMsgForConfirm(taxTaskEntity, this.stepCaseInfo(taxTaskEntity), opEnum);
                break;
            }
            case ROLLBACK_DECLARE: {
                args.setCancel(true);
                GlobalParam.remove();
                TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
                this.showConfirmForRollbackDeclare(taxTaskEntity, stepCaseInfo);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult confirmResult = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.OK != confirmResult && MessageBoxResult.Yes != confirmResult) {
            return;
        }
        String actionId = messageBoxClosedEvent.getCallBackId();
        String[] items = actionId.split(":");
        if (items.length < 2) {
            return;
        }
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)items[1]);
        if (opEnum == null) {
            return;
        }
        if ("confirm".equals(items[0])) {
            switch (opEnum) {
                case CONFIRM: {
                    this.doConfirm(opEnum);
                    break;
                }
                case ROLLBACK_DECLARE: {
                    TaxTaskGuideCacheData taxTaskGuideCacheData = this.recoverRefDataFromCache(opEnum);
                    if (taxTaskGuideCacheData == null) {
                        return;
                    }
                    TaxTaskEntity taxTaskEntity = taxTaskGuideCacheData.getTaxTaskEntity();
                    TaxTaskGuideStepCaseInfo stepCaseInfo = taxTaskGuideCacheData.getStepCaseInfo();
                    SITPageCache pageCache = new SITPageCache(this.getView());
                    pageCache.remove("dataOfPrevRequest");
                    if (MessageBoxResult.Yes != confirmResult) break;
                    Long taxUnitId = (Long)pageCache.get("taxUnitId", Long.class);
                    BatchResult result = TaxTaskGuideServiceHelper.validateRollbackDeclare((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)taxUnitId);
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u4e2d\u65e0\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep3Plugin_8", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                    this.validateListIsExistDataAndExecute((BatchResult<DynamicObject>)result, taxTaskEntity, stepCaseInfo, msg);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        GlobalParam.remove();
        String actionId = evt.getActionId();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "selectTaxUnit:ROLLBACK_DECLARE": {
                this.validateTaxUnitIsExistTaxData(taxTaskEntity, stepCaseInfo, returnData);
                break;
            }
        }
    }

    @Override
    protected boolean isNeedRawData() {
        return false;
    }

    private void validateListIsExistDataAndExecute(BatchResult<DynamicObject> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String msg) {
        if (null != result) {
            int successSize = result.getSuccessResult().size();
            int failSize = result.getFailResult().size();
            if (0 == successSize && 0 == failSize) {
                this.getView().showErrorNotification(msg);
            } else if (ResultStatusEnum.WARN.getCode() == result.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u4e2d\u5b58\u5728\u5df2\u786e\u8ba4\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6807\u8bb0\u7533\u62a5\u3002", (String)"RollbackDeclareForTaxDataList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            } else {
                result = TaxTaskGuideServiceHelper.rollbackDeclareData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, result);
                this.showResultMsgAfterOp((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.ROLLBACK_DECLARE);
            }
        }
    }

    private void validateTaxUnitIsExistTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object returnData) {
        if (returnData == null) {
            return;
        }
        Long taxUnitId = (Long)ObjectConverter.convert((Object)returnData, Long.class, (boolean)true);
        QFilter filter = new QFilter("reportoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.DECLARE.getCode());
        filter.and(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        BatchResult result = TaxTaskGuideServiceHelper.queryStep4AllTaxData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)TaxTaskGuideOpEnum.ROLLBACK_END.getCode(), (QFilter)filter);
        String msg = ResManager.loadKDString((String)"\u6240\u9009\u7eb3\u7a0e\u5355\u4f4d\u5728\u5f53\u524d\u5217\u8868\u4e2d\u65e0\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep3Plugin_10", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.validateListIsExistDataAndExecute((BatchResult<DynamicObject>)result, taxTaskEntity, stepCaseInfo, msg);
    }

    private void showConfirmForRollbackDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        DynamicObject dynamicObject = TaxTaskGuideServiceHelper.queryStep4OneTaxData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, null);
        if (null == dynamicObject) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showConfirmMsgForTaxUnit(taxTaskEntity, TaxTaskGuideOpEnum.ROLLBACK_DECLARE, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64a4\u9500\u6807\u8bb0\u7533\u62a5\u7684\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxTaskGuideStep3Plugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), stepCaseInfo);
    }

    protected void showFormOfDiffReport(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        if (this.isHaveData(taxTaskEntity)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setCustomParam("stepCode", (Object)stepCaseInfo.getStepCode());
            showParameter.setCustomParam("defTab", this.getView().getFormShowParameter().getCustomParam("defTab"));
            showParameter.setCustomParam("hasLock", this.getView().getFormShowParameter().getCustomParam("hasLock"));
            String title = "";
            String parentCaption = this.getView().getParentView().getFormShowParameter().getCaption();
            if (StringUtils.isNotBlank((CharSequence)parentCaption)) {
                title = parentCaption.substring(parentCaption.indexOf(45));
            }
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e2a\u7a0e\u5dee\u503c {0}", (String)"TaxDataDiffReportList_7", (String)"sit-itc-formplugin", (Object[])new Object[]{title}));
            DiffReportSwitcher diffSwitcher = (DiffReportSwitcher)StepSwitcher.getInstanceBy((String)"diffreport");
            diffSwitcher.decorateFilterParameter(showParameter.getListFilterParameter().getQFilters(), taxTaskEntity);
            diffSwitcher.decorateShowParameter(showParameter, taxTaskEntity);
            this.getView().getParentView().showForm((FormShowParameter)showParameter);
            this.getView().sendFormAction(this.getView().getParentView());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u6ca1\u6709\u5dee\u503c\u3002", (String)"TaxDataDiffReportList_6", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean isHaveData(TaxTaskEntity taxTaskEntity) {
        QFilter filter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        filter.and("status", "!=", (Object)"E");
        filter.and("hasdifference", "=", (Object)"1");
        filter.and("taxfile.taxunit.id", "in", taxTaskEntity.getTaxUnitMap().keySet());
        filter.and("bizstatus", ">=", (Object)TaxDataBizStatusEnum.DECLARE.getCode());
        filter.and("taxdatabasic.status", "!=", (Object)"E");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
        int size = serviceHelper.count("itc_taxdata", new QFilter[]{filter});
        return size > 0;
    }

    private void doConfirm(TaxTaskGuideOpEnum opEnum) {
        List<Object> taxDataIds;
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        boolean isSelect = Boolean.parseBoolean(this.getView().getPageCache().get("IS_SELECT"));
        if (!isSelect) {
            BatchResult result = TaxTaskGuideServiceHelper.validateConfirm((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo);
            if (!result.isSuccess()) {
                this.showErrorMsg(result, opEnum);
                return;
            }
            taxDataIds = result.getSuccessResult();
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] selectIds = selectedRows.getPrimaryKeyValues();
            taxDataIds = Arrays.asList(selectIds);
        }
        TaxGuideConfirmTask taxGuideConfirmTask = new TaxGuideConfirmTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum);
        taxGuideConfirmTask.addData(500, taxDataIds);
        BatchResult executeRollbackImport = MultiThreadTaskExecutor.execute((MultiThreadTask)taxGuideConfirmTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
        if (!executeRollbackImport.isSuccess()) {
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollbackImport.getMessage());
            this.getView().showErrorNotification(executeRollbackImport.getMessage());
        } else {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u6210\u529f", (String)"TaxDataForStep70List_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), opEnum.loadKDString());
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)msg);
        }
    }

    private void showConfirmMsgForConfirm(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedIds = billlist.getSelectedRows();
        int count = selectedIds.size();
        boolean isSelect = false;
        String msg = "";
        if (count != 0) {
            isSelect = true;
        } else {
            count = billlist.queryBillDataCount();
            if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxDataForStep70List_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().getPageCache().put("IS_SELECT", String.valueOf(isSelect));
        this.getView().showConfirm(opEnum.confirmMsgI18n(new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
        BatchResult result = new BatchResult(false, null).ofStatus(ResultStatusEnum.WARN.getCode()).ofMessage(msg);
        this.showConfirmMsg((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.CONFIRM, taxTaskEntity, stepCaseInfo);
    }
}

