/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaxGuideRollbackConfirmTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.TaxDataForStepsList;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;

public class TaxDataForStep80List
extends TaxDataForStepsList {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStep80List.class);
    private static final EnumSet<TaxTaskGuideOpEnum> OP_SUPPORTED = EnumSet.of(TaxTaskGuideOpEnum.END, TaxTaskGuideOpEnum.ROLLBACK_END, TaxTaskGuideOpEnum.ROLLBACK_CONFIRM, TaxTaskGuideOpEnum.ROLLBACK_DECLARE);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getBtnFlag()});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TaxTaskGuideOpEnum.ROLLBACK_CONFIRM.getBtnFlag()});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
        if (opEnum == null || !OP_SUPPORTED.contains(opEnum)) {
            return;
        }
        GlobalParam.remove();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        args.setCancel(true);
        switch (opEnum) {
            case END: {
                TaxTaskServiceHelper.openCountDownF7((IFormPlugin)this, (IFormView)this.getView());
                break;
            }
            case ROLLBACK_END: {
                BatchResult result = new BatchResult(false, null).ofStatus(ResultStatusEnum.WARN.getCode()).ofMessage(ResManager.loadKDString((String)"\u662f\u5426\u64a4\u9500\u7ed3\u675f\u4e2a\u7a0e\u4efb\u52a1\uff1f", (String)"TaxTaskGuideStep3Plugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                this.showConfirmMsg((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.ROLLBACK_END, taxTaskEntity, stepCaseInfo);
                break;
            }
            case ROLLBACK_CONFIRM: {
                this.showConfirmMsgForRollbackConfirm(taxTaskEntity, stepCaseInfo, opEnum);
                break;
            }
            case ROLLBACK_DECLARE: {
                args.setCancel(true);
                GlobalParam.remove();
                this.showConfirmForRollbackDeclare(taxTaskEntity, stepCaseInfo);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult confirmResult = messageBoxClosedEvent.getResult();
        GlobalParam.remove();
        String actionId = messageBoxClosedEvent.getCallBackId();
        String[] items = actionId.split(":");
        if (items.length < 2) {
            return;
        }
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)items[1]);
        if (opEnum == null) {
            return;
        }
        if ("confirm".equals(items[0])) {
            TaxTaskGuideCacheData taxTaskGuideCacheData = this.recoverRefDataFromCache(opEnum);
            if (taxTaskGuideCacheData == null) {
                return;
            }
            TaxTaskEntity taxTaskEntity = taxTaskGuideCacheData.getTaxTaskEntity();
            TaxTaskGuideStepCaseInfo stepCaseInfo = taxTaskGuideCacheData.getStepCaseInfo();
            switch (opEnum) {
                case END: {
                    BatchResult result;
                    if (MessageBoxResult.Yes == confirmResult && (result = TaxTaskGuideServiceHelper.rollbackEndData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo)).isSuccess()) {
                        String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u8bb0\u5f55\u6807\u8bb0\u6210\u529f\u3002", (String)"TaxTaskGuideStep3Plugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(msg);
                        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)TaxTaskGuideOpEnum.of((String)"rollbackend").loadKDString(), (String)msg);
                    }
                    this.refreshTaxDataStatus(taxTaskEntity);
                    break;
                }
                case ROLLBACK_END: {
                    if (MessageBoxResult.Yes != confirmResult) break;
                    this.validateRollbackEnd(taxTaskEntity, stepCaseInfo);
                    break;
                }
                case ROLLBACK_CONFIRM: {
                    if (MessageBoxResult.Yes != confirmResult) break;
                    this.doRollbackConfirm(taxTaskEntity, stepCaseInfo, opEnum);
                    break;
                }
                case ROLLBACK_DECLARE: {
                    this.confirmRollBackDeclare(confirmResult, taxTaskEntity, stepCaseInfo);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        GlobalParam.remove();
        String actionId = evt.getActionId();
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)taxTaskEntityRes.getData();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taxTaskEntity);
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "sitbp_countdown": {
                this.confirmFinishTaxTask(taxTaskEntity, stepCaseInfo, returnData);
                break;
            }
            case "selectTaxUnit:ROLLBACK_DECLARE": {
                this.validateTaxUnitIsExistTaxData(taxTaskEntity, stepCaseInfo, returnData);
                break;
            }
            case "itc_taxdata": 
            case "itc_taxrawdata": {
                if (!(returnData instanceof Boolean) || ((Boolean)returnData).booleanValue()) break;
                TaxTaskServiceHelper.viewMore((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)actionId, (IFormView)this.getView());
                break;
            }
        }
    }

    protected String tabFilterKey() {
        return "taxcategory.group.id";
    }

    @Override
    protected TabPageAp[] getTabPage(FormShowParameter parameter) {
        return this.tabPageFromGroup(parameter);
    }

    @Override
    protected boolean isNeedRawData() {
        return false;
    }

    private void confirmFinishTaxTask(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object returnData) {
        BatchResult result;
        if (returnData instanceof Boolean && null == (result = TaxTaskGuideServiceHelper.validateEnd((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (IFormView)this.getView(), (IFormPlugin)this)) && (result = TaxTaskGuideServiceHelper.endData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo)).isSuccess() && CollectionUtils.isEmpty((Collection)result.getFailResult())) {
            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u7ed3\u675f\u3002", (String)"TaxTaskGuideStep3Plugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)TaxTaskGuideOpEnum.of((String)"end").loadKDString(), (String)msg);
            this.refreshTaxDataStatus(taxTaskEntity);
        }
    }

    private void confirmRollBackDeclare(MessageBoxResult confirmResult, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        SITPageCache pageCache = new SITPageCache(this.getView());
        pageCache.remove("dataOfPrevRequest");
        if (MessageBoxResult.Yes == confirmResult) {
            Long taxUnitId = (Long)pageCache.get("taxUnitId", Long.class);
            BatchResult result = TaxTaskGuideServiceHelper.validateRollbackDeclare((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (Long)taxUnitId);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u4e2d\u65e0\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep3Plugin_8", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.validateListIsExistDataAndExecute((BatchResult<DynamicObject>)result, taxTaskEntity, stepCaseInfo, msg);
        }
    }

    private void refreshTaxDataStatus(TaxTaskEntity taxTaskEntity) {
        GlobalParam.remove();
        MutexServiceHelper.release((String)"itc_taxtask", (String)String.valueOf(taxTaskEntity.getId()), (String)"calculateguide");
        BaseResult result = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskEntity.getId());
        taxTaskEntity = (TaxTaskEntity)result.getData();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        showParameter.setCustomParam("taxTaskEntity", (Object)SerializationUtils.toJsonString((Object)taxTaskEntity));
        this.getView().cacheFormShowParameter();
        this.getView().updateView();
    }

    private void validateRollbackEnd(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        if (taxTaskEntity.isEndStatus()) {
            try {
                TaxTaskGuideServiceHelper.operateTaxTask((TaxTaskEntity)taxTaskEntity, (String)YesOrNoEnum.NO.getCode());
                BatchResult result = new BatchResult(false, null).ofStatus(ResultStatusEnum.WARN.getCode()).ofMessage(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u64a4\u9500\u7ed3\u675f\u6210\u529f\u3002\u662f\u5426\u5bf9\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u7684\u6240\u6709\u4e2a\u7a0e\u8bb0\u5f55\uff0c\u7ed3\u675f\u72b6\u6001\u6807\u8bb0\u4e3a\u672a\u7ed3\u675f\uff1f", (String)"TaxTaskGuideStep3Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                this.showConfirmMsg((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.END, taxTaskEntity, stepCaseInfo);
            }
            catch (KDException e) {
                String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u64a4\u9500\u7ed3\u675f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TaxTaskGuideStep3Plugin_6", (String)"sit-itc-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                SITLogServiceHelper.addLog((IFormView)this.getView(), (String)TaxTaskGuideOpEnum.of((String)"rollbackend").loadKDString(), (String)msg);
                LOGGER.warn("update taxEndStatus  fail");
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u672a\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ed3\u675f\u3002", (String)"TaxTaskGuideStep3Plugin_7", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
    }

    private void showConfirmMsgForRollbackConfirm(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedIds = billlist.getSelectedRows();
        int count = selectedIds.size();
        boolean isSelect = false;
        String msg = "";
        if (count != 0) {
            isSelect = true;
        } else {
            count = billlist.queryBillDataCount();
            if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxDataForStep70List_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().getPageCache().put("IS_SELECT", String.valueOf(isSelect));
        this.getView().showConfirm(opEnum.confirmMsgI18n(new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
        BatchResult result = new BatchResult(false, null).ofStatus(ResultStatusEnum.WARN.getCode()).ofMessage(msg);
        this.showConfirmMsg((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.ROLLBACK_CONFIRM, taxTaskEntity, stepCaseInfo);
    }

    private void doRollbackConfirm(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        List<Object> taxDataIds;
        boolean isSelect = Boolean.parseBoolean(this.getView().getPageCache().get("IS_SELECT"));
        if (!isSelect) {
            BatchResult result = TaxTaskGuideServiceHelper.validateRollbackConfirm((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo);
            if (!result.isSuccess()) {
                this.showErrorMsg(result, opEnum);
                return;
            }
            taxDataIds = result.getSuccessResult();
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] selectIds = selectedRows.getPrimaryKeyValues();
            taxDataIds = Arrays.asList(selectIds);
        }
        TaxGuideRollbackConfirmTask taxGuideRollbackConfirmTask = new TaxGuideRollbackConfirmTask(this.getView(), taxTaskEntity, stepCaseInfo, opEnum);
        taxGuideRollbackConfirmTask.addData(500, taxDataIds);
        BatchResult executeRollbackImport = MultiThreadTaskExecutor.execute((MultiThreadTask)taxGuideRollbackConfirmTask, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
        if (!executeRollbackImport.isSuccess()) {
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)executeRollbackImport.getMessage());
            this.getView().showErrorNotification(executeRollbackImport.getMessage());
        }
    }

    private void showConfirmForRollbackDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        DynamicObject dynamicObject = TaxTaskGuideServiceHelper.queryStep4OneTaxData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, null);
        if (null == dynamicObject) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showConfirmMsgForTaxUnit(taxTaskEntity, TaxTaskGuideOpEnum.ROLLBACK_DECLARE, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64a4\u9500\u6807\u8bb0\u7533\u62a5\u7684\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxTaskGuideStep3Plugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), stepCaseInfo);
    }

    private void validateListIsExistDataAndExecute(BatchResult<DynamicObject> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String msg) {
        if (null != result) {
            int successSize = result.getSuccessResult().size();
            int failSize = result.getFailResult().size();
            if (0 == successSize && 0 == failSize) {
                this.getView().showErrorNotification(msg);
            } else if (ResultStatusEnum.WARN.getCode() == result.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u4e2d\u5b58\u5728\u5df2\u786e\u8ba4\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u6807\u8bb0\u7533\u62a5\u3002", (String)"RollbackDeclareForTaxDataList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            } else {
                result = TaxTaskGuideServiceHelper.rollbackDeclareData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, result);
                this.showResultMsgAfterOp((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.ROLLBACK_DECLARE);
            }
        }
    }

    private void validateTaxUnitIsExistTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object returnData) {
        if (returnData == null) {
            return;
        }
        Long taxUnitId = (Long)ObjectConverter.convert((Object)returnData, Long.class, (boolean)true);
        QFilter filter = new QFilter("reportoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.DECLARE.getCode());
        filter.and(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        BatchResult result = TaxTaskGuideServiceHelper.queryStep4AllTaxData((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)TaxTaskGuideOpEnum.ROLLBACK_END.getCode(), (QFilter)filter);
        String msg = ResManager.loadKDString((String)"\u6240\u9009\u7eb3\u7a0e\u5355\u4f4d\u5728\u5f53\u524d\u5217\u8868\u4e2d\u65e0\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep3Plugin_10", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.validateListIsExistDataAndExecute((BatchResult<DynamicObject>)result, taxTaskEntity, stepCaseInfo, msg);
    }
}

