/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxDataForStepAllList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStepAllList.class);
    protected static final String[] FORBIDDEN_OP_BTN_AFTER_TASK_END = new String[]{TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK.getBtnFlag(), TaxTaskGuideOpEnum.EXPORT_REPORT.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT.getBtnFlag(), TaxTaskGuideOpEnum.LOCK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK.getBtnFlag(), TaxTaskGuideOpEnum.IMPORT.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_IMPORT.getBtnFlag(), TaxTaskGuideOpEnum.FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.DECLARE.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getBtnFlag(), TaxTaskGuideOpEnum.END.getBtnFlag(), "btn_rollbackrefersalary", "btn_rollbacklock", TaxTaskGuideOpEnum.CONFIRM.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_CONFIRM.getBtnFlag()};
    protected static final Set<TaxTaskGuideOpEnum> FORBIDDEN_OP_AFTER_TASK_END = new HashSet<TaxTaskGuideOpEnum>(Arrays.asList(TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK, TaxTaskGuideOpEnum.EXPORT_REPORT, TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT, TaxTaskGuideOpEnum.LOCK, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK, TaxTaskGuideOpEnum.IMPORT, TaxTaskGuideOpEnum.ROLLBACK_IMPORT, TaxTaskGuideOpEnum.FEEDBACK, TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK, TaxTaskGuideOpEnum.DECLARE, TaxTaskGuideOpEnum.ROLLBACK_DECLARE, TaxTaskGuideOpEnum.END, TaxTaskGuideOpEnum.CONFIRM, TaxTaskGuideOpEnum.ROLLBACK_CONFIRM));
    protected static final String[] FORBIDDEN_OP_AFTER_MUTEX_LOCK = new String[]{TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA.getBtnFlag(), TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK.getBtnFlag(), TaxTaskGuideOpEnum.EXPORT_REPORT.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT.getBtnFlag(), TaxTaskGuideOpEnum.LOCK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_TASK.getBtnFlag(), TaxTaskGuideOpEnum.IMPORT.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_IMPORT.getBtnFlag(), TaxTaskGuideOpEnum.FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getBtnFlag(), TaxTaskGuideOpEnum.DECLARE.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getBtnFlag(), TaxTaskGuideOpEnum.END.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_END.getBtnFlag(), "btn_more1", "btn_more2", "btn_more3", "btn_refresh1", "btn_refresh2", "btn_refresh3", "btn_exportbylist1", "btn_exportbylist2", "btn_exportbylist3", "btn_showexportresult1", "btn_showexportresult2", "btn_showexportresult3", "btn_rollbackrefersalary", TaxTaskGuideOpEnum.CONFIRM.getBtnFlag(), TaxTaskGuideOpEnum.ROLLBACK_CONFIRM.getBtnFlag()};

    public void initialize() {
        super.initialize();
        GlobalParam.remove();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taxTaskId");
        if (ObjectUtils.isEmpty((Object)taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u64cd\u4f5c\u4efb\u52a1", (String)"TaxDataForStepAllList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        BaseResult taxTaskRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taskId);
        if (!taxTaskRes.isSuccess()) {
            this.getView().showTipNotification(taxTaskRes.getMessage());
            this.getView().close();
            return;
        }
        TaxTaskEntity taxTask = (TaxTaskEntity)taxTaskRes.getData();
        parameter.setCustomParam("taxTaskEntity", (Object)SerializationUtils.toJsonString((Object)taxTask));
        this.getView().cacheFormShowParameter();
        if (taxTask.isEnd()) {
            this.getView().setEnable(Boolean.FALSE, FORBIDDEN_OP_BTN_AFTER_TASK_END);
        } else {
            this.getView().setEnable(Boolean.TRUE, FORBIDDEN_OP_BTN_AFTER_TASK_END);
        }
        Boolean hasLock = (Boolean)parameter.getCustomParam("hasLock");
        if (hasLock == null || !hasLock.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, FORBIDDEN_OP_AFTER_MUTEX_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            String cacheKey;
            GlobalParam.remove();
            FormOperate operate = (FormOperate)args.getSource();
            TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)operate.getOperateKey());
            if (opEnum == null) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u88ab\u7cfb\u7edf\u652f\u6301\u3002", (String)"TaxDataForStepAllList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
            if (!taxTaskEntityRes.isSuccess()) {
                args.setCancel(true);
                this.getView().showErrorNotification(taxTaskEntityRes.getMessage());
                return;
            }
            IAppCache appCache = AppCache.get((String)"sitcs");
            String changed = (String)appCache.get(cacheKey = "TASK_CHANGED_" + ((TaxTaskEntity)taxTaskEntityRes.getData()).getId(), String.class);
            if (YesOrNoEnum.isYes((String)changed)) {
                appCache.remove(cacheKey);
                this.getView().invokeOperation("refresh");
            }
            if (((TaxTaskEntity)taxTaskEntityRes.getData()).isEnd() && FORBIDDEN_OP_AFTER_TASK_END.contains(opEnum)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u7ed3\u675f\u540e\u4e0d\u5141\u8bb8\u8fdb\u884c{0}\u64cd\u4f5c", (String)"TaxTaskGuidePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString()}));
                return;
            }
            BatchResult<DynamicObject> result = this.commonValidate((TaxTaskEntity)taxTaskEntityRes.getData(), opEnum);
            if (!result.isSuccess()) {
                args.setCancel(true);
                this.getView().showErrorNotification(taxTaskEntityRes.getMessage());
            }
        }
        finally {
            GlobalParam.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        try {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            PageCache pageCache = new PageCache(this.getView().getPageId());
            switch (operateKey) {
                case "afterprocessclose": {
                    this.getView().invokeOperation("refresh");
                    TaxTaskGuideCacheData from = (TaxTaskGuideCacheData)SerializationUtils.fromJsonString((String)pageCache.get("dataOfPrevRequest"), TaxTaskGuideCacheData.class);
                    this.showResultMsgAfterOp(from);
                    return;
                }
                case "showexportresult": {
                    this.showExportResult();
                    return;
                }
                case "clearcache": {
                    Long taxTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("taxTaskId");
                    TaxTaskServiceHelper.clearCache((Long)taxTaskId);
                    return;
                }
            }
            return;
        }
        finally {
            GlobalParam.remove();
        }
    }

    private TaxTaskGuideStepCaseInfo stepCaseInfo(TaxTaskEntity taskEntity) {
        return TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taskEntity);
    }

    private void showExportResult() {
        BaseResult taxTaskRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskRes.isSuccess()) {
            this.getView().showErrorNotification(taxTaskRes.getMessage());
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bos_exportlog");
        param.setFormId("bos_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("bizobject", "=", (Object)("itc_taxdata" + ((TaxTaskEntity)taxTaskRes.getData()).getId())));
        param.getListFilterParameter().setFilter(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()));
        this.getView().showForm((FormShowParameter)param);
    }

    protected BatchResult<DynamicObject> commonValidate(TaxTaskEntity taxTaskEntity, TaxTaskGuideOpEnum opEnum) {
        if (!taxTaskEntity.isAvailable()) {
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u4e8e\u4e0d\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxTaskGuideStepsPlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        if (taxTaskEntity.isEnd() && Arrays.asList(FORBIDDEN_OP_BTN_AFTER_TASK_END).contains(opEnum.getCode())) {
            String opName = opEnum.loadKDString();
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u7ed3\u675f\u540e\u4e0d\u5141\u8bb8\u6267\u884c{0}\u64cd\u4f5c\u3002", (String)"TaxTaskGuideStepsPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[]{opName}));
        }
        return new BatchResult(true, null);
    }

    public void showResultMsgAfterOp(TaxTaskGuideCacheData taskGuideCacheData) {
        String title;
        if (taskGuideCacheData == null) {
            return;
        }
        String opName = taskGuideCacheData.getOpName();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)opName);
        if (TaxTaskGuideOpEnum.EXPORT_REPORT == opEnum) {
            return;
        }
        if (!taskGuideCacheData.isToContinue()) {
            this.showErrorMsg(taskGuideCacheData.getFatalMsg(), opEnum);
            return;
        }
        int successSize = 0;
        int failSize = 0;
        Map statusIdMap = taskGuideCacheData.getStatusIdMap();
        for (Map.Entry entry : statusIdMap.entrySet()) {
            if ((Integer)entry.getKey() >= ResultStatusEnum.ERROR.getCode()) {
                failSize += ((List)entry.getValue()).size();
                continue;
            }
            successSize += ((List)entry.getValue()).size();
        }
        int totalSize = successSize + failSize;
        Map idMsgMap = taskGuideCacheData.getIdMsgMap();
        if (CollectionUtils.isEmpty((Map)idMsgMap)) {
            String msg = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{1}\u6761\u3002", (String)"TaxTaskGuideStep1Plugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), totalSize});
            this.getView().showSuccessNotification(msg);
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)msg);
            return;
        }
        if (TaxTaskGuideOpEnum.DECLARE == opEnum) {
            title = ResManager.loadKDString((String)"{0}\u5931\u8d25\uff0c{1}\u6761\u8bb0\u5f55\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a", (String)"TaxTaskGuideStep1Plugin_10", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), failSize});
        } else {
            title = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TaxTaskGuideStep1Plugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), totalSize, successSize, failSize});
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)title);
        }
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)opEnum.loadKDString(), (String)title, new ArrayList(idMsgMap.values()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "AfterOp" + opEnum.getCode()));
        this.getView().showForm(parameter);
    }

    protected void showErrorMsg(String message, TaxTaskGuideOpEnum opEnum) {
        this.getView().showTipNotification(message);
    }
}

