/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewFilter;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaxTaskGuideDownLoadTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.model.TaxDataGuideBillList;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxGroupEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.TaxUnitEntity;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.SitEntityTypeBillList;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.formplugin.web.AbstractTabListPlugin;

public abstract class TaxDataForStepsList
extends AbstractTabListPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxDataForStepsList.class);
    private SitEntityTypeBillList billList;
    private ListGridView gridView;
    protected static final String MUTEX_LOCK_OP_KEY = "calculateguide";
    protected static final String SUCCESS_DATA = "successData";
    protected static final String CLOSE_CALLBACK_ACT_ID_SPLIT = ":";
    protected static final String CLOSE_CALLBACK_PREFIX_SELECT = "selectSrcData";
    protected static final String CLOSE_CALLBACK_PREFIX_CAT_TASK = "selectCalTask:";
    protected static final String CLOSE_CALLBACK_PREFIX_CONFIRM = "confirm";
    protected static final int CLOSE_CALLBACK_ITEM_PARTS = 2;
    protected static final String CLOSE_CALLBACK_TAXTEMPLATE = "taxTemplateCallback";
    protected static final String CLOSE_CALLBACK_TAXIMPORTING = "taxImportCallback";
    protected static final String CLOSE_CALLBACK_PREFIX_TAX_UNIT = "selectTaxUnit:";
    protected static final String CLOSE_CALLBACK_PREPARE_PERSONDECLARE = "prepareAndPersonDeclareConfirm";

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if ("billlistap".equals(key)) {
            customControl = this.createBillList(key);
        } else if ("gridview".equals(key)) {
            customControl = this.createListGridView(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.extEntityType(null));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Set<String> hiddenKeys;
        IListColumn customSeq;
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            String key;
            IListColumn column = (IListColumn)listColumns.get(i);
            if (!(column instanceof DynamicTextListColumn) || !(key = ((DynamicTextListColumn)column).getKey()).startsWith("csfd_")) continue;
            key = key.substring(5);
            ListColumn newColumn = new ListColumn();
            newColumn.setKey(key);
            newColumn.setListFieldKey(key);
            newColumn.setCaption(column.getCaption());
            listColumns.set(i, newColumn);
        }
        Map<String, IListColumn> collect = listColumns.stream().collect(Collectors.toMap(IListColumnConfig::getListFieldKey, e1 -> e1, (k1, k2) -> k1));
        IListColumn srcRefNum = collect.get("srcrefnum");
        if (srcRefNum != null) {
            srcRefNum.setFixed(true);
        }
        if ((customSeq = collect.get("customseq")) != null) {
            customSeq.setFixed(true);
        }
        if ((hiddenKeys = this.hiddenColumns()) != null && !hiddenKeys.isEmpty()) {
            for (String hiddenKey : hiddenKeys) {
                IListColumn column = collect.get(hiddenKey);
                if (column == null) continue;
                column.setVisible(0);
            }
        }
        List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
        for (TaxItemEntity taxItem : taxItemEntities) {
            ListColumn column;
            if (taxItem.isIncomeItem()) continue;
            Long itemId = taxItem.getId();
            String key = "it_" + itemId;
            if (collect.containsKey(key) || SITBaseConstants.INCOME_ITEM_1.equals(taxItem.getId()) || SITBaseConstants.INCOME_ITEM_2.equals(taxItem.getId())) continue;
            if (SitDataTypeEnum.isDecimal((long)taxItem.getDatatypeId())) {
                DecimalListColumn temp = new DecimalListColumn();
                temp.setDisplayFormatString(taxItem.formatString());
                temp.setZeroShow(true);
                temp.setTextAlign("right");
                column = temp;
            } else {
                column = new ListColumn();
            }
            column.setCaption(LocaleString.fromMap((Map)taxItem.getName()));
            column.setColumnOrder(false);
            column.setColumnFilter(false);
            column.setKey(key);
            column.setListFieldKey(key);
            listColumns.add(column);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        TaxTaskGuideOpEnum.convertFilters((List)qFilters);
        super.setFilter(setFilterEvent);
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        TaxTaskGuideViewFilter.setPersonFilter((List)qFilters, (Long)taxTaskId);
        TaxTaskGuideViewFilter.setTaxFileFilter((List)qFilters, (String)"itc_taxdatabasic", (long)taxTaskId);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        TaxTaskGuideViewFilter.setSchemeFilter((FilterContainerSearchClickArgs)args, (Long)taxTaskId);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IFormView parentView = this.getView().getParentView();
        parentView.close();
        this.getView().sendFormAction(parentView);
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }

    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        GlobalParam.remove();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaxTaskGuideDataProviderImpl());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        Long taxDataId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        if ("srcrefnum".equals(fieldName)) {
            this.collapse(taxDataId);
            args.setCancel(true);
        } else if ("taxfile_number".equals(fieldName)) {
            DynamicObject taxFile;
            DynamicObject taxData;
            QFilter idFilter;
            if (taxDataId > 0L) {
                idFilter = new QFilter("id", "=", (Object)taxDataId);
                taxData = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdata"), (QFilter[])new QFilter[]{idFilter});
                taxFile = taxData.getDynamicObject("taxFile");
            } else {
                idFilter = new QFilter("id", "=", (Object)(-taxDataId.longValue()));
                DynamicObject object = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxrawdata"), (QFilter[])new QFilter[]{idFilter});
                Long id = object.getLong("taxdata");
                idFilter = new QFilter("id", "=", (Object)id);
                taxData = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdata"), (QFilter[])new QFilter[]{idFilter});
                taxFile = object.getDynamicObject("taxFile");
            }
            if (null != taxData) {
                SITPageCache pageCache = new SITPageCache(this.getView());
                pageCache.put("taxDataBasicForOpenTaxFile" + taxFile.getLong("id"), (Object)taxData.getLong("taxdatabasic.id"));
            }
            TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.READ_ONLY, (IFormView)this.getView(), (long)0L);
            args.setCancel(true);
        }
    }

    protected Object tabFilterValue(String tabKey) {
        return Long.parseLong(tabKey.substring(2));
    }

    protected void tabFilterChanged(TabSelectEvent tabSelectEvent) {
        GlobalParam.set((String)"AbstractTabListPlugin_KEY", (Object)tabSelectEvent.getTabKey());
        this.createBillList("billlistap");
    }

    protected TabPageAp[] getTabPage(FormShowParameter parameter) {
        if (this.tabByGroup()) {
            return this.tabPageFromGroup(parameter);
        }
        return this.tabPageFromCat(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                TabAp tabAp = this.createTab(parameter);
                this.getView().updateControlMetadata(tabAp.getKey(), tabAp.createControl());
                break;
            }
            case "exportbylist": {
                this.exportByList();
            }
        }
    }

    protected boolean tabByGroup() {
        return true;
    }

    private void exportByList() {
        BaseResult taxTaskEntityRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskEntityRes.isSuccess()) {
            this.getView().showTipNotification(taxTaskEntityRes.getMessage());
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int total = CollectionUtils.isEmpty((Collection)selectedRows) ? billList.queryBillDataCount() : selectedRows.size();
        if (total == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxTaskGuidePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        TaxTaskGuideDownLoadTask task = new TaxTaskGuideDownLoadTask((TaxTaskEntity)taxTaskEntityRes.getData(), billList, this.stepCaseInfo((TaxTaskEntity)taxTaskEntityRes.getData()));
        task.setHandleCase(MultiThreadCase.BY_ACTION);
        if (!this.isNeedRawData()) {
            task.excludeSrcData();
        }
        String dataKey = ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"TaxTaskGuidePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        task.addData(dataKey, total, 500, 1).ofKey(RequestContext.get().getTraceId());
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.getView().showErrorNotification(execute.getMessage());
        }
    }

    protected TaxTaskGuideStepCaseInfo stepCaseInfo(TaxTaskEntity taskEntity) {
        return TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)taskEntity);
    }

    protected Set<String> hiddenColumns() {
        return null;
    }

    protected void collapse() {
    }

    protected void collapse(Long taxDataId) {
        HRPageCache pageCache = new HRPageCache(this.getView());
        Set collapseId = (Set)pageCache.get("collapseId", Set.class);
        if (collapseId == null) {
            collapseId = Sets.newHashSet((Object[])new Long[]{taxDataId});
        } else if (!collapseId.remove(taxDataId)) {
            collapseId.add(taxDataId);
        }
        pageCache.put("collapseId", (Object)collapseId);
        ((BillList)this.getControl("billlistap")).refreshData();
    }

    protected TabPageAp[] tabPageFromGroup(FormShowParameter parameter) {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        BaseResult taxTaskRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taxTaskRes.isSuccess()) {
            return new TabPageAp[0];
        }
        return this.tabPageFromGroup((TaxTaskEntity)taxTaskRes.getData());
    }

    protected TabPageAp[] tabPageFromCat(FormShowParameter parameter) {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        BaseResult taxTaskRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taxTaskRes.isSuccess()) {
            return new TabPageAp[0];
        }
        return this.tabPageFromCat((TaxTaskEntity)taxTaskRes.getData());
    }

    protected TabPageAp[] tabPageFromGroup(TaxTaskEntity taxTask) {
        List taxGroups = TaxTaskServiceHelper.loadTaxGroups((TaxTaskEntity)taxTask);
        if (CollectionUtils.isEmpty((Collection)taxGroups)) {
            return new TabPageAp[0];
        }
        TabPageAp[] result = new TabPageAp[taxGroups.size()];
        for (int i = 0; i < taxGroups.size(); ++i) {
            TaxGroupEntity group = (TaxGroupEntity)taxGroups.get(i);
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("gp" + group.getId());
            tabPageAp.setName(group.getNameLocaleString());
            tabPageAp.setBackColor("#ffffff");
            result[i] = tabPageAp;
        }
        return result;
    }

    protected TabPageAp[] tabPageFromCat(TaxTaskEntity taxTask) {
        List categoryEntities = taxTask.getTaxCategoryEntityList();
        if (CollectionUtils.isEmpty((Collection)categoryEntities)) {
            return new TabPageAp[0];
        }
        TabPageAp[] result = new TabPageAp[categoryEntities.size()];
        for (int i = 0; i < categoryEntities.size(); ++i) {
            TaxCategoryEntity cat = (TaxCategoryEntity)categoryEntities.get(i);
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("ct" + cat.getId());
            tabPageAp.setName(cat.getNameLocaleString());
            tabPageAp.setBackColor("#ffffff");
            result[i] = tabPageAp;
        }
        return result;
    }

    protected MainEntityType extEntityType(MainEntityType extTypeTaxData) {
        try {
            if (extTypeTaxData == null) {
                extTypeTaxData = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxdata").clone();
            }
            List<TaxItemEntity> taxItemEntities = this.taxItemEntities();
            for (TaxItemEntity taxItemEntity : taxItemEntities) {
                String prop = "it_" + taxItemEntity.getId();
                if (extTypeTaxData.getProperties().containsKey((Object)prop)) continue;
                TextProp property = new TextProp();
                property.setName(prop);
                extTypeTaxData.addProperty((DynamicProperty)property);
            }
            extTypeTaxData.createPropIndexs();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u9875\u9762\u5b9e\u4f53\u6269\u5c55\u5931\u8d25", (String)"TaxPrepareDataList_1", (String)"sit-itc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return extTypeTaxData;
    }

    protected List<TaxItemEntity> taxItemEntities() {
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
        BaseResult taxTaskRes = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taxTaskRes.isSuccess()) {
            return new ArrayList<TaxItemEntity>(0);
        }
        TaxTaskEntity taxTask = (TaxTaskEntity)taxTaskRes.getData();
        String currentTab = (String)GlobalParam.get((String)"AbstractTabListPlugin_KEY");
        if (StringUtils.isEmpty((String)currentTab)) {
            currentTab = this.currentTab();
        }
        Object tableFilterValue = this.tabFilterValue(currentTab);
        String type = currentTab.substring(0, 2);
        if ("gp".equals(type)) {
            return taxTask.getTaxItemOfGroup((Long)tableFilterValue);
        }
        if ("ct".equals(type)) {
            return taxTask.getTaxItemOfCat((Long)tableFilterValue);
        }
        throw new KDBizException("type not supported");
    }

    private BillList createBillList(String key) {
        if (this.billList == null) {
            this.billList = new TaxDataGuideBillList((EntityType)this.extEntityType(null));
        } else {
            this.extEntityType((MainEntityType)this.billList.getEntityType());
        }
        this.billList.setKey(key);
        this.billList.setEntityId("itc_taxdata");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private BillList createListGridView(String key) {
        if (this.gridView == null) {
            this.gridView = new ListGridView();
            this.gridView.setParent((BillList)this.billList);
        }
        this.gridView.setKey(key);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.gridView);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    protected String propNameOfTaxValue() {
        return "itemvalue";
    }

    protected boolean isNeedRawData() {
        return true;
    }

    private Set<String> addItemProps(DynamicObjectType mainType, Set<String> listFields) {
        List<TaxItemEntity> taxItems = this.taxItemEntities();
        DataEntityPropertyCollection properties = mainType.getProperties();
        for (String listField : listFields) {
            if (properties.containsKey((Object)listField)) continue;
            TextProp property = new TextProp();
            property.setName(listField);
            mainType.addProperty((DynamicProperty)property);
        }
        HashSet<String> result = new HashSet<String>(taxItems.size());
        for (TaxItemEntity taxItem : taxItems) {
            String number = "it_" + taxItem.getId();
            result.add(taxItem.getId() + "");
            if (properties.containsKey((Object)number)) continue;
            TextProp property = new TextProp();
            property.setName(number);
            mainType.addProperty((DynamicProperty)property);
        }
        return result;
    }

    protected void cacheDataBeforeFrontConfirmRef(TaxTaskGuideOpEnum opEnum, BatchResult<DynamicObject> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        SITPageCache pageCache = new SITPageCache(this.getView());
        TaxTaskGuideCacheData from = TaxTaskGuideCacheData.from(result, (TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (TaxTaskGuideOpEnum)opEnum);
        pageCache.put("dataOfPrevRequest", (Object)from);
    }

    protected void cacheDataBeforeFrontConfirmRefV1(TaxTaskGuideOpEnum opEnum, BatchResult<Long> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        SITPageCache pageCache = new SITPageCache(this.getView());
        TaxTaskGuideCacheData from = TaxTaskGuideCacheData.fromV1(result, (TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo, (TaxTaskGuideOpEnum)opEnum);
        pageCache.put("dataOfPrevRequest", (Object)from);
    }

    protected TaxTaskGuideCacheData recoverRefDataFromCache(TaxTaskGuideOpEnum opEnum) {
        SITPageCache pageCache = new SITPageCache(this.getView());
        TaxTaskGuideCacheData from = (TaxTaskGuideCacheData)pageCache.get("dataOfPrevRequest", TaxTaskGuideCacheData.class);
        if (from == null) {
            return null;
        }
        TaxTaskGuideServiceHelper.recoverDataFromDb((TaxTaskGuideCacheData)from, (TaxTaskGuideOpEnum)opEnum, (ListSelectedRowCollection)((BillList)this.getControl("billlistap")).getSelectedRows());
        return from;
    }

    protected void showConfirmMsgV1(BatchResult<Long> result, TaxTaskGuideOpEnum opEnum, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.cacheDataBeforeFrontConfirmRefV1(opEnum, result, taxTaskEntity, stepCaseInfo);
        String message = opEnum.confirmMsgI18n(new Object[0]);
        if (TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON == opEnum) {
            TaxGroupEntity grp = taxTaskEntity.getTaxGroup(stepCaseInfo.getTabValue());
            LocaleString grpName = grp.getNameLocaleString();
            message = MessageFormat.format(message, grpName);
        }
        if (ResultStatusEnum.WARN.getCode() == result.getStatus()) {
            message = result.getMessage();
        }
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
    }

    protected void showConfirmMsg(BatchResult<DynamicObject> result, TaxTaskGuideOpEnum opEnum, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.cacheDataBeforeFrontConfirmRef(opEnum, result, taxTaskEntity, stepCaseInfo);
        String message = opEnum.confirmMsgI18n(new Object[0]);
        if (ResultStatusEnum.WARN.getCode() == result.getStatus()) {
            message = result.getMessage();
        }
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
    }

    protected void showResultMsgAfterOp(BatchResult<DynamicObject> result, TaxTaskGuideOpEnum opEnum) {
        int failSize;
        if (!result.isSuccess()) {
            this.showErrorMsg(result, opEnum);
            return;
        }
        this.getView().invokeOperation("refresh");
        List failResult = result.getFailResultOriginal();
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)failResult)) {
            String msg = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{1}\u6761\u3002", (String)"TaxTaskGuideStep1Plugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), successResult.size()});
            this.getView().showSuccessNotification(msg);
            SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)msg);
            return;
        }
        int successSize = successResult.size();
        int failSizeOld = failSize = failResult.size();
        int totalSize = failSize + successSize;
        Map status = result.failDataGroupByStatus();
        for (Map.Entry entry : status.entrySet()) {
            if ((Integer)entry.getKey() >= ResultStatusEnum.ERROR.getCode()) continue;
            int size = ((List)entry.getValue()).size();
            failSize -= size;
            successSize += size;
        }
        String title = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TaxTaskGuideStep1Plugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), totalSize, successSize, failSize});
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)title);
        ArrayList<String> allMsg = new ArrayList<String>(failSizeOld);
        for (int i = 0; i < failSizeOld; ++i) {
            String message = ((ResultItem)failResult.get(i)).getMessage();
            DynamicObject data = (DynamicObject)((ResultItem)failResult.get(i)).getData();
            allMsg.add(opEnum.resultLoadKDString(message, new Object[]{data.get("taxfile.number"), data.get("taxfile.person.name")}));
        }
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)opEnum.loadKDString(), (String)title, allMsg);
        if (TaxTaskGuideOpEnum.END == opEnum) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TaxTaskGuideOpEnum.END.getBtnFlag()));
        }
        this.getView().showForm(parameter);
    }

    protected void showErrorMsg(BatchResult<?> result, TaxTaskGuideOpEnum opEnum) {
        this.getView().showTipNotification(result.getMessage());
    }

    protected void showFormOfDataSrcSelectOld(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ITC_TAXRAWDATAf7");
        Long tabValue = stepCaseInfo.getTabValue();
        parameter.setCustomParam("categoryId", (Object)tabValue);
        parameter.setCustomParam("taxpayerTypeId", (Object)taxTaskEntity.getTaxCategory(tabValue).getTaxpayerTypeId());
        parameter.setCustomParam("countryId", (Object)taxTaskEntity.getCountryId());
        parameter.setCustomParam("taxTaskId", (Object)taxTaskEntity.getId());
        parameter.setCustomParam("taxUnitIds", (Object)taxTaskEntity.taxUnitIds());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CALLBACK_PREFIX_SELECT);
        parameter.setCloseCallBack(cb);
        this.getView().showForm(parameter);
    }

    protected void showFormOfDataSrcSelect(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("itc_taxrawdata");
        Long tabValue = stepCaseInfo.getTabValue();
        parameter.setCustomParam("taxCategoryId", (Object)tabValue);
        parameter.setCustomParam("taxTaskId", (Object)taxTaskEntity.getId());
        List filters = parameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("taxcategory.id", "=", (Object)tabValue));
        filters.add(new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId()));
        filters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
        filters.add(new QFilter("status", "!=", (Object)"E"));
        if (taxTaskEntity.isLocalCal()) {
            filters.add(new QFilter("taxdatabasic.calstatus", "=", (Object)YesOrNoEnum.YES.getCode()));
        }
        filters.add(new QFilter("taxdatabasic.status", "!=", (Object)"E"));
        filters.add(new QFilter("bizstatus", ">=", (Object)TaxDataBizStatusEnum.TO_DEL.getCode()));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CALLBACK_PREFIX_SELECT);
        parameter.setCloseCallBack(cb);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showFormOfCalTaskSelect(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        FormShowParameter parameter = new FormShowParameter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.queryBillDataCount() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TaxTaskGuideStepsPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            LOGGER.info("WYF_billList----size---0----");
            return;
        }
        if (TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK == opEnum) {
            parameter.setFormId("itc_selectrawcaltask_rf");
        } else {
            parameter.setFormId("itc_selectrawcaltask");
        }
        List ids = TaxTaskServiceHelper.loadRawCalTaskIds((TaxTaskEntity)taxTaskEntity, (TaxTaskGuideStepCaseInfo)stepCaseInfo);
        parameter.setCustomParam("rawCalTaskIds", (Object)ids);
        parameter.setCustomParam("opEnum", (Object)opEnum.name());
        if ("ROLLBACK_LOCK_BY_TASK".equals(opEnum.name())) {
            parameter.setCaption(ResManager.loadKDString((String)"\u64a4\u9500\u9501\u5b9a\u64cd\u4f5c\u786e\u8ba4", (String)"RawCalTaskForTaxGuidePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CALLBACK_PREFIX_CAT_TASK + opEnum.name());
        parameter.setCloseCallBack(cb);
        this.getView().showForm(parameter);
    }

    protected void showFormOfTaxUnitSelect(Map<Long, String> taxUnitMap, TaxTaskGuideOpEnum opEnum, String description) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("itc_selecttaxunit");
        parameter.setCustomParam("description", (Object)description);
        String json = SerializationUtils.toJsonString(taxUnitMap);
        parameter.setCustomParam("taxUnitMap", (Object)json);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CALLBACK_PREFIX_TAX_UNIT + opEnum.name());
        parameter.setCloseCallBack(cb);
        this.getView().showForm(parameter);
    }

    protected void showConfirmMsgForTaxUnit(TaxTaskEntity taxTaskEntity, TaxTaskGuideOpEnum opEnum, String msg, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        Map<Long, String> taxUnitMap = this.getTaxUnit(taxTaskEntity, stepCaseInfo, opEnum);
        if (null != taxUnitMap && taxUnitMap.size() > 1) {
            this.showFormOfTaxUnitSelect(taxUnitMap, opEnum, msg);
            return;
        }
        if (null == taxUnitMap || taxUnitMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            LOGGER.info("WYF_taxUnit----size---0----");
            return;
        }
        Long taxUnitId = null;
        for (Map.Entry<Long, String> entry : taxUnitMap.entrySet()) {
            taxUnitId = entry.getKey();
        }
        SITPageCache pageCache = new SITPageCache(this.getView());
        pageCache.put("taxUnitId", (Object)taxUnitId);
        this.getView().showConfirm(opEnum.confirmMsgI18n(new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + opEnum.getCode(), (IFormPlugin)this));
        BatchResult result = new BatchResult(false, null).ofStatus(ResultStatusEnum.WARN.getCode()).ofMessage(msg);
        this.showConfirmMsg((BatchResult<DynamicObject>)result, TaxTaskGuideOpEnum.ROLLBACK_END, taxTaskEntity, stepCaseInfo);
    }

    private Map<Long, String> getTaxUnit(TaxTaskEntity taxTask, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        Set permItem;
        Long[] ids = taxTask.taxUnitIds();
        Map taxUnitMap = taxTask.getTaxUnitMap();
        HashMap map = new HashMap(ids.length);
        if (TaxTaskGuideOpEnum.ROLLBACK_DECLARE == opEnum) {
            for (Long id : ids) {
                TaxUnitEntity taxUnit = (TaxUnitEntity)taxUnitMap.get(id);
                String extraProp = taxUnit.getDeclareStatus();
                int taxFileNum = taxUnit.getTaxFileNum();
                if (taxFileNum <= 0 || !YesOrNoEnum.YES.getCode().equals(extraProp)) continue;
                map.put(id, taxUnit.localName());
            }
        } else {
            for (Long id : ids) {
                TaxUnitEntity taxUnit = (TaxUnitEntity)taxUnitMap.get(id);
                String extraProp = taxUnit.getDeclareStatus();
                LOGGER.info("-----WYF______extraProp--{}", (Object)extraProp);
                int taxFileNum = taxUnit.getTaxFileNum();
                if (taxFileNum <= 0 || YesOrNoEnum.YES.getCode().equals(extraProp)) continue;
                String taxUnitName = taxUnit.localName();
                map.put(id, taxUnitName);
                LOGGER.info("-----WYF______taxUnit--{}", (Object)taxUnitName);
            }
            if (TaxTaskGuideOpEnum.ROLLBACK_IMPORT == opEnum) {
                Set taxUnitId = TaxTaskGuideServiceHelper.getTaxUnitMapForRollImport((TaxTaskEntity)taxTask, (TaxTaskGuideStepCaseInfo)stepCaseInfo);
                if (null == taxUnitId || CollectionUtils.isEmpty(map)) {
                    return null;
                }
                HashMap newMap = Maps.newHashMapWithExpectedSize((int)map.size());
                for (Map.Entry entry : map.entrySet()) {
                    if (!taxUnitId.contains(entry.getKey())) continue;
                    newMap.put(entry.getKey(), entry.getValue());
                }
                map = newMap;
                LOGGER.info("-----newMap--{}", (Object)newMap.size());
            }
        }
        if (!SITPermissionServiceHelper.isSuperUser() && (permItem = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxdata", (String)"47150e89000000ac")) != null) {
            map.keySet().retainAll(permItem);
            LOGGER.info("-----WYF______no taxunit permission");
        }
        return map;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "taxfile.number": {
                List numberFilters = args.getQfilters();
                TaxTaskGuideViewFilter.addOrgFilterForTaxFile((List)numberFilters);
                break;
            }
        }
    }

    private class TaxTaskGuideDataProviderImpl
    extends ListDataProvider {
        private TaxTaskGuideDataProviderImpl() {
        }

        public String getOrderByExpr() {
            String order = super.getOrderByExpr();
            if (StringUtils.isEmpty((String)order) || "id".equals(order)) {
                return "taxfile.taxunit.id asc, id desc";
            }
            return order;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            Map<Object, Object> groupByTaxData;
            DynamicObject[] query;
            TaxTaskGuideViewHelper.cacheFilterAndOrderBy((ListDataProvider)this, (IPageCache)TaxDataForStepsList.this.getView().getPageCache());
            DynamicObjectCollection data = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            List listFields = this.getListFields();
            DynamicObjectType objectType = data.getDynamicObjectType();
            LinkedHashSet keySet = Sets.newLinkedHashSetWithExpectedSize((int)listFields.size());
            StringBuilder fields = new StringBuilder("id,taxdata,entryentity.taxitem,entryentity.");
            fields.append(TaxDataForStepsList.this.propNameOfTaxValue());
            boolean formPrivate = true;
            for (ListField e12 : listFields) {
                String listFieldKey = e12.getListFieldKey();
                if (formPrivate && ("taxcategory".equals(listFieldKey) || listFieldKey.startsWith("taxcategory."))) {
                    formPrivate = false;
                }
                if (listFieldKey.startsWith("csfd_")) {
                    listFieldKey = listFieldKey.substring(5);
                }
                keySet.add(listFieldKey);
                if (listFieldKey.startsWith("it_") || listFieldKey.equals("fseq") || listFieldKey.startsWith("itc_taxdata")) continue;
                fields.append(',').append(e12);
            }
            if (formPrivate) {
                return data;
            }
            Set itemProps = TaxDataForStepsList.this.addItemProps(objectType, keySet);
            Map<Long, DynamicObject> dataMap = data.stream().collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1, (k1, k2) -> k1));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
            for (DynamicObject object : query = serviceHelper.query("id,taxunit,taxunit.name,taxunit.admindivision.name,taxfile.taxunit,entryentity.taxitem,entryentity." + TaxDataForStepsList.this.propNameOfTaxValue(), new QFilter[]{new QFilter("id", "in", dataMap.keySet())})) {
                DynamicObject object1 = dataMap.get(object.getLong("id"));
                if (keySet.contains("taxunit.name")) {
                    object1.set("taxunit", object.get("taxunit"));
                    object1.set("taxunit.name", object.get("taxunit.name"));
                }
                if (keySet.contains("taxunit.admindivision.name")) {
                    object1.set("taxunit.admindivision.name", object.get("taxunit.admindivision.name"));
                }
                DynamicObjectCollection entry = object.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entry) {
                    String itemId = dynamicObject.getString("taxitem.id");
                    if (!itemProps.contains(itemId)) continue;
                    object1.set("it_" + itemId, (Object)dynamicObject.getString(TaxDataForStepsList.this.propNameOfTaxValue()));
                }
            }
            Long taxTaskId = (Long)BaseDataConverter.convert((Object)TaxDataForStepsList.this.getView().getFormShowParameter().getCustomParam("taxTaskId"), Long.class);
            TaxTaskEntity taxTaskRes = (TaxTaskEntity)TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId).getData();
            HRBaseServiceHelper rawServiceHelper = new HRBaseServiceHelper("itc_taxrawdata");
            if (TaxDataForStepsList.this.isNeedRawData()) {
                QFilter yearMonthFilter = taxTaskRes != null ? new QFilter("yearmonth", "=", (Object)taxTaskRes.yearMonth()) : new QFilter("1", "=", (Object)1);
                DynamicObject[] rawQuery = rawServiceHelper.query(fields.toString(), new QFilter[]{yearMonthFilter, new QFilter("taxdata", "in", dataMap.keySet()), new QFilter("bizstatus", ">=", (Object)TaxDataBizStatusEnum.TO_DEL.getCode()), new QFilter("taxdatabasic.status", "!=", (Object)"E"), new QFilter("status", "!=", (Object)"E")}, "id asc");
                groupByTaxData = Arrays.stream(rawQuery).collect(Collectors.groupingBy(e1 -> e1.getLong("taxdata")));
            } else {
                groupByTaxData = new HashMap(0);
            }
            ArrayList copy = new ArrayList(data);
            data.clear();
            HashSet complexProps = Sets.newHashSetWithExpectedSize((int)listFields.size());
            Set collect = listFields.stream().filter(e1 -> !e1.getListFieldKey().startsWith("csfd_")).map(e1 -> {
                String listFieldKey = e1.getListFieldKey();
                int index = listFieldKey.indexOf(46);
                if (index > 0) {
                    String substring = listFieldKey.substring(0, index);
                    complexProps.add(substring);
                    return substring;
                }
                return listFieldKey;
            }).collect(Collectors.toSet());
            HRPageCache pageCache = new HRPageCache(TaxDataForStepsList.this.getView());
            Set collapseId = (Set)pageCache.get("collapseId", Set.class);
            HashMap basicOfRawIds = Maps.newHashMapWithExpectedSize((int)copy.size());
            HashSet basicIds = Sets.newHashSetWithExpectedSize((int)copy.size());
            for (int i = 0; i < copy.size(); ++i) {
                DynamicObject object = (DynamicObject)copy.get(i);
                TaxTaskGuideOpEnum.convertStatus((DynamicObject)object);
                data.add((Object)object);
                String customSeq = i + start + 1 + "";
                if (keySet.contains("customseq")) {
                    object.set("customseq", (Object)customSeq);
                }
                long id = object.getLong("id");
                List objects = (List)groupByTaxData.get(id);
                String incomeItem = taxTaskRes.getTaxCategory(Long.valueOf(object.getLong("taxcategory.id"))).getIncomeItemLocaleString();
                boolean contains = keySet.contains("incomeitem");
                if (contains) {
                    object.set("incomeitem", (Object)incomeItem);
                }
                Object taxUnit = null;
                if (keySet.contains("taxunit.name")) {
                    taxUnit = object.get("taxunit");
                }
                if (CollectionUtils.isEmpty((Collection)objects)) continue;
                boolean containSrcStatus = keySet.contains("taxdatabasic.srcstatus");
                boolean containCalTaskGetDate = keySet.contains("taxdatabasic.caltaskgetdate");
                if (containSrcStatus || containCalTaskGetDate) {
                    if (objects.size() == 1) {
                        DynamicObject taxDataBasicNew;
                        DynamicObject taxDataBasic = object.getDynamicObject("taxdatabasic");
                        long basicId = taxDataBasic.getLong("id");
                        DynamicObject rawDataBasic = ((DynamicObject)objects.get(0)).getDynamicObject("taxdatabasic");
                        long rawBasicId = rawDataBasic.getLong("id");
                        if (!basicIds.add(basicId)) {
                            taxDataBasicNew = basicOfRawIds.computeIfAbsent(rawBasicId, ky -> {
                                DynamicObject res = (DynamicObject)taxDataBasic.getDataEntityType().createInstance();
                                HRDynamicObjectUtils.copy((DynamicObject)taxDataBasic, (DynamicObject)res);
                                return res;
                            });
                            object.set("taxdatabasic", (Object)taxDataBasicNew);
                        } else {
                            basicOfRawIds.put(rawBasicId, taxDataBasic);
                            taxDataBasicNew = taxDataBasic;
                        }
                        if (containSrcStatus) {
                            taxDataBasicNew.set("srcstatus", ((DynamicObject)objects.get(0)).get("taxdatabasic.srcstatus"));
                        }
                        if (!containCalTaskGetDate) continue;
                        taxDataBasicNew.set("caltaskgetdate", ((DynamicObject)objects.get(0)).get("taxdatabasic.caltaskgetdate"));
                        continue;
                    }
                    if (objects.size() > 1) {
                        DynamicObject taxDataBasic = object.getDynamicObject("taxdatabasic");
                        DynamicObject taxDataBasicNew = (DynamicObject)taxDataBasic.getDataEntityType().createInstance();
                        HRDynamicObjectUtils.copy((DynamicObject)taxDataBasic, (DynamicObject)taxDataBasicNew);
                        if (containSrcStatus) {
                            taxDataBasicNew.set("srcstatus", (Object)"");
                        }
                        if (containCalTaskGetDate) {
                            taxDataBasicNew.set("caltaskgetdate", null);
                        }
                        object.set("taxdatabasic", (Object)taxDataBasicNew);
                    }
                }
                if (objects.size() == 1) continue;
                if (keySet.contains("srcrefnum")) {
                    if (collapseId != null && collapseId.contains(id)) {
                        object.set("srcrefnum", (Object)"1");
                        continue;
                    }
                    object.set("srcrefnum", (Object)"2");
                }
                for (int j = 0; j < objects.size(); ++j) {
                    DynamicObject obj = (DynamicObject)objects.get(j);
                    DynamicObject instance = data.addNew();
                    instance.set("id", (Object)(-obj.getLong("id")));
                    TaxTaskGuideOpEnum.convertStatus((DynamicObject)obj);
                    for (String listFieldKey : collect) {
                        if (listFieldKey.startsWith("it_") || listFieldKey.equals("fseq") || listFieldKey.startsWith("itc_taxdata")) continue;
                        Object o1 = obj.get(listFieldKey);
                        if (o1 != null && complexProps.contains(listFieldKey)) {
                            DynamicObject srcObj = (DynamicObject)o1;
                            BasedataProp property = (BasedataProp)objectType.getProperty(listFieldKey);
                            IDataEntityType complexType = property.getComplexType();
                            DynamicObject targetObj = (DynamicObject)complexType.createInstance();
                            DataEntityPropertyCollection srcProps = srcObj.getDataEntityType().getProperties();
                            DataEntityPropertyCollection targetProps = complexType.getProperties();
                            for (IDataEntityProperty targetProp : targetProps) {
                                IDataEntityProperty srcProp = (IDataEntityProperty)srcProps.get((Object)targetProp.getName());
                                if (srcProp == null) continue;
                                targetProp.setValue((Object)targetObj, srcProp.getValue((Object)srcObj));
                            }
                            instance.set(listFieldKey, (Object)targetObj);
                            instance.set(listFieldKey + "_id", obj.get(listFieldKey + ".id"));
                            continue;
                        }
                        instance.set(listFieldKey, o1);
                    }
                    DynamicObjectCollection entry = obj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : entry) {
                        String itemId = dynamicObject.getString("taxitem.id");
                        if (!itemProps.contains(itemId)) continue;
                        instance.set("it_" + itemId, (Object)dynamicObject.getString(TaxDataForStepsList.this.propNameOfTaxValue()));
                    }
                    if (taxUnit != null) {
                        instance.set("taxunit", taxUnit);
                    }
                    if (contains) {
                        instance.set("incomeitem", (Object)incomeItem);
                    }
                    if (!keySet.contains("customseq")) continue;
                    instance.set("customseq", (Object)("  " + customSeq + "." + (j + 1)));
                }
            }
            return data;
        }
    }
}

