/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewFilter;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportDBServiceHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.RollbackImportSADTask;
import kd.sit.itc.business.taxtaskguide.task.TaxDataBasicDownLoadTask;
import kd.sit.itc.business.taxtaskguide.task.TaxDataBasicInitTask;
import kd.sit.itc.common.constants.ItcCommConstants;
import kd.sit.itc.common.constants.TaxGuideImportConstants;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.TaxUnitEntity;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.SitEntityTypeBillList;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxPrepareDataList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(TaxPrepareDataList.class);
    private static final String[] FORBIDDEN_OP_AFTER_MUTEX_LOCK = new String[]{"btn_specialadditional", "btn_sadprepared", "btn_more", "exportlistbyselectfields", "export_bytemplate", "exportlog", "btn_importsad", "btn_rollbackimportsad", "btn_rollbackimportsadbytaxunit", "btn_rollbackprepared", "updatepersonfile"};
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String KEY_FOR_MAIN_ENTITY = "#deductionMain";
    private MainEntityType extTypeTaxFile;
    private SitEntityTypeBillList billList;
    private TaxItemEntity[] deductionItems;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter parameter = (FormShowParameter)args.getSource();
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        BaseResult taskResult = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taskResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u88ab\u5220\u9664", (String)"TaxPrepareDataList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        GlobalParam.remove();
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.extEntityType());
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TaxPrepareDataDataProviderImpl());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        for (TaxItemEntity taxItem : this.deductionItems()) {
            listColumns.add(this.genColumnFromItem(taxItem));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Boolean hasLock = (Boolean)parameter.getCustomParam("hasLock");
        if (hasLock == null || !hasLock.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, FORBIDDEN_OP_AFTER_MUTEX_LOCK);
        } else {
            this.getView().setEnable(Boolean.TRUE, FORBIDDEN_OP_AFTER_MUTEX_LOCK);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)opKey);
        if (opEnum == null) {
            return;
        }
        TaxTaskEntity taxTaskEntity = this.taxTask();
        switch (opEnum) {
            case SAD_PREPARED: {
                args.setCancel(true);
                TaxTaskGuideViewHelper.showConfirmBeforePrepared((IFormView)this.getView(), (AbstractFormPlugin)this, (TaxTaskEntity)taxTaskEntity);
                break;
            }
            case ROLLBACK_SAD_PREPARED: {
                args.setCancel(true);
                TaxTaskGuideViewHelper.showConfirmBeforeRollbackPrepared((IFormView)this.getView(), (AbstractFormPlugin)this);
                break;
            }
            case IMPORT_SAD: {
                args.setCancel(true);
                this.showImportPage(taxTaskEntity);
                break;
            }
            case ROLLBACK_IMPORT_SAD: {
                args.setCancel(true);
                this.showConfirmRollbackDeductImport(opEnum);
                break;
            }
            case ROLLBACK_IMPORT_SAD_BY_TAX_UNIT: {
                args.setCancel(true);
                this.showConfirmMsgForTaxUnit(opEnum);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long pkId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
        if (pkId < 0L) {
            Long taxFileId = -pkId.longValue();
            DynamicObject taxFile = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)PropertiesQueryInfo.special((String)"itc_taxfile", (String[])new String[]{"id,name,number,taxregion,taxperson,person,taxunit,status,bsed,bsled"}), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxFileId)});
            TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.READ_ONLY, (IFormView)this.getView(), (long)0L);
        } else {
            QFilter idFilter = new QFilter("id", "=", (Object)pkId);
            DynamicObject dataBasic = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdatabasic"), (QFilter[])new QFilter[]{idFilter});
            DynamicObject taxFile = dataBasic.getDynamicObject("taxfile");
            SITPageCache pageCache = new SITPageCache(this.getView());
            pageCache.put("taxDataBasicForOpenTaxFile" + taxFile.getLong("id"), (Object)dataBasic.getLong("id"));
            TaxFileInfoServiceFactory.openTaxFile((DynamicObject)taxFile, (DataEditStatusEnum)DataEditStatusEnum.READ_ONLY, (IFormView)this.getView(), (long)0L);
        }
        args.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing_close".equals(operateKey) && (parentView = this.getView().getParentView()) != null) {
            parentView.close();
            this.getView().sendFormAction(parentView);
            IFormView taxTaskListView = parentView.getParentView();
            if (!ObjectUtils.isEmpty((Object)taxTaskListView)) {
                taxTaskListView.invokeOperation("refresh");
                this.getView().sendFormAction(taxTaskListView);
            }
        }
        PageCache pageCache = new PageCache(this.getView().getPageId());
        if ("afterprocessclose".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
            TaxTaskGuideCacheData from = (TaxTaskGuideCacheData)SerializationUtils.fromJsonString((String)pageCache.get("dataOfPrevRequest"), TaxTaskGuideCacheData.class);
            this.showResultMsgAfterOp(from);
        } else if ("exportbylist".equals(operateKey)) {
            this.exportByList();
        } else if ("showexportresult".equals(operateKey)) {
            this.showExportResult();
        } else if ("updatepersonfile".equals(operateKey)) {
            InitTaxDataBasicHelper.confirmVersion((TaxTaskEntity)this.getTaxTask(), (IFormView)this.getView(), (boolean)true);
        }
    }

    private TaxTaskEntity getTaxTask() {
        return (TaxTaskEntity)TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView().getParentView()).getData();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult confirmResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)actionId);
        if (MessageBoxResult.Yes == confirmResult && "TaxItemConfirm".equals(actionId)) {
            TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)this.taxTask());
            IPageCache pageCache = this.getView().getPageCache();
            String url = pageCache.get("importUrl");
            String taxUnitId = pageCache.get("importTaxUnit");
            TaxTaskGuideImportServiceHelper.openImportingPage((String)url, (IFormView)this.getView(), (TaxTaskEntity)this.taxTask(), (String)((Object)((Object)this)).getClass().getName(), (String)"taxSADtImportingCallback", (String)"itc_taxdeduct", (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)TaxTaskGuideOpEnum.of((String)"importsad").loadKDString(), (Long)((Long)BaseDataConverter.convert((Object)taxUnitId, Long.class)));
        }
        if (opEnum == null) {
            return;
        }
        switch (opEnum) {
            case SAD_PREPARED: {
                if (MessageBoxResult.Yes != confirmResult) break;
                this.modifyPrepareStatus(TaxTaskGuideOpEnum.SAD_PREPARED);
                break;
            }
            case ROLLBACK_SAD_PREPARED: {
                if (MessageBoxResult.Yes != confirmResult) break;
                this.modifyPrepareStatus(TaxTaskGuideOpEnum.ROLLBACK_SAD_PREPARED);
                break;
            }
            case ROLLBACK_IMPORT_SAD: 
            case ROLLBACK_IMPORT_SAD_BY_TAX_UNIT: {
                if (MessageBoxResult.Yes != confirmResult) break;
                BillList billList = (BillList)this.getView().getControl(KEY_BILL_LIST_AP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    return;
                }
                List<Object> ids = Arrays.asList(selectedRows.getPrimaryKeyValues());
                BatchResult result = TaxTaskGuideImportServiceHelper.validateRollbackImportSADTask((TaxTaskEntity)this.taxTask(), (TaxTaskGuideOpEnum)opEnum, ids);
                if (!result.isSuccess()) {
                    SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)result.getMessage());
                    this.showErrorMsg(result, opEnum);
                    break;
                }
                TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)this.taxTask());
                RollbackImportSADTask task = new RollbackImportSADTask(this.getView(), this.taxTask(), stepCaseInfo, opEnum);
                task.addData(500, ids);
                BatchResult result1 = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
                if (!result1.isSuccess()) {
                    SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)result1.getMessage());
                    this.getView().showErrorNotification(result1.getMessage());
                    break;
                }
                SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)MessageFormat.format(ResManager.loadKDString((String)"{0}\u6210\u529f", (String)"TaxPrepareDataList_7", (String)"sit-itc-formplugin", (Object[])new Object[0]), opEnum.loadKDString()));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView().getParentView(), (TaxTaskEntity)this.taxTask());
        if ("taxTemplateCallback".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (null != returnData) {
                String opName = TaxTaskGuideOpEnum.of((String)"importsad").loadKDString();
                TaxTaskGuideImportServiceHelper.openImportingPage((Map)returnData, (IFormView)this.getView(), (TaxTaskEntity)this.taxTask(), (String)((Object)((Object)this)).getClass().getName(), (String)"taxSADtImportingCallback", (String)"itc_taxdeduct", (TaxTaskGuideStepCaseInfo)stepCaseInfo, (String)opName, (AbstractFormPlugin)this);
            } else {
                LOG.info("return data is empty");
                this.getView().invokeOperation("refresh");
            }
        }
        if ("taxSADtImportingCallback".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
        if ("afterprocessclose".equals(actionId)) {
            this.afterUpdateDone();
        }
    }

    private void afterUpdateDone() {
        this.getView().invokeOperation("refresh");
        String totalNum = this.getView().getPageCache().get("totalNum");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{0}\u6761\u3002", (String)"TaxFileDeclarePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[]{totalNum}));
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }

    private TaxTaskEntity taxTask() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        BaseResult taskResult = TaxTaskServiceHelper.loadTaxTaskEntity((Long)taxTaskId);
        if (!taskResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5df2\u88ab\u5220\u9664", (String)"TaxPrepareDataList_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        return (TaxTaskEntity)taskResult.getData();
    }

    private MainEntityType extEntityType() {
        if (this.extTypeTaxFile != null) {
            return this.extTypeTaxFile;
        }
        try {
            this.extTypeTaxFile = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxpreparedata").clone();
            this.addItemProps((DynamicObjectType)this.extTypeTaxFile);
            this.extTypeTaxFile.createPropIndexs();
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Error occurs", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u9875\u9762\u5b9e\u4f53\u6269\u5c55\u5931\u8d25", (String)"TaxPrepareDataList_1", (String)"sit-itc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return this.extTypeTaxFile;
    }

    private BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new SitEntityTypeBillList((EntityType)this.extEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("itc_taxpreparedata");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private void addItemProps(DynamicObjectType mainType) {
        TaxItemEntity[] taxItems;
        for (TaxItemEntity taxItem : taxItems = this.deductionItems()) {
            TextProp property = new TextProp();
            String number = TaxDataBasicInitTask.keyFromItemNumber((String)taxItem.getNumber());
            property.setName(number);
            mainType.addProperty((DynamicProperty)property);
        }
    }

    private IListColumn genColumnFromItem(TaxItemEntity taxItem) {
        ListColumn column = new ListColumn();
        column.setCaption(LocaleString.fromMap((Map)taxItem.getName()));
        String number = TaxDataBasicInitTask.keyFromItemNumber((String)taxItem.getNumber());
        column.setKey(number);
        column.setListFieldKey(number);
        return column;
    }

    private TaxItemEntity[] deductionItems() {
        if (!ArrayUtils.isEmpty((Object[])this.deductionItems)) {
            return this.deductionItems;
        }
        long categoryId = this.taxCategory();
        this.deductionItems = this.taxTask().getTaxItems(prop -> prop.getTaxItemType() == 1300725425890280448L && prop.isCategory(Long.valueOf(categoryId)));
        return this.deductionItems;
    }

    private long taxCategory() {
        return ItcCommConstants.NORMAL_SALARY_INCOME_ID;
    }

    private void showConfirmRollbackDeductImport(TaxTaskGuideOpEnum opEnum) {
        BatchResult result = TaxTaskGuideImportServiceHelper.getOneImportSADTask((TaxTaskEntity)this.taxTask());
        if (!result.isSuccess()) {
            this.showErrorMsg(result, opEnum);
            return;
        }
        String message = opEnum.confirmMsgI18n(new Object[0]);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(opEnum.getCode(), (IFormPlugin)this));
    }

    private void modifyPrepareStatus(TaxTaskGuideOpEnum opEnum) {
        BillList billList = (BillList)this.getView().getControl(KEY_BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        int total = selectedRows.size();
        TaxTaskGuideServiceHelper.markPreparedStatus((TaxTaskEntity)this.taxTask(), (Object[])selectedRows.getPrimaryKeyValues(), (TaxTaskGuideOpEnum)opEnum);
        String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxPrepareDataList_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)msg);
        if (TaxTaskGuideOpEnum.SAD_PREPARED == opEnum) {
            this.getView().showSuccessNotification(msg);
        } else {
            List unPassSrcRefTaxDataBasicDys = (List)GlobalParam.get((String)"unPassSrcRefTaxDataBasicDys");
            List unPassPreStatusTaxDataBasicDys = (List)GlobalParam.get((String)"unPassPreStatusTaxDataBasicDys");
            GlobalParam.remove((String)"unPassSrcRefTaxDataBasicDys");
            GlobalParam.remove((String)"unPassPreStatusTaxDataBasicDys");
            if (!CollectionUtils.isEmpty((Collection)unPassSrcRefTaxDataBasicDys) || !CollectionUtils.isEmpty((Collection)unPassPreStatusTaxDataBasicDys)) {
                this.showPrepareStatusTips(unPassSrcRefTaxDataBasicDys, unPassPreStatusTaxDataBasicDys, opEnum, total);
            }
        }
        GlobalParam.remove((String)("taxTaskEntity" + this.taxTask().getId()));
        TaxTaskGuideStepCaseInfo stepCaseInfo = TaxTaskGuideViewHelper.getStepCaseInfo((IFormView)this.getView(), (TaxTaskEntity)this.taxTask());
        TaxTaskGuideServiceHelper.createTaxTaskRecord((TaxTaskEntity)this.taxTask(), (TaxTaskGuideStepCaseInfo)stepCaseInfo, (TaxTaskGuideOpEnum)opEnum, null);
        this.getView().invokeOperation("refresh");
    }

    private void showPrepareStatusTips(List<DynamicObject> unPassSrcRefTaxDataBasicDys, List<DynamicObject> unPassPreStatusTaxDataBasicDys, TaxTaskGuideOpEnum opEnum, int total) {
        String message;
        int failNum = unPassSrcRefTaxDataBasicDys.size() + unPassPreStatusTaxDataBasicDys.size();
        int successNum = total - failNum;
        String totalMsg = ResManager.loadKDString((String)"\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761\uff0c\u5b58\u5728\u4e0b\u5217\u6570\u636e\u672a\u901a\u8fc7\u6821\u9a8c\uff1a", (String)"TaxPrepareDataList_10", (String)"sit-itc-formplugin", (Object[])new Object[]{successNum, failNum});
        ArrayList allMsg = Lists.newArrayListWithExpectedSize((int)(unPassSrcRefTaxDataBasicDys.size() + unPassPreStatusTaxDataBasicDys.size()));
        if (!CollectionUtils.isEmpty(unPassSrcRefTaxDataBasicDys)) {
            for (DynamicObject unpassTaxDataBasicDy : unPassSrcRefTaxDataBasicDys) {
                message = ResManager.loadKDString((String)"{0}{1}\uff1a\u5df2\u5bfc\u5165\u7b97\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u64a4\u9500\u6570\u636e\u51c6\u5907\u3002", (String)"TaxPrepareDataList_11", (String)"sit-itc-formplugin", (Object[])new Object[]{unpassTaxDataBasicDy.getString("taxfile.number"), unpassTaxDataBasicDy.getString("taxperson.name")});
                allMsg.add(message);
            }
        }
        if (!CollectionUtils.isEmpty(unPassPreStatusTaxDataBasicDys)) {
            for (DynamicObject unPassPreStatusTaxDataBasicDy : unPassPreStatusTaxDataBasicDys) {
                message = ResManager.loadKDString((String)"{0}{1}\uff1a\u6570\u636e\u51c6\u5907\u72b6\u6001\u4e3a\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u64a4\u9500\u6570\u636e\u51c6\u5907\u3002", (String)"TaxPrepareDataList_12", (String)"sit-itc-formplugin", (Object[])new Object[]{unPassPreStatusTaxDataBasicDy.getString("taxfile.number"), unPassPreStatusTaxDataBasicDy.getString("taxperson.name")});
                allMsg.add(message);
            }
        }
        if (total > 1) {
            FormShowParameter parameters = SITShowFormServiceHelper.getOperationResultParameter((String)opEnum.loadKDString(), (String)totalMsg, (List)allMsg);
            this.getView().showForm(parameters);
        } else {
            this.getView().showErrorNotification((String)allMsg.get(0));
        }
    }

    private Map<Long, String> getTaxUnit(TaxTaskEntity taxTask) {
        List ids = TaxTaskGuideImportDBServiceHelper.getTaxUnitIdByBizStatus((Long)taxTask.getId());
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return null;
        }
        HashMap<Long, String> map = new HashMap<Long, String>(ids.size());
        Map taxUnitMap = taxTask.getTaxUnitMap();
        for (Long id : ids) {
            TaxUnitEntity taxUnit = (TaxUnitEntity)taxUnitMap.get(id);
            map.put(id, taxUnit.localName());
        }
        return map;
    }

    private void exportByList() {
        BillList billListAp = this.createBillList(KEY_BILL_LIST_AP);
        TaxTaskEntity taxTaskEntity = this.taxTask();
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        TaxDataBasicDownLoadTask task = new TaxDataBasicDownLoadTask(taxTaskEntity, billListAp, "1");
        task.setDeductionItems(this.deductionItems());
        List<Object> keys = null;
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            keys = new ArrayList<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                keys.add(selectedRow.getPrimaryKeyValue());
            }
        } else {
            List qFilters = TaxTaskGuideViewHelper.fetchListDataProviderQFilters((IPageCache)this.getView().getPageCache());
            TaxCategoryEntity taxCategory = taxTaskEntity.getTaxCategory(Long.valueOf(this.taxCategory()));
            if (taxCategory != null) {
                long taxpayerTypeId = taxCategory.getTaxpayerTypeId();
                qFilters.add(new QFilter("employment.taxpayertype.id", "=", (Object)taxpayerTypeId));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
            String orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy((IPageCache)this.getView().getPageCache());
            if (StringUtils.isEmpty((String)orderBy) || "id".equals(orderBy)) {
                orderBy = "taxfile.taxunit.id asc, id desc";
            } else if (!orderBy.contains(",id") && !orderBy.contains(", id")) {
                orderBy = orderBy + ", id desc";
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
            Object[] ids = serviceHelper.query("id", qFilters.toArray(new QFilter[0]), orderBy);
            if (!ArrayUtils.isEmpty((Object[])ids)) {
                keys = Stream.of(ids).map(e1 -> e1.getLong("id")).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(keys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxTaskGuidePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        String dataKey = ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"TaxTaskGuidePlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        task.setHandleCase(MultiThreadCase.BY_ACTION);
        task.addData(dataKey, 500, keys, 1);
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.showErrorMsg(execute, TaxTaskGuideOpEnum.EXPORT_BY_LIST);
        }
    }

    private void showExportResult() {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("bos_exportlog");
        param.setFormId("bos_list");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("bizobject", "=", (Object)("itc_taxpreparedata" + this.taxTask().getId())));
        param.getListFilterParameter().setFilter(new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()));
        this.getView().showForm((FormShowParameter)param);
    }

    private void showConfirmMsgForTaxUnit(TaxTaskGuideOpEnum opEnum) {
        Map<Long, String> taxUnitMap = this.getTaxUnit(this.taxTask());
        if (null == taxUnitMap || taxUnitMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u64cd\u4f5c\u7684\u6570\u636e", (String)"TaxTaskGuideStep2Plugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taxUnitMap.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u9664\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u7684\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxPrepareDataList_3", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            this.showFormOfTaxUnitSelect(taxUnitMap, opEnum, msg);
            return;
        }
        Long[] ids = new ArrayList<Long>(taxUnitMap.keySet()).toArray(new Long[0]);
        this.getPageCache().put("taxUnitId", String.valueOf(ids[0]));
        this.showConfirmRollbackDeductImport(opEnum);
    }

    protected void showFormOfTaxUnitSelect(Map<Long, String> taxUnitMap, TaxTaskGuideOpEnum opEnum, String description) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("itc_selecttaxunit");
        parameter.setCustomParam("description", (Object)description);
        String json = SerializationUtils.toJsonString(taxUnitMap);
        parameter.setCustomParam("taxUnitMap", (Object)json);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(((Object)((Object)this)).getClass().getName(), opEnum.getCode());
        parameter.setCloseCallBack(cb);
        this.getView().showForm(parameter);
    }

    public void showResultMsgAfterOp(TaxTaskGuideCacheData taskGuideCacheData) {
        String opName = taskGuideCacheData.getOpName();
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)opName);
        if (!taskGuideCacheData.isToContinue()) {
            this.showErrorMsg(taskGuideCacheData.getFatalMsg(), opEnum);
            return;
        }
        int successSize = 0;
        int failSize = 0;
        Map statusIdMap = taskGuideCacheData.getStatusIdMap();
        for (Map.Entry entry : statusIdMap.entrySet()) {
            if ((Integer)entry.getKey() >= ResultStatusEnum.ERROR.getCode()) {
                failSize += ((List)entry.getValue()).size();
                continue;
            }
            successSize += ((List)entry.getValue()).size();
        }
        int totalSize = successSize + failSize;
        Map idMsgMap = taskGuideCacheData.getIdMsgMap();
        if (CollectionUtils.isEmpty((Map)idMsgMap)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{1}\u6761\u3002", (String)"TaxTaskGuideStep1Plugin_3", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), totalSize}));
            return;
        }
        String title = TaxTaskGuideOpEnum.DECLARE == opEnum ? ResManager.loadKDString((String)"{0}\u5931\u8d25\uff0c{1}\u6761\u8bb0\u5f55\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a", (String)"TaxTaskGuideStep1Plugin_10", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), failSize}) : ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"TaxTaskGuideStep1Plugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{opEnum.loadKDString(), totalSize, successSize, failSize});
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)opEnum.loadKDString(), (String)title, new ArrayList(idMsgMap.values()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "AfterOp" + opEnum.getCode()));
        this.getView().showForm(parameter);
    }

    protected void showErrorMsg(String message, TaxTaskGuideOpEnum opEnum) {
        this.getView().showTipNotification(message);
    }

    protected void showErrorMsg(BatchResult<?> result, TaxTaskGuideOpEnum opEnum) {
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opEnum.loadKDString(), (String)result.getMessage());
        this.getView().showTipNotification(result.getMessage());
    }

    private void showImportPage(TaxTaskEntity taxTaskEntity) {
        TaxCategoryEntity taxCategory = taxTaskEntity.getTaxCategory(TaxGuideImportConstants.NORMAL_SALARY_INCOME_ID);
        if (null == taxCategory) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6ca1\u6709\u9009\u62e9\u4e2a\u7a0e\u79cd\u7c7b\u201c\u6b63\u5e38\u5de5\u8d44\u85aa\u91d1\u201d\uff0c\u4e0d\u9700\u8981\u5bfc\u5165\u4e13\u6263\u6570\u636e\u3002", (String)"TaxPrepareDataList_9", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        TaxTaskGuideImportServiceHelper.showSelectForm((IFormView)this.getView(), (long)0L, (String)"4", (String)((Object)((Object)this)).getClass().getName(), (String)"taxTemplateCallback", (TaxTaskEntity)taxTaskEntity);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "org.name": {
                List orgFilters = args.getQfilters();
                this.addOrgFilter(orgFilters);
                break;
            }
            case "taxfile.number": {
                List numberFilters = args.getQfilters();
                TaxTaskGuideViewFilter.addOrgFilterForTaxFile((List)numberFilters);
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        TaxTaskGuideViewFilter.setSchemeFilter((FilterContainerSearchClickArgs)args, (Long)taxTaskId);
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        List qFilters = evt.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taxTaskId = (Long)BaseDataConverter.convert((Object)parameter.getCustomParam("taxTaskId"), Long.class);
        TaxTaskGuideViewFilter.setPersonFilter((List)qFilters, (Long)taxTaskId);
        TaxTaskGuideViewFilter.setTaxFileFilter((List)qFilters, (String)"itc_taxdatabasic", (long)taxTaskId);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("org.name".equals(fieldName)) {
            List orgFilter = args.getQFilters();
            this.addOrgFilter(orgFilter);
        }
    }

    private void addOrgFilter(List<QFilter> originalFilters) {
    }

    public class TaxPrepareDataDataProviderImpl
    extends ListDataProvider {
        public List<QFilter> getQFilters() {
            List qFilters = super.getQFilters();
            TaxCategoryEntity taxCategory = TaxPrepareDataList.this.taxTask().getTaxCategory(Long.valueOf(TaxPrepareDataList.this.taxCategory()));
            if (taxCategory != null) {
                long taxpayerTypeId = taxCategory.getTaxpayerTypeId();
                qFilters.add(new QFilter("employment.taxpayertype.id", "=", (Object)taxpayerTypeId));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
            return qFilters;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            TaxTaskGuideViewHelper.cacheFilterAndOrderBy((ListDataProvider)this, (IPageCache)TaxPrepareDataList.this.getView().getPageCache());
            DynamicObjectCollection taxDataBasics = super.getData(start, limit);
            TaxPrepareDataList.this.addItemProps(taxDataBasics.getDynamicObjectType());
            DataEntityPropertyCollection properties = taxDataBasics.getDynamicObjectType().getProperties();
            if (!CollectionUtils.isEmpty((Collection)taxDataBasics)) {
                if (!properties.containsKey((Object)"taxfile")) {
                    return taxDataBasics;
                }
                List dataBasicIds = taxDataBasics.stream().map(e1 -> e1.getLong("id")).collect(Collectors.toList());
                QFilter taxFileFilter = new QFilter("taxdatabasic.id", "in", dataBasicIds);
                ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{taxFileFilter});
                Map deductionMapMap = TaxDataBasicInitTask.queryDeductionData((TaxTaskEntity)TaxPrepareDataList.this.taxTask(), (long)TaxPrepareDataList.this.taxCategory(), (List)filters);
                for (DynamicObject taxDataBase : taxDataBasics) {
                    Map deductionMap = (Map)deductionMapMap.get(taxDataBase.getLong("taxfile.boid"));
                    if (properties.containsKey((Object)"refstatus")) {
                        taxDataBase.set("refstatus", deductionMap.remove("refstatus"));
                    }
                    if (deductionMap == null) continue;
                    for (Map.Entry entry : deductionMap.entrySet()) {
                        if (!(entry.getValue() instanceof DynamicObject)) continue;
                        taxDataBase.set((String)entry.getKey(), ((DynamicObject)entry.getValue()).get("itemvalue"));
                    }
                }
            }
            return taxDataBasics;
        }
    }
}

