/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide;

import java.util.EventObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.sitbp.business.api.StepSwitcher;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxTaskGuidePlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String MUTEX_LOCK_OP_KEY = "calculateguide";
    public static final String CLOSE_CURRENT_MAIN_TAB = "closeCurrentMainTab";
    public static final String TAX_FILE_FLEX_AP = "taxfileflexap";

    public void registerListener(EventObject eventObject) {
        Tab tabSteps = (Tab)this.getControl("stepstabap");
        tabSteps.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BaseResult taxTaskRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskRes.isSuccess()) {
            this.getView().showErrorNotification(taxTaskRes.getMessage());
            return;
        }
        TaxTaskEntity taxTask = (TaxTaskEntity)taxTaskRes.getData();
        BaseResult lockRes = MutexServiceHelper.require((String)"itc_taxtask", (String)String.valueOf(taxTask.getId()), (String)MUTEX_LOCK_OP_KEY);
        if (!lockRes.isSuccess()) {
            if (MUTEX_LOCK_OP_KEY.equals(((MutexLockInfo)lockRes.getData()).getOpKey())) {
                this.getView().showTipNotification(lockRes.getMessage());
            } else {
                this.getView().showConfirm(lockRes.getMessage(), MessageBoxOptions.OK, new ConfirmCallBackListener(CLOSE_CURRENT_MAIN_TAB, (IFormPlugin)this));
            }
            this.getPageCache().put("lock_status", String.valueOf(taxTask.getId()));
        }
        HRPageCache pageCache = new HRPageCache(this.getView());
        pageCache.put("hasLock", (Object)lockRes.isSuccess());
        String tabName = "stepstabap";
        Tab tabSteps = (Tab)this.getControl(tabName);
        String tabKey = TaxTaskStatusEnum.SAD_PREPARED.match(taxTask.getTaskStatus()) ? "step40tabpageap" : ((Control)tabSteps.getItems().get(0)).getKey();
        tabSteps.activeTab(tabKey);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        GlobalParam.remove();
        String tabKey = tabSelectEvent.getTabKey();
        String stepCode = tabKey.substring(0, 6);
        StepSwitcher switcher = StepSwitcher.getInstanceBy((String)stepCode);
        TaxTaskEntity taxTaskEntity = (TaxTaskEntity)TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView()).getData();
        HRPageCache pageCache = new HRPageCache(this.getView());
        Boolean hashLock = (Boolean)pageCache.get("hasLock", Boolean.class);
        switcher.stepSwitch(this.getView(), taxTaskEntity, hashLock.booleanValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (CLOSE_CURRENT_MAIN_TAB.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }

    public void pageRelease(EventObject eventObject) {
        BaseResult taxTaskRes = TaxTaskGuideViewHelper.getTaxTask((IFormView)this.getView());
        if (!taxTaskRes.isSuccess()) {
            this.getView().showErrorNotification(taxTaskRes.getMessage());
            return;
        }
        HRPageCache pageCache = new HRPageCache(this.getView());
        Boolean hashLock = (Boolean)pageCache.get("hasLock", Boolean.class);
        if (hashLock != null && hashLock.booleanValue()) {
            MutexServiceHelper.release((String)"itc_taxtask", (String)String.valueOf(((TaxTaskEntity)taxTaskRes.getData()).getId()), (String)MUTEX_LOCK_OP_KEY);
        }
    }

    public void destory() {
        GlobalParam.remove();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IFormView taxTaskListView = this.getView().getParentView();
        if (!ObjectUtils.isEmpty((Object)taxTaskListView)) {
            taxTaskListView.invokeOperation("refresh");
            this.getView().sendFormAction(taxTaskListView);
        }
    }
}

