/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.imports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.common.model.TaxtemplateEntity;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportConfig;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportDataTask;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportLogHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class ImportTaxResultImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(ImportTaxResultImportingPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnsuspend"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        log.info("ImportTaxResultImportingPlugin-----show progress");
        IFormView view = this.getView();
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "btnclose", "btnok", "buttonap"});
        FormShowParameter showParamete = view.getFormShowParameter();
        String mainEntityId = (String)showParamete.getCustomParam("entityid");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityId);
        String mainEntityName = mainEntityType.getDisplayName().toString();
        LocaleString localString = new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5c06\u6570\u636e\u5bfc\u5165\u5230\u4e2a\u7a0e\u4efb\u52a1", (String)"ImportTaxResultImportingPlugin_9", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        ((Label)this.getControl("title")).setText(localString.toString());
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)mainEntityId, (String)this.getView().getPageId()), (String)mainEntityName);
        GlobalParam.remove();
        try {
            TaxResultImportConfig conf = this.setImportConfig(showParamete, logId, mainEntityId);
            RequestContext requestContext = RequestContext.get();
            SITThreadPoolFactory.getImportPrepareThreadPool().execute((Runnable)new TaxResultImportDataTask(requestContext, conf, "resolveExcel"));
            SITThreadPoolFactory.getImportHanddataThreadPool().execute((Runnable)new TaxResultImportDataTask(requestContext, conf, "importData"));
            progress.start();
        }
        catch (Throwable ex) {
            log.error(ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportTaxResultImportingPlugin_7", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportTaxResultImportingPlugin_8", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            TaxResultImportLogHelper.append((Object)logId, (String)ImportLogger.formatException((Throwable)ex));
            GlobalParam.remove();
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        String s1 = "Cached_Import_Logger<----" + cacheLogStr;
        log.info(s1);
        JSONObject info = JSON.parseObject((String)cacheLogStr);
        if (info != null) {
            importProgress = info.getIntValue("progress");
            String err = info.getString("err");
            if (importProgress < 0 || StringUtils.isNotEmpty((String)err)) {
                this.importProgressError(info);
                return;
            }
            Label rowCount = (Label)this.getControl("rowcount");
            Label successLabel = (Label)this.getControl("successcount");
            Label failedLabel = (Label)this.getControl("failcount");
            int row = info.getIntValue("rowindex") - 1;
            int lastrow = info.getIntValue("lastrowindex") - 1;
            int total = info.getIntValue("total");
            int succeed = info.getIntValue("succeed");
            int failed = info.getIntValue("failed");
            if (row >= 0) {
                rowCount.setText("" + total);
            }
            successLabel.setText("" + succeed);
            failedLabel.setText("" + failed);
            if (importProgress >= 100) {
                this.importProgressDone(info, succeed);
            }
            if (lastrow > 0) {
                this.importProcessing();
            }
        }
        progressEvent.setProgress(importProgress);
    }

    public void click(EventObject evt) {
        String controlKey;
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.detailsClick();
                this.continueImport();
                break;
            }
            case "btnsuspend": {
                IFormView view = this.getView();
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e2d\u6b62\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ImportTaxResultImportingPlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[0])));
                this.getAppCache(view).put(this.getSuspendKey(), (Object)this.getSuspendKey());
                view.setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
                HashMap<String, Integer> notHidden2 = new HashMap<String, Integer>(16);
                notHidden2.put("gr", 1);
                view.updateControlMetadata("suspendpanel", notHidden2);
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.put("issuspend", "true");
                break;
            }
        }
    }

    private void continueImport() {
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        String mainEntityId = (String)showParameter.getCustomParam("entityid");
        String stepCaseInfoJson = (String)showParameter.getCustomParam("stepCaseInfo");
        TaxTaskGuideStepCaseInfo stepCaseInfo = (TaxTaskGuideStepCaseInfo)JSON.parseObject((String)stepCaseInfoJson, TaxTaskGuideStepCaseInfo.class);
        Long taxGroupId = stepCaseInfo.getTabValue();
        String scene = "3";
        if (!"itc_taxdata".equals(mainEntityId)) {
            scene = "4";
            taxGroupId = 0L;
        }
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setFormId("itc_selectimporttpl");
        importShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        importShowParameter.setCustomParam("taxgroup", (Object)taxGroupId);
        importShowParameter.setCustomParam("scene", (Object)scene);
        String taxTaskEntityJson = (String)showParameter.getCustomParam("taxTaskEntity");
        TaxTaskEntity taxTask = (TaxTaskEntity)JSON.parseObject((String)taxTaskEntityJson, TaxTaskEntity.class);
        Object[] taxUnitIds = TaxTaskGuideImportServiceHelper.getTaxUnitIds((TaxTaskEntity)taxTask);
        importShowParameter.setCustomParam("taxUnitIds", (Object)taxUnitIds);
        if (!ArrayUtils.isEmpty((Object[])taxUnitIds) && taxUnitIds.length == 1) {
            importShowParameter.setCustomParam("taxUnitId", taxUnitIds[0]);
        }
        importShowParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        String pageId = view.getParentView().getPageId();
        importShowParameter.setParentPageId(pageId);
        String className = showParameter.getCloseCallBack().getClassName();
        CloseCallBack cb = new CloseCallBack(className, "taxTemplateCallback");
        importShowParameter.setCloseCallBack(cb);
        view.showForm(importShowParameter);
    }

    private IAppCache getAppCache(IFormView view) {
        String appId = EntityMetadataCache.getDataEntityType((String)"itc_taxdata").getAppId();
        return AppCache.get((String)appId);
    }

    private String getSuspendKey() {
        String billFormId = "itc_taxdata";
        return "IMPT_SUSPEND_" + billFormId;
    }

    private void detailsClick() {
        String jsonData;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)this.getView().getPageId()))});
        if (taskData == null || StringUtils.isBlank((String)(jsonData = taskData.getString("data")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"TaxFileImportingPlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject data = JSON.parseObject((String)jsonData);
        try {
            JSONObject info = data.getJSONObject("info");
            this.downloadDetail(info);
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"TaxFileImportingPlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
    }

    private void downloadDetail(Object obj) {
        Map map = (Map)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), Map.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (!CollectionUtils.isEmpty((Map)map)) {
            for (Map.Entry entry : map.entrySet()) {
                String errFile = (String)((Map)entry.getValue()).get("errFile");
                if (!StringUtils.isNotEmpty((String)errFile)) continue;
                proxy.addAction("download", (Object)(errFile + "&a=t"));
                break;
            }
        }
    }

    private void detailClickErrorShow(ImportLogger logger) {
        if (logger.getFailed() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaxFileImportingPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        } else {
            String msg = logger.toString().trim();
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void importProgressDone(JSONObject info, int succeed) {
        this.getView().hideLoading();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "btnsuspend"});
        int failed = info.getIntValue("failed");
        String opName = (String)this.getView().getFormShowParameter().getCustomParam("opName");
        if (!StringUtils.isEmpty((String)opName)) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761", (String)"ImportTaxResultImportingPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]), succeed, failed);
            SITLogServiceHelper.addLog((IFormView)this.getView().getParentView(), (String)opName, (String)msg);
        }
        if (failed > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnok", "buttonap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap"});
        }
        this.getAppCache(this.getView()).remove(this.getSuspendKey());
        IPageCache pageCache = this.getView().getPageCache();
        String isSuspend = pageCache.get("issuspend");
        if (StringUtils.isNotEmpty((String)isSuspend)) {
            LocaleString title = new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6b62\u5b8c\u6210", (String)"PImportTaxResultImportingPlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            ((Label)this.getControl("title")).setText(title.toString());
            pageCache.remove("issuspend");
        } else {
            LocaleString title = new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"PImportTaxResultImportingPlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            ((Label)this.getControl("title")).setText(title.toString());
        }
    }

    private void importProgressError(JSONObject info) {
        String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : "";
        this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TaxFileImportingPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]), err));
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.stop();
        GlobalParam.remove();
        this.getView().close();
    }

    private void importProcessing() {
        HashMap<String, Integer> meta = new HashMap<String, Integer>();
        meta.put("itime", 3000);
        this.getView().updateControlMetadata("progressbarap", meta);
    }

    private Set<Integer> setOnlyFieldKey(Map<Integer, TaxtemplateEntity> templateMap) {
        HashSet<Integer> set = new HashSet<Integer>(16);
        if (CollectionUtils.isEmpty(templateMap)) {
            return set;
        }
        for (Map.Entry<Integer, TaxtemplateEntity> entry : templateMap.entrySet()) {
            TaxtemplateEntity template = entry.getValue();
            String isonly = template.getIsonly();
            if ("0".equals(isonly)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    private Map<Integer, TaxtemplateEntity> setTemplateMap(String templateId, String head) {
        DynamicObject template = this.queryImportTemplate(Long.valueOf(templateId));
        DynamicObjectCollection dys = template.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Long id = template.getLong("id");
        HashMap<String, TaxtemplateEntity> templateMap = new HashMap<String, TaxtemplateEntity>(dys.size());
        for (DynamicObject dy : dys) {
            String importField = dy.getString("importfield");
            TaxtemplateEntity entity = new TaxtemplateEntity(id, dy.getString("isonly"), Long.valueOf(dy.getLong("taxitem.id")), dy.getString("fieldkey"), dy.getString("importfield"), dy.getBoolean("ismustinput"));
            templateMap.put(importField, entity);
        }
        Map rowData = (Map)JSONObject.parseObject((String)head, Map.class);
        HashMap<Integer, TaxtemplateEntity> map = new HashMap<Integer, TaxtemplateEntity>(rowData.size());
        for (Map.Entry entry : rowData.entrySet()) {
            TaxtemplateEntity taxtemplateEntity;
            String headValue = (String)entry.getValue();
            if (headValue.startsWith("*") || headValue.endsWith("*")) {
                headValue = headValue.replaceAll("\\*", "");
            }
            if (StringUtils.isBlank((String)headValue) || null == (taxtemplateEntity = (TaxtemplateEntity)templateMap.get(headValue))) continue;
            map.put((Integer)entry.getKey(), taxtemplateEntity);
        }
        return map;
    }

    private DynamicObject queryImportTemplate(Long templateId) {
        String selectProperties = "id, isonly, importfield, taxitem, fieldkey, ismustinput";
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxtemplate");
        QFilter qFilter = new QFilter("id", "=", (Object)templateId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.queryOne(selectProperties, qFilters);
    }

    public void loadAllTaxItemsDy(long countryId, long categoryId, long groupId, QFilter ... preFilter) {
        String globalKey = countryId + "_" + categoryId + "_" + groupId + "_dy";
        HashMap<Long, DynamicObject> result = (HashMap<Long, DynamicObject>)GlobalParam.get((String)globalKey);
        if (result != null) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("country.id", "=", (Object)countryId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (preFilter != null) {
            filters.addAll(Arrays.asList(preFilter));
        }
        if (categoryId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid_id", "=", (Object)categoryId));
        }
        if (groupId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid.group.id", "=", (Object)groupId));
        }
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxitem", (String[])new String[]{"id", "number", "name", "taxcategories", "dataround", "datatype", "datalength", "caltaxtype"}).subProp("dataprecision", new String[]{"scale"}).subProp("currency", new String[]{"amtprecision"}).subProp("splitalgo", new String[]{"implclasskey"});
        DynamicObject[] query = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])filters.toArray(new QFilter[0]));
        result = new HashMap<Long, DynamicObject>(query.length);
        for (DynamicObject obj : query) {
            long id = obj.getLong("id");
            result.put(id, obj);
        }
        GlobalParam.set((String)globalKey, result);
    }

    private TaxResultImportConfig setImportConfig(FormShowParameter showParameter, Object logId, String mainEntityId) {
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.IMPORT;
        if (!"itc_taxdata".equals(mainEntityId)) {
            opEnum = TaxTaskGuideOpEnum.IMPORT_SAD;
        }
        String head = (String)showParameter.getCustomParam("head");
        String templateId = (String)showParameter.getCustomParam("templateId");
        Object taxUnit = showParameter.getCustomParam("taxUnitId");
        String url = (String)this.getView().getFormShowParameter().getShowParameter().getCustomParam("url");
        long taxUnitId = 0L;
        if (taxUnit != null) {
            taxUnitId = (Long)BaseDataConverter.convert((Object)taxUnit, Long.class);
        }
        Map<Integer, TaxtemplateEntity> templateMap = this.setTemplateMap(templateId, head);
        Map itemMap = SitCommonServiceHelper.loadAllTaxItems((long)1000001L, (long)0L, (long)0L, (QFilter[])new QFilter[0]);
        this.loadAllTaxItemsDy(1000001L, 0L, 0L, new QFilter[0]);
        String taxTaskEntityJson = (String)showParameter.getCustomParam("taxTaskEntity");
        TaxTaskEntity taxTask = (TaxTaskEntity)JSON.parseObject((String)taxTaskEntityJson, TaxTaskEntity.class);
        Map taxItemMap = taxTask.getTaxItemMap();
        Map<Long, TaxItemEntity> intersectionMap = this.getIntersectionMap(itemMap, taxItemMap);
        String stepCaseInfoJson = (String)showParameter.getCustomParam("stepCaseInfo");
        TaxTaskGuideStepCaseInfo stepCaseInfo = (TaxTaskGuideStepCaseInfo)JSON.parseObject((String)stepCaseInfoJson, TaxTaskGuideStepCaseInfo.class);
        String headerLineNumber = (String)showParameter.getCustomParam("headerLineNumber");
        if (StringUtils.isEmpty((String)headerLineNumber)) {
            headerLineNumber = "0";
        }
        return new TaxResultImportConfig(this.getView(), logId, url, mainEntityId, templateMap, intersectionMap, taxTask, null, this.setOnlyFieldKey(templateMap), stepCaseInfo, Integer.parseInt(headerLineNumber), opEnum, Long.valueOf(taxUnitId));
    }

    private Map<Long, TaxItemEntity> getIntersectionMap(Map<Long, TaxItemEntity> itemMap, Map<Long, TaxItemEntity> taskItemMap) {
        Set<Long> keySet = itemMap.keySet();
        Set<Long> keySet1 = taskItemMap.keySet();
        Sets.SetView intersection = Sets.intersection(keySet, keySet1);
        HashMap result = Maps.newHashMapWithExpectedSize((int)keySet.size());
        for (Long taxItemId : intersection) {
            if (itemMap.get(taxItemId) == null) continue;
            result.put(taxItemId, itemMap.get(taxItemId));
        }
        return result;
    }
}

