/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.imports;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.taxtaskguide.imports.TaxImportExportTmpDBHelper;
import kd.sit.itc.common.model.ImportField;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.TaxTemplateImportTaxDataEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxImportTemplateUsingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(TaxImportTemplateUsingPlugin.class);
    private static final Map<Long, Integer> dataprecisionMap = new HashMap<Long, Integer>(16);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnok", "btncancel", "btndelete", "btndownload", "bntedittemplate"});
        BasedataEdit taxTemplate = (BasedataEdit)this.getView().getControl("taxtemplate");
        BasedataEdit taxUnit = (BasedataEdit)this.getView().getControl("taxunit");
        taxTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnuploadexcel"});
        Button button = (Button)this.getControl("btnuploadexcel");
        button.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.selectTemplate();
        this.setTaxUnit();
    }

    private void setTaxUnit() {
        FormShowParameter params = this.getView().getFormShowParameter();
        Long id = (Long)params.getCustomParam("taxUnitId");
        if (null == id) {
            return;
        }
        this.getModel().setValue("taxunit", (Object)id);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (!this.validateTemplateIsNull(key)) {
            return;
        }
        switch (key) {
            case "btnok": {
                this.clickOK();
                break;
            }
            case "btndownload": {
                this.downloadFileTemplate();
                break;
            }
            case "btncancel": {
                this.clickCancel();
                break;
            }
            case "btndelete": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btndelete", "filename"});
                this.getModel().setValue("filename", null);
                this.getModel().setValue("filepath", null);
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnuploadexcel"});
                break;
            }
            case "bntedittemplate": {
                Long id = this.getModel().getDataEntity().getLong("taxtemplate.id");
                if (null == id || 0L == id) {
                    return;
                }
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("sitbs_taxtemplateview");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxtemplate");
                DynamicObject dy = helper.queryOne("issyspreset", (Object)id);
                boolean isSysPreset = dy.getBoolean("issyspreset");
                showParameter.setStatus(OperationStatus.EDIT);
                if (isSysPreset) {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                showParameter.setPkId((Object)id);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        FormShowParameter params = this.getView().getFormShowParameter();
        ListShowParameter listShowParameter = (ListShowParameter)arg.getFormShowParameter();
        switch (fieldKey) {
            case "taxtemplate": {
                Object scene = params.getCustomParam("scene");
                Object taxCategory = params.getCustomParam("taxCategory");
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and("taxCategory", "=", taxCategory);
                qFilter.and("scene", "=", scene);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "taxunit": {
                this.setTaxUintFilter(params, listShowParameter);
                break;
            }
        }
    }

    private void setTaxUintFilter(FormShowParameter params, ListShowParameter listShowParameter) {
        Object ids = params.getCustomParam("taxUnitIds");
        QFilter qFilter = new QFilter("id", "in", ids);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void upload(UploadEvent evt) {
        if (!this.validateTemplateIsNull("upload")) {
            return;
        }
        super.upload(evt);
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            IDataModel model = this.getModel();
            FileService service = FileServiceFactory.getAttachmentFileService();
            boolean isSuccess = this.validateImportFile(view, service, url);
            if (isSuccess) {
                view.setVisible(Boolean.FALSE, new String[]{"buttonap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btndelete", "filename"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnuploadexcel"});
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue("filepath", (Object)url);
            }
        }
    }

    private void downloadFileTemplate() {
        String downUrl = this.getFileUrlByTemplate();
        if (!StringUtils.isEmpty((CharSequence)downUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)downUrl);
        }
    }

    private boolean validateImportFile(IFormView view, FileService service, String url) {
        boolean isSuccess;
        final IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove("templatevalidate");
        pageCache.remove("isEmpty");
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    TaxImportTemplateUsingPlugin.this.validateTheFirstLineImportFile(row);
                    int rowCount = this.getRowCount();
                    if (2 > rowCount) {
                        pageCache.put("isEmpty", "true");
                    }
                }
            });
            boolean startValidate = Boolean.parseBoolean(pageCache.get("templatevalidate"));
            boolean isEmpty = Boolean.parseBoolean(pageCache.get("isEmpty"));
            String taxItemEnable = pageCache.get("taxitemenable");
            if (!startValidate) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f", (String)"TaxImportTemplateUsingPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            }
            if (isEmpty) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20Excel\u4e2d\u672a\u5305\u542b\u4efb\u4f55\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u6b63\u786e\u540e\u518d\u8bd5\u3002", (String)"TaxImportTemplateUsingPlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)taxItemEnable)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e2a\u7a0e\u9879\u76ee\u4e0d\u662f\u542f\u7528\u72b6\u6001\u65e0\u6cd5\u4e0a\u4f20\uff0c\u5982\u8981\u4e0a\u4f20\u9700\u542f\u7528\u4e2a\u7a0e\u9879\u76ee\uff0c\u5982\u65e0\u9700\u4e0a\u4f20\u8bf7\u4fee\u6539\u5bfc\u5165\u5bfc\u51fa\u65b9\u6848\u914d\u7f6e\u6a21\u677f\u3002", (String)"TaxImportTemplateUsingPlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[0]), taxItemEnable));
            }
            isSuccess = true;
        }
        catch (KDException e) {
            view.showErrorNotification(e.getMessage());
            isSuccess = false;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"TaxImportTemplateUsingPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            isSuccess = false;
        }
        return isSuccess;
    }

    private void selectTemplate() {
        FormShowParameter prams = this.getView().getFormShowParameter();
        Object taxGroup = prams.getCustomParam("taxgroup");
        Object scene = prams.getCustomParam("scene");
        DynamicObject template = TaxImportExportTmpDBHelper.queryOneTemplateForTaxImport((Object)taxGroup, (Object)scene);
        StringBuilder buffer = new StringBuilder();
        String comma = MultiLangHelper.getMultiLangCommaDelimiter();
        if (null != template) {
            this.getModel().setValue("taxtemplate", template.get("id"));
            DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : dynamicObjectCollection) {
                String isOnly = dy.getString("isonly");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)isOnly)) continue;
                buffer.append(dy.getString("importfield")).append(comma);
            }
        }
        if (buffer.length() != 0) {
            buffer.deleteCharAt(buffer.length() - 1);
            this.getModel().setValue("onlyfield", (Object)buffer.toString());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndelete", "filename"});
    }

    private void clickCancel() {
        this.getView().close();
    }

    private void clickOK() {
        String filepath = this.getModel().getDataEntity().getString("filepath");
        long taxUnitId = this.getModel().getDataEntity().getLong("taxunit.id");
        if (StringUtils.isBlank((CharSequence)filepath)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"TaxImportTemplateUsingPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!"taxunit".equals(name) || !((BasedataProp)property).isMustInput() || taxUnitId != 0L) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7eb3\u7a0e\u5355\u4f4d", (String)"TaxImportTemplateUsingPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put(taxUnitId, filepath);
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private void validateTheFirstLineImportFile(SheetHandler.ParsedRow row) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("taxtemplate");
        int hearLine = dynamicObject.getInt("headerlinenumber");
        if (row.getRowNum() == hearLine) {
            this.checkTaxItemEnable(dynamicObject);
            if (row.isEmpty() || !this.checkTemplate(row, this.getModel().getDataEntity().getDynamicObject("taxtemplate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"ExportTemplateUsingPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put("templatevalidate", "true");
        }
    }

    private boolean checkTemplate(SheetHandler.ParsedRow row, DynamicObject dynamicObject) {
        DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<String> set = new HashSet<String>(dys.size());
        for (DynamicObject dy : dys) {
            String title = dy.getString("importfield");
            set.add(title);
        }
        Map data = row.getData();
        HashSet valueSet = new HashSet(data.values());
        HashSet headValueSet = new HashSet(data.values());
        for (String headValue : valueSet) {
            if (headValue.startsWith("*") || headValue.endsWith("*")) {
                headValue = headValue.replaceAll("\\*", "");
            }
            headValueSet.add(headValue);
        }
        for (String templateValue : set) {
            if (headValueSet.contains(templateValue)) continue;
            return false;
        }
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String json = JSON.toJSONString((Object)data);
        pageCache.put("head", json);
        pageCache.put("headerLineNumber", dynamicObject.getString("headerlinenumber"));
        pageCache.put("templateId", dynamicObject.getString("id"));
        return true;
    }

    private void checkTaxItemEnable(DynamicObject dynamicObject) {
        DynamicObject[] itemArr;
        DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<String> set = new HashSet<String>(dys.size());
        HashSet<Long> itemId = new HashSet<Long>(dys.size());
        for (DynamicObject dy : dys) {
            DynamicObject taxItem = (DynamicObject)dy.get("taxitem");
            if (null == taxItem) continue;
            itemId.add(taxItem.getLong("id"));
        }
        if (CollectionUtils.isEmpty(itemId)) {
            return;
        }
        String selectProperties = "id,name,enable";
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter qFilter = new QFilter("id", "in", itemId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        for (DynamicObject dy : itemArr = helper.query(selectProperties, qFilters)) {
            boolean enable = dy.getBoolean("enable");
            if (enable) continue;
            set.add(dy.getString("name"));
        }
        if (!CollectionUtils.isEmpty(set)) {
            IPageCache pageCache = this.getPageCache();
            Object[] array = set.toArray(new String[0]);
            pageCache.put("taxitemenable", StringUtils.join((Object[])array, (String)"\uff0c"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileUrlByTemplate() {
        FormShowParameter prams = this.getView().getFormShowParameter();
        Object taxGroup = prams.getCustomParam("taxgroup");
        Object scene = prams.getCustomParam("scene");
        logger.info("-------------------------------*****{},{}", taxGroup, scene);
        DynamicObject template = TaxImportExportTmpDBHelper.queryOneTemplateForTaxImport((Object)taxGroup, (Object)scene);
        if (null == template) {
            return null;
        }
        logger.info("-------------------------------*****{},{}", template.get("name"));
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        ArrayList<ImportField> list = this.getImportTemplate(template);
        params.put("template", list);
        params.put("name", template.getString("name"));
        params.put("headerlinenumber", template.getInt("headerlinenumber"));
        WorkbookInfo workbookInfo = WorkbookInfoGenerator.generateWith((String)"sitTaxResultTemplateExport", params);
        Workbook wb = null;
        try {
            wb = ExcelHelper.writeData((WorkbookInfo)workbookInfo, (List)Lists.newArrayList(), (ExportResult)new ExportResult(Integer.valueOf(0)));
            String string = ExcelHelper.storeFile((Workbook)wb, (String)this.getFileName(template.getString("name")));
            return string;
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    logger.error("TaxImportTemplateUsingPlugin.getFileUrlByTemplate close wb error:", (Throwable)e);
                }
            }
        }
    }

    private ArrayList<ImportField> getImportTemplate(DynamicObject template) {
        ArrayList<ImportField> list = new ArrayList<ImportField>(16);
        DynamicObjectCollection dys = template.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < dys.size(); ++i) {
            DynamicObject dy = (DynamicObject)dys.get(i);
            ImportField importField = new ImportField(dy.getString("importfield"), null);
            String fieldKey = dy.getString("fieldkey");
            long taxItemId = dy.getLong("taxitem.id");
            importField.setColNum(Integer.valueOf(i));
            importField.setMustInput(dy.getBoolean("ismustinput"));
            importField.setFieldCode(fieldKey);
            importField.setTaxitemId(Long.valueOf(taxItemId));
            list.add(importField);
            this.getDynamicProperty(dy, importField);
        }
        return list;
    }

    private String getFileName(String templateName) {
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        return String.format("%s_%s%s", templateName, date, ".xlsx");
    }

    private void getDynamicProperty(DynamicObject dy, ImportField importField) {
        IDataEntityProperty dataEntityProperty = null;
        BasedataEntityType basedataEntityType = null;
        DynamicProperty dynamicProperty = null;
        String fieldkey = dy.getString("fieldkey");
        DynamicObject taxitemDy = dy.getDynamicObject("taxitem");
        if (HRStringUtils.isNotEmpty((String)fieldkey)) {
            logger.info("kd/sit/itc/formplugin/web/taskguide/imports/TaxImportTemplateUsingPlugin.java:fieldkey-----{}", (Object)fieldkey);
            TaxTemplateImportTaxDataEnum enumBySystemFieldNumber = TaxTemplateImportTaxDataEnum.getEnumBySystemFieldNumber((String)fieldkey);
            logger.info("kd/sit/itc/formplugin/web/taskguide/imports/TaxImportTemplateUsingPlugin.java:543-----{}", (Object)enumBySystemFieldNumber);
            if (null == enumBySystemFieldNumber) {
                return;
            }
            String entityName = enumBySystemFieldNumber.getEntityName();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            Map allFiledProperty = dataEntityType.getAllFields();
            if (fieldkey.contains(entityName)) {
                fieldkey = fieldkey.replace(entityName + ".", "");
            }
            String[] fieldCodes = fieldkey.split("\\.");
            for (int i = 0; i < fieldCodes.length; ++i) {
                String field = fieldCodes[i];
                if (i == 0) {
                    dataEntityProperty = (IDataEntityProperty)allFiledProperty.get(field);
                } else if (basedataEntityType != null) {
                    dataEntityProperty = basedataEntityType.getProperty(field);
                }
                if (dataEntityProperty instanceof BasedataProp) {
                    basedataEntityType = (BasedataEntityType)((BasedataProp)dataEntityProperty).getComplexType();
                    continue;
                }
                if (!(dataEntityProperty instanceof DynamicProperty)) continue;
                dynamicProperty = (DynamicProperty)dataEntityProperty;
                break;
            }
            importField.setProperty(dynamicProperty);
        } else {
            FieldProp fieldProp = this.createFieldProp(taxitemDy);
            importField.setProperty((DynamicProperty)fieldProp);
        }
    }

    public FieldProp createFieldProp(DynamicObject taxItemDy) {
        Long dataTypeId = taxItemDy.getLong("datatype.id");
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId.longValue()) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(taxItemDy.getString("id"));
            decimalProp.setAlias(taxItemDy.getString("name"));
            decimalProp.setScale(dataprecisionMap.get(taxItemDy.getLong("dataprecision.id")).intValue());
            return decimalProp;
        }
        if (SitDataTypeEnum.TEXT.getId() == dataTypeId.longValue()) {
            TextProp textProp = new TextProp();
            textProp.setName(taxItemDy.getString("id"));
            textProp.setAlias(taxItemDy.getString("name"));
            return textProp;
        }
        if (SitDataTypeEnum.INTEGER.getId() == dataTypeId.longValue()) {
            IntegerProp integerProp = new IntegerProp();
            integerProp.setName(taxItemDy.getString("id"));
            integerProp.setAlias(taxItemDy.getString("name"));
            return integerProp;
        }
        if (SitDataTypeEnum.DATE.getId() == dataTypeId.longValue()) {
            DateTimeProp dateTimeProp = new DateTimeProp();
            dateTimeProp.setName(taxItemDy.getString("id"));
            dateTimeProp.setAlias(taxItemDy.getString("name"));
            return dateTimeProp;
        }
        if (SitDataTypeEnum.BOOLEAN.getId() == dataTypeId.longValue()) {
            BooleanProp booleanProp = new BooleanProp();
            booleanProp.setName(taxItemDy.getString("id"));
            booleanProp.setAlias(taxItemDy.getString("name"));
            return booleanProp;
        }
        DecimalProp decimalProp = new DecimalProp();
        decimalProp.setName(taxItemDy.getString("id"));
        decimalProp.setAlias(taxItemDy.getString("name"));
        decimalProp.setScale(taxItemDy.getInt("currency.amtprecision"));
        return decimalProp;
    }

    private boolean validateTemplateIsNull(String key) {
        Object scene;
        if (key.equals("btncancel")) {
            return true;
        }
        FormShowParameter prams = this.getView().getFormShowParameter();
        Object taxGroup = prams.getCustomParam("taxgroup");
        DynamicObject template = TaxImportExportTmpDBHelper.queryOneTemplateForTaxImport((Object)taxGroup, (Object)(scene = prams.getCustomParam("scene")));
        if (null == template) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u914d\u7f6e\u5bf9\u5e94\u7684\u6a21\u677f\u3002", (String)"TaxImportTemplateUsingPlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    static {
        dataprecisionMap.put(1010L, 0);
        dataprecisionMap.put(1020L, 1);
        dataprecisionMap.put(1030L, 2);
        dataprecisionMap.put(1040L, 3);
        dataprecisionMap.put(1050L, 4);
        dataprecisionMap.put(1060L, 5);
        dataprecisionMap.put(1070L, 6);
        dataprecisionMap.put(1080L, 7);
        dataprecisionMap.put(1090L, 8);
        dataprecisionMap.put(1100L, 9);
        dataprecisionMap.put(1110L, 10);
    }
}

