/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.model.TaxDataPersonGroup;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.listener.TaxTaskGuideOpListenerFactory;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public abstract class TaxDataFeedBackAbstractClass
extends AssignMultiThreadTask<TaxDataPersonGroup> {
    private static final Log LOGGER = LogFactory.getLog(TaxDataFeedBackAbstractClass.class);
    protected IFormView view;
    protected TaxTaskEntity taxTaskEntity;
    protected TaxTaskGuideStepCaseInfo stepCaseInfo;
    protected TaxTaskGuideOpEnum opEnum;
    protected String title;
    protected String caption;
    protected DynamicObject taxTaskRecord;

    public abstract void handleTaxSrcData(List<Long> var1, Map<Long, String> var2, Map<Long, List<DynamicObject>> var3);

    public abstract String validateTaxData(DynamicObject var1);

    protected BaseResult<?> beforePrepareDataBatch() {
        BaseResult taxTaskRecord = TaxTaskGuideServiceHelper.createTaxTaskRecord((TaxTaskEntity)this.taxTaskEntity, (TaxTaskGuideStepCaseInfo)this.stepCaseInfo, (TaxTaskGuideOpEnum)this.opEnum, null);
        this.taxTaskRecord = (DynamicObject)taxTaskRecord.getData();
        return taxTaskRecord;
    }

    protected BatchResult<TaxDataPersonGroup> handleData(DataBatch<TaxDataPersonGroup> dataBatch) {
        List dataList = dataBatch.getDataList();
        BatchResult result = new BatchResult(true, new ArrayList(dataList));
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return result;
        }
        ArrayList<Long> taxFileIds = new ArrayList<Long>(dataList.size());
        HashMap<Long, TaxDataPersonGroup> taxFileDataMap = new HashMap<Long, TaxDataPersonGroup>(dataList.size());
        String msg = "";
        block0: for (TaxDataPersonGroup taxDataPersonGroup : result.successResult()) {
            List taxDataList = taxDataPersonGroup.getTaxDatas();
            if (CollectionUtils.isEmpty((Collection)taxDataList)) continue;
            msg = this.filterTaxData(taxDataList);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                result.successItemToFail((Object)taxDataPersonGroup, msg);
                continue;
            }
            Iterator iterator = taxDataList.iterator();
            while (iterator.hasNext()) {
                DynamicObject taxData = (DynamicObject)iterator.next();
                msg = this.validateTaxData(taxData);
                if (StringUtils.isEmpty((CharSequence)msg)) continue;
                result.successItemToFail((Object)taxDataPersonGroup, msg);
                continue block0;
            }
            Long l = taxDataPersonGroup.getTaxFileId();
            taxFileIds.add(l);
            taxFileDataMap.put(l, taxDataPersonGroup);
        }
        if (CollectionUtils.isEmpty((Collection)result.successResult())) {
            return result;
        }
        HashMap<Long, String> errorTaxFileIds = new HashMap<Long, String>(16);
        HashMap<Long, List<DynamicObject>> srcDataMap = new HashMap<Long, List<DynamicObject>>(taxFileIds.size());
        this.handleTaxSrcData(taxFileIds, errorTaxFileIds, srcDataMap);
        for (Map.Entry entry : errorTaxFileIds.entrySet()) {
            Long taxFileId = (Long)entry.getKey();
            String errorMsg = (String)entry.getValue();
            TaxDataPersonGroup taxDataPersonGroup = (TaxDataPersonGroup)taxFileDataMap.get(taxFileId);
            result.successItemToFail((Object)taxDataPersonGroup, errorMsg);
        }
        if (CollectionUtils.isEmpty((Collection)result.successResult())) {
            return result;
        }
        BatchResult<DynamicObject> taxDataResult = this.buildDynamicObjectResult(result.successResult());
        LOGGER.info("by cyh: TaxDataRollbackFeedbackTask begin saveTaxData");
        BatchResult batchResult = TaxDataServiceHelper.saveTaxData(taxDataResult, (TaxTaskEntity)this.taxTaskEntity, (TaxTaskGuideStepCaseInfo)this.stepCaseInfo, (DynamicObject)this.taxTaskRecord, srcDataMap, (boolean)true, (CustomFunction[])new CustomFunction[]{() -> {
            String opType = this.taxTaskRecord.getString("optype");
            if (TaxTaskGuideOpEnum.of((String)opType) != TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK) {
                return;
            }
            Long rawCalTaskId = (Long)GlobalParam.get((String)"feedbackRollback_rawCalTaskId");
            List successTaxDates = taxDataResult.successResult();
            ArrayList<Long> taxSrcDataBasicIds = new ArrayList<Long>(successTaxDates.size());
            for (DynamicObject taxData : successTaxDates) {
                List taxSrcDates = (List)srcDataMap.get(taxData.getLong("id"));
                for (DynamicObject srcData : taxSrcDates) {
                    if (rawCalTaskId != null && rawCalTaskId != 0L && srcData.getLong("taxdatabasic.rawcaltask.id") != rawCalTaskId.longValue()) continue;
                    taxSrcDataBasicIds.add(srcData.getLong("taxdatabasic.id"));
                }
            }
            HRBaseServiceHelper taxSrcDataHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
            DynamicObject[] taxSrcDataBasics = taxSrcDataHelper.loadDynamicObjectArray(taxSrcDataBasicIds.toArray());
            Arrays.stream(taxSrcDataBasics).forEach(data -> {
                data.set("srcstatus", null);
                data.set("caltaskgetdate", null);
            });
            taxSrcDataHelper.save(taxSrcDataBasics);
        }});
        this.packageResult(taxFileDataMap, (BatchResult<DynamicObject>)batchResult, (BatchResult<TaxDataPersonGroup>)result);
        return result;
    }

    protected String filterTaxData(List<DynamicObject> taxDataList) {
        return null;
    }

    protected BaseResult<TaxDataPersonGroup> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        TaxTaskGuideOpListenerFactory.afterOperation((BatchResult)this.finalResult, (DynamicObject)this.taxTaskRecord, (TaxTaskEntity)this.taxTaskEntity, (TaxTaskGuideStepCaseInfo)this.stepCaseInfo);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List> statusIdMap = new HashMap<Integer, List>(8);
        for (ResultItem item : failItemList) {
            long id = ((TaxDataPersonGroup)item.getData()).getTaxFileId();
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(e1.getTaxFileId()));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        this.processHandler.close(this.closeParams(status));
        return BaseResult.success(null);
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", this.title);
        this.processHandler.open(this.view, this.caption, cond);
        return this.processHandler;
    }

    public List<TaxDataPersonGroup> packageTaxData(List<DynamicObject> taxDatas) {
        HashMap<Long, List> taxFileDataMap = new HashMap<Long, List>(taxDatas.size());
        for (DynamicObject taxData : taxDatas) {
            List taxDataList = taxFileDataMap.computeIfAbsent(taxData.getLong("taxfile.id"), k1 -> new ArrayList(10));
            taxDataList.add(taxData);
        }
        ArrayList<TaxDataPersonGroup> dataList = new ArrayList<TaxDataPersonGroup>(taxFileDataMap.size());
        taxFileDataMap.entrySet().forEach(entry -> dataList.add(new TaxDataPersonGroup((Long)entry.getKey(), (List)entry.getValue())));
        return dataList;
    }

    private BatchResult<DynamicObject> buildDynamicObjectResult(List<TaxDataPersonGroup> successDatas) {
        ArrayList taxDatas = new ArrayList(successDatas.size());
        successDatas.forEach(obj -> taxDatas.addAll(obj.getTaxDatas()));
        BatchResult taxDataResult = new BatchResult(true, taxDatas);
        return taxDataResult;
    }

    private void packageResult(Map<Long, TaxDataPersonGroup> taxFileDataMap, BatchResult<DynamicObject> saveResult, BatchResult<TaxDataPersonGroup> finalResult) {
        List failResultOriginal = saveResult.getFailResultOriginal();
        HashMap<Long, StringBuilder> msgMap = new HashMap<Long, StringBuilder>(failResultOriginal.size());
        for (ResultItem resultItem : failResultOriginal) {
            long taxFileId = ((DynamicObject)resultItem.getData()).getLong("taxfile.id");
            StringBuilder msgBuilder = msgMap.computeIfAbsent(taxFileId, k1 -> new StringBuilder());
            msgBuilder.append(resultItem.getMessage()).append(';');
        }
        for (Map.Entry entry : msgMap.entrySet()) {
            finalResult.successItemToFail((Object)taxFileDataMap.get(entry.getKey()), ((StringBuilder)entry.getValue()).toString());
        }
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

