/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.common.model.TaxDataPersonGroup;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.task.TaxDataFeedBackAbstractClass;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.FeedbackResultEnum;

public class TaxDataFeedbackTask
extends TaxDataFeedBackAbstractClass {
    public TaxDataFeedbackTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = TaxTaskGuideOpEnum.FEEDBACK;
        this.title = ResManager.loadKDString((String)"\u6b63\u5728\u63a8\u9001\u7b97\u85aa", (String)"TaxDataFeedbackTask_0", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.caption = ResManager.loadKDString((String)"\u63a8\u9001\u7b97\u85aa", (String)"TaxDataFeedbackTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
    }

    protected List<TaxDataPersonGroup> queryData(String key, List<?> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", ids));
        TaxTaskGuideServiceHelper.packageBasicFiltersForData(qFilters, (TaxTaskEntity)this.taxTaskEntity);
        TaxTaskGuideServiceHelper.packageStatueFilter4Data((TaxTaskEntity)this.taxTaskEntity, (TaxTaskGuideStepCaseInfo)this.stepCaseInfo, qFilters);
        return this.packageTaxData(TaxTaskGuideServiceHelper.loadTaxData(qFilters));
    }

    @Override
    public void handleTaxSrcData(List<Long> taxFileIds, Map<Long, String> errorTaxFileIds, Map<Long, List<DynamicObject>> srcDataMap) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", taxFileIds));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, (TaxTaskEntity)this.taxTaskEntity, (Object[])new Object[0]);
        DynamicObject[] taxSrcDataArr = TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters, (String)"taxdata");
        HashMap map = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        HashMap errorTaxFileMap = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        HashMap errorFeedbackResultEnumMap = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        for (DynamicObject taxSrcData : taxSrcDataArr) {
            Long taxFileId = taxSrcData.getLong("taxfile.id");
            if (taxSrcData.getDynamicObject("taxcategory").getLong("taxpayertype.id") != taxSrcData.getDynamicObject("employment").getLong("taxpayertype.id")) continue;
            Set taxCategoryIds = (Set)map.get(taxFileId);
            if (Objects.nonNull(taxCategoryIds)) {
                taxCategoryIds.add(taxSrcData.getLong("taxcategory.id"));
                continue;
            }
            if (StringUtils.equals((CharSequence)taxSrcData.getString("feedbackoprecord.result"), (CharSequence)"1")) continue;
            FeedbackResultEnum feedbackResultEnum = this.validateTaxSrcData(taxSrcData);
            if (null != feedbackResultEnum) {
                HashSet categoryIds = Sets.newHashSetWithExpectedSize((int)taxSrcDataArr.length);
                map.put(taxFileId, categoryIds);
                categoryIds.add(taxSrcData.getLong("taxcategory.id"));
                errorTaxFileMap.put(taxFileId, taxSrcData.getDynamicObject("taxfile"));
                errorFeedbackResultEnumMap.put(taxFileId, feedbackResultEnum);
                continue;
            }
            List taxDates = srcDataMap.computeIfAbsent(taxSrcData.getLong("taxdata"), k1 -> new ArrayList(1));
            taxDates.add(taxSrcData);
        }
        if (map.size() == 0) {
            return;
        }
        this.setErrMsg(errorTaxFileIds, map, errorTaxFileMap, errorFeedbackResultEnumMap);
    }

    @Override
    protected String filterTaxData(List<DynamicObject> taxDataList) {
        if (CollectionUtils.isEmpty(taxDataList)) {
            return null;
        }
        ListIterator<DynamicObject> iterator = taxDataList.listIterator();
        DynamicObject taxData = null;
        while (iterator.hasNext()) {
            taxData = iterator.next();
            if (!StringUtils.equals((CharSequence)taxData.getString("feedbackoprecord.result"), (CharSequence)"1")) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(taxDataList) && taxData != null) {
            return FeedbackResultEnum.FEEDBACK_STATUS_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name")});
        }
        return null;
    }

    @Override
    public String validateTaxData(DynamicObject dynamicObject) {
        return "";
    }

    private FeedbackResultEnum validateTaxSrcData(DynamicObject dynamicObject) {
        if (!StringUtils.equals((CharSequence)dynamicObject.getString("refoprecord.result"), (CharSequence)"1")) {
            return FeedbackResultEnum.REF_STATUS_FAIL;
        }
        if (!StringUtils.equals((CharSequence)dynamicObject.getString("lockoprecord.result"), (CharSequence)"1")) {
            return FeedbackResultEnum.LOCK_STATUS_FAIL;
        }
        if (!StringUtils.equals((CharSequence)dynamicObject.getString("importoprecord.result"), (CharSequence)"1")) {
            return FeedbackResultEnum.DECLARE_STATUS_FAIL;
        }
        return null;
    }

    private void setErrMsg(Map<Long, String> errorTaxFileIds, Map<Long, Set<Long>> map, Map<Long, DynamicObject> errorTaxFileMap, Map<Long, FeedbackResultEnum> errorFeedbackResultEnumMap) {
        for (Map.Entry<Long, Set<Long>> entry : map.entrySet()) {
            Set<Long> value = entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            for (Long id : value) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('\u3001');
                }
                TaxCategoryEntity taxCategory = this.taxTaskEntity.getTaxCategory(id);
                String msg = ResManager.loadKDString((String)"\u201c{0}\u201d", (String)"TaxDataFeedbackTask_2", (String)"sit-itc-formplugin", (Object[])new Object[]{taxCategory.getIncomeItemLocaleString()});
                stringBuilder.append(msg);
            }
            FeedbackResultEnum feedbackResultEnum = errorFeedbackResultEnumMap.get(entry.getKey());
            DynamicObject taxFile = errorTaxFileMap.get(entry.getKey());
            if (null == feedbackResultEnum || null == taxFile) continue;
            errorTaxFileIds.put(entry.getKey(), feedbackResultEnum.loadKDString(new Object[]{taxFile.get("number"), taxFile.get("person.name"), stringBuilder.toString()}));
        }
    }
}

