/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.task;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.common.model.TaxDataPersonGroup;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.itc.formplugin.web.taskguide.task.TaxDataFeedBackAbstractClass;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.RollbackFeedbackResultEnum;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataRollbackFeedbackTask
extends TaxDataFeedBackAbstractClass {
    private static final Log LOGGER = LogFactory.getLog(TaxDataRollbackFeedbackTask.class);
    private static final Set<String> UN_PASS_SALARY_STATUS = ImmutableSet.of((Object)"1", (Object)"5", (Object)"13", (Object)"8", (Object)"18");
    private final Long rawCalTaskId;
    private final Map<Long, Set<Long>> fileAndTaxDataIdMap;
    private final String option;

    public TaxDataRollbackFeedbackTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long rawCalTaskId, String option, Map<Long, Set<Long>> fileAndTaxDataIdMap) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK;
        this.title = ResManager.loadKDString((String)"\u6b63\u5728\u64a4\u9500\u63a8\u9001\u7b97\u85aa", (String)"TaxDataRollbackFeedbackTask_0", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.caption = ResManager.loadKDString((String)"\u64a4\u9500\u63a8\u9001\u7b97\u85aa", (String)"TaxDataRollbackFeedbackTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.rawCalTaskId = rawCalTaskId;
        this.option = option;
        this.fileAndTaxDataIdMap = fileAndTaxDataIdMap;
    }

    protected List<TaxDataPersonGroup> queryData(String key, List<?> taxFileIds) {
        LOGGER.info("by cyh: TaxDataRollbackFeedbackTask begin queryData");
        HashSet taxDataIds = Sets.newHashSetWithExpectedSize((int)taxFileIds.size());
        if (!CollectionUtils.isEmpty(this.fileAndTaxDataIdMap)) {
            for (Object taxFileId : taxFileIds) {
                Set<Long> oneFileTaxDataIds = this.fileAndTaxDataIdMap.get(taxFileId);
                if (CollectionUtils.isEmpty(oneFileTaxDataIds)) continue;
                taxDataIds.addAll(oneFileTaxDataIds);
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "in", (Object)taxDataIds));
        return this.packageTaxData(TaxTaskGuideServiceHelper.loadTaxData(qFilters));
    }

    @Override
    public void handleTaxSrcData(List<Long> taxFileIds, Map<Long, String> errorTaxFileIds, Map<Long, List<DynamicObject>> srcDataMap) {
        LOGGER.info("by cyh: TaxDataRollbackFeedbackTask begin handleTaxSrcData");
        GlobalParam.set((String)"feedbackRollback_option", (Object)this.option);
        GlobalParam.set((String)"feedbackRollback_rawCalTaskId", (Object)this.rawCalTaskId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", taxFileIds));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, (TaxTaskEntity)this.taxTaskEntity, (Object[])new Object[0]);
        LOGGER.info("TaxDataRollbackFeedbackTask handleTaxSrcData qFilters: {}", (Object)((Object)qFilters).toString());
        DynamicObject[] taxSrcDataArr = TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters, (String)"taxfile.id,taxdata");
        HashMap taxSrcDataOfSrcDataKey = Maps.newHashMapWithExpectedSize((int)taxSrcDataArr.length);
        for (DynamicObject taxSrcData : taxSrcDataArr) {
            long calTaskId = taxSrcData.getLong("taxdatabasic.rawcaltask.id");
            Long taxFileId = taxSrcData.getLong("taxfile.id");
            List taxDates = srcDataMap.computeIfAbsent(taxSrcData.getLong("taxdata"), k1 -> new ArrayList(1));
            taxDates.add(taxSrcData);
            if (calTaskId != this.rawCalTaskId || errorTaxFileIds.containsKey(taxFileId)) continue;
            String msg = this.validateTaxSrcData(taxSrcData);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                errorTaxFileIds.put(taxFileId, msg);
                continue;
            }
            Long rawDataKey = (Long)BaseDataConverter.convert((Object)taxSrcData.getString("taxdatabasic.rawdatakey"), Long.class);
            taxSrcDataOfSrcDataKey.putIfAbsent(rawDataKey, taxSrcData);
        }
        if (taxSrcDataOfSrcDataKey.isEmpty()) {
            return;
        }
        Map statusResult = (Map)SITMServiceUtils.invokeSWCService((String)"hsas", (String)"ICalPersonService", (String)"getCalStatus", (Object[])new Object[]{Lists.newArrayList(taxSrcDataOfSrcDataKey.keySet())});
        boolean success = (Boolean)BaseDataConverter.convert(statusResult.get("success"), Boolean.class, (Object)Boolean.FALSE);
        if (!success) {
            String message = BaseDataConverter.toString(statusResult.get("message"));
            for (DynamicObject taxSrcData : taxSrcDataOfSrcDataKey.values()) {
                Long taxFileId = taxSrcData.getLong("taxfile.id");
                errorTaxFileIds.put(taxFileId, message);
            }
            return;
        }
        String message = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u5173\u8054\u7684\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\uff1a{0}{1}\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaxDataRollbackFeedbackTask_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        Map data = (Map)statusResult.get("data");
        for (Map.Entry entry : taxSrcDataOfSrcDataKey.entrySet()) {
            String calStatus;
            Map statusMap = (Map)data.get(entry.getKey());
            if (statusMap == null || !UN_PASS_SALARY_STATUS.contains(calStatus = BaseDataConverter.toString(statusMap.get("calStatus")))) continue;
            DynamicObject taxSrcData = (DynamicObject)entry.getValue();
            Long taxFileId = taxSrcData.getLong("taxfile.id");
            errorTaxFileIds.putIfAbsent(taxFileId, MessageFormat.format(message, taxSrcData.getString("taxdatabasic.rawcaltask.number"), taxSrcData.getString("taxdatabasic.rawcaltask.name")));
        }
    }

    @Override
    public String validateTaxData(DynamicObject taxData) {
        String msg = "";
        if (StringUtils.equals((CharSequence)"1", (CharSequence)taxData.getString("reportoprecord.result"))) {
            msg = RollbackFeedbackResultEnum.FEEDBACK_STATUS_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name"), taxData.get("taxcategory.name")});
            return msg;
        }
        return msg;
    }

    private String validateTaxSrcData(DynamicObject taxSrcData) {
        String msg = "";
        if (StringUtils.equals((CharSequence)taxSrcData.getString("reportoprecord.result"), (CharSequence)"1")) {
            msg = RollbackFeedbackResultEnum.REPORT_STATUS_FAIL.loadKDString(new Object[]{taxSrcData.get("taxfile.number"), taxSrcData.get("taxfile.person.name"), taxSrcData.get("taxcategory.name")});
            return msg;
        }
        if (SrcStatus.AUDITED.isLessEqThan(taxSrcData.getString("taxdatabasic.srcstatus"))) {
            msg = RollbackFeedbackResultEnum.SRCDATA_STATUS_FAIL.loadKDString(new Object[]{taxSrcData.get("taxfile.number"), taxSrcData.get("taxfile.person.name"), taxSrcData.get("taxcategory.name")});
            return msg;
        }
        if (!StringUtils.equals((CharSequence)taxSrcData.getString("lockoprecord.result"), (CharSequence)"1")) {
            msg = RollbackFeedbackResultEnum.LOCK_STATUS_FAIL.loadKDString(new Object[]{taxSrcData.get("taxfile.number"), taxSrcData.get("taxfile.person.name"), taxSrcData.get("taxcategory.name")});
            LOGGER.info("TaxDataRollbackFeedbackTask validateTaxSrcData LOCK_STATUS_FAIL : {}, taxSrcData.id= {}", (Object)taxSrcData.getLong("lockoprecord.id"), (Object)taxSrcData.getLong("id"));
            return msg;
        }
        if (!StringUtils.equals((CharSequence)taxSrcData.getString("feedbackoprecord.result"), (CharSequence)"1")) {
            msg = RollbackFeedbackResultEnum.FEEDBACK_STATUS_FAIL.loadKDString(new Object[]{taxSrcData.get("taxfile.number"), taxSrcData.get("taxfile.person.name"), taxSrcData.get("taxcategory.name")});
            return msg;
        }
        return msg;
    }
}

