/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.taskguide.task;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.export.AbstractExportTask;
import kd.sit.itc.business.taxfile.imports.TaxExportHelper;
import kd.sit.itc.business.taxtaskguide.task.AbstractTaxPersonDeclareAndReportExport;
import kd.sit.itc.formplugin.web.tax.TaxFileDeclarePlugin;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataItem;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxFileDeclareDownLoadTask
extends AbstractTaxPersonDeclareAndReportExport {
    private static final Log LOGGER = LogFactory.getLog(TaxFileDeclareDownLoadTask.class);
    private IFormView view;
    private IPageCache pageCache;
    private TaxTaskEntity taxTaskEntity;
    private int pageSize = 500;
    private DynamicObject exportTemplate;
    private QueryEntityType queryEntityType;
    private String exportFields;
    private Set<String> fixedFields = Sets.newHashSet((Object[])new String[]{"id", "taxfile.id", "taxfile.boid", "changetype", "personstatus"});
    private Map<String, DynamicProperty> dynamicPropertyMap;
    private String orderBy;
    private Map<String, List<Long>> basicIdMap = new HashMap<String, List<Long>>(16);
    private Object exportLogId;
    private int total;
    private Date declareMonth;
    private List<String> orderByStrs = Lists.newArrayListWithExpectedSize((int)10);
    private Map<String, WorkbookInfo> workbookInfoMap = new ConcurrentHashMap<String, WorkbookInfo>(16);
    private final String selectFields = "id,taxfile.taxunit.id,taxfile.taxunit.number,taxfile.taxunit.name";

    public TaxFileDeclareDownLoadTask(IFormView view, TaxTaskEntity taxTaskEntity) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.pageCache = view.getPageCache();
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        try {
            this.initCustomParams();
            this.initExportInfo();
        }
        catch (Exception e) {
            LOGGER.info("Error occurs when beforePrepareDataBatch data", (Object)e);
            this.setErrorMsg(e.getMessage());
            this.afterHandleDataBatch(-2);
        }
        return BaseResult.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> queryData(String key, int pageIndex, int pageSize) {
        if (!this.finalResult.isSuccess()) {
            return null;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(pageSize);
        List<Object> pageIds = new ArrayList(10);
        try (DataSet dataSet = null;){
            List<Long> basicIdList = this.basicIdMap.get(key);
            int listSize = basicIdList.size();
            int start = pageSize * pageIndex;
            int end = pageSize * (pageIndex + 1);
            end = Math.min(end, listSize);
            pageIds = basicIdList.subList(start, end);
            QFilter filter = new QFilter("id", "in", pageIds);
            HashMap queryStrMap = Maps.newHashMapWithExpectedSize((int)7);
            queryStrMap.put("taxdatabasic", Lists.newArrayListWithCapacity((int)50));
            String[] oldFieldNames = this.exportFields.split(",");
            HashMap newFieldNameToOldNameMap = Maps.newHashMapWithExpectedSize((int)oldFieldNames.length);
            this.initQueryStrMapAndNewFieldNameToOldNameMap(queryStrMap, newFieldNameToOldNameMap, oldFieldNames);
            QFilter[] qFilters = new QFilter[]{filter};
            dataSet = this.queryTaxDataBasicData(queryStrMap, qFilters, this.orderBy);
            HashMap entityQueryIdMap = Maps.newHashMapWithExpectedSize((int)queryStrMap.size());
            HashMap idsRelateMap = Maps.newHashMapWithExpectedSize((int)queryStrMap.size());
            this.initEntityQueryIdMapAndIdsRelateMap(queryStrMap, entityQueryIdMap, idsRelateMap, pageSize);
            LinkedHashMap taxFileIdToDataMap = Maps.newLinkedHashMapWithExpectedSize((int)pageSize);
            List taxDataBasicFieldList = (List)queryStrMap.get("taxdatabasic");
            this.initEntityQueryIdMapAndIdsRelateMapAndTaxFileIdToDataMap(dataSet, taxDataBasicFieldList, entityQueryIdMap, idsRelateMap, this.dynamicPropertyMap, taxFileIdToDataMap);
            CompletableFuture[] completableFutures = this.queryEntitiesData(entityQueryIdMap, queryStrMap, idsRelateMap, newFieldNameToOldNameMap, this.dynamicPropertyMap, taxFileIdToDataMap);
            CompletableFuture.allOf(completableFutures).join();
            taxFileIdToDataMap.values().forEach(v1 -> {
                Map value = (Map)v1;
                dataList.add(value);
            });
            GlobalParam.set((String)"taxFileIdList", basicIdList);
        }
        return dataList;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], task number is [{}], TaxFileDeclareDownLoadTask handleData begin, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        BatchResult result = new BatchResult(true, null);
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return result;
        }
        try {
            String dataKey = dataBatch.getDataKey();
            WorkbookInfo workbookInfo = this.getWorkbookInfo(dataKey);
            ExportResult exportResult = new ExportResult(Integer.valueOf(dataList.size()));
            ExcelHelper.writeData((WorkbookInfo)workbookInfo, dataBatch, (ExportResult)exportResult);
            String message = exportResult.generateMessage(255);
            if (!StringUtils.isEmpty((CharSequence)message)) {
                throw new KDBizException("error in writeData : " + message);
            }
            if (StringUtils.equals((CharSequence)this.pageCache.get("isMark"), (CharSequence)"1")) {
                this.markTaxFile(dataList);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when handleData data", (Throwable)e);
            String message = e.getMessage();
            dataList.forEach(obj -> result.addFailItem(obj, (String)obj.get("number") + (String)obj.get("person.name") + message));
            return result;
        }
        LOGGER.info("2---thread is [{}], task number is [{}], TaxFileDeclareDownLoadTask handleData finish, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        stopwatch.stop();
        return result.addSuccessResult(dataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        LOGGER.info("6---thread is [{}], TaxFileDeclareDownLoadTask finish, time is [{}]", (Object)Thread.currentThread().getName(), (Object)System.currentTimeMillis());
        String url = "";
        try {
            if (this.finalResult.isSuccess() && !CollectionUtils.isEmpty(this.workbookInfoMap)) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                LOGGER.info("1---thread is [{}], task number is [{}], TaxFileDeclareDownLoadTask afterHandleDataBatch begin, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                url = this.storeData();
                LOGGER.info("2---thread is [{}], task number is [{}], TaxFileDeclareDownLoadTask afterHandleDataBatch finish, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                stopwatch.stop();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when afterHandleDataBatch data", (Object)e.getMessage());
            this.setErrorMsg(e.getMessage());
        }
        finally {
            LOGGER.info(" Export end\uff1atotalSize = {}, dealNum = {} ; ", (Object)this.total, (Object)this.dealNum());
            this.closeProcess(url, status);
        }
        return BaseResult.success(null);
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u4eba\u5458\u62a5\u9001\u8868\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaxFileDeclareDownLoadTask_0", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        cond.put("closeCallBack", new CloseCallBack(TaxFileDeclarePlugin.class.getName(), "afterExportDeclareDone"));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaxFileDeclareDownLoadTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "refresh");
        return result;
    }

    private void initCustomParams() {
        this.declareMonth = this.taxTaskEntity.getTaxPeriodEntity().getPeriodDate();
        if (this.declareMonth == null) {
            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u671f\u95f4\u4fe1\u606f\u4e3a\u7a7a", (String)"TaxFileDeclareDownLoadTask_6", (String)"sit-itc-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String entityName = ResManager.loadKDString((String)"\u4eba\u5458\u62a5\u9001\u8868", (String)"TaxFileDeclarePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        this.exportLogId = ExportLogHelper.create((Object)AbstractExportTask.getCacheKey((String)entityName, (String)new Date().toString()), (String)entityName, (int)this.total, (String)"3");
    }

    private void closeProcess(String url, int status) {
        LOGGER.info("TaxFileDeclareDownLoadTask closeProcess url {}", (Object)url);
        this.pageCache.put("url", url);
        this.pageCache.put("export_result", SerializationUtils.serializeToBase64((Object)this.transferResult(this.finalResult)));
        this.pageCache.saveChanges();
        LOGGER.info("TaxFileDeclareDownLoadTask closeProcess pageCache {}", (Object)this.pageCache.get("url"));
        this.processHandler.close(this.closeParams(status));
        AbstractExportTask.logAll((Object)this.exportLogId, (String)url, (String)this.finalResult.getMessage(), (int)((int)this.dealNum()));
        LOGGER.info("TaxFileDeclareDownLoadTask closeProcess logAll exportLogId {} ; finalResult {} ", this.exportLogId, (Object)this.finalResult.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkbookInfo getWorkbookInfo(String dataKey) {
        WorkbookInfo workbookInfo;
        DataItem dataItem;
        DataItem dataItem2 = dataItem = (DataItem)this.dataItemMap.get(dataKey);
        synchronized (dataItem2) {
            workbookInfo = this.workbookInfoMap.get(dataKey);
            if (workbookInfo == null) {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("name", dataKey);
                param.put("template", this.exportTemplate);
                param.put("dyn_property", this.dynamicPropertyMap);
                workbookInfo = WorkbookInfoGenerator.generateWith((String)"sitPersonDeclareExport", param);
                this.workbookInfoMap.put(dataKey, workbookInfo);
            }
        }
        return workbookInfo;
    }

    private void initExportInfo() {
        this.exportTemplate = this.getExportTemplate();
        this.exportFields = this.getExportFields(this.exportTemplate);
        this.queryEntityType = this.getQueryEntityType();
        this.dynamicPropertyMap = TaxExportHelper.getDynamicPropertyMap((QueryEntityType)this.queryEntityType, (String)this.exportFields);
    }

    private QueryEntityType getQueryEntityType() {
        this.queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxfiledeclarequery");
        if (this.queryEntityType == null) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u914d\u7f6e\u5df2\u88ab\u5220\u9664\uff1a%s", (String)"TaxFileDeclareDownLoadTask_3", (String)"sit-itc-formplugin", (Object[])new Object[0]), "itc_taxfiledeclarequery");
            throw new KDBizException(msg);
        }
        return this.queryEntityType;
    }

    private String getExportFields(DynamicObject exportTemplate) {
        Set exportFieldSet = TaxExportHelper.parseExportFields((DynamicObject)exportTemplate);
        if (CollectionUtils.isEmpty((Collection)exportFieldSet)) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6a21\u677f\u201c%s\u201d\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\u518d\u8bd5\u3002", (String)"TaxFileDeclareDownLoadTask_5", (String)"sit-itc-formplugin", (Object[])new Object[0]), exportTemplate.getString("name"));
            throw new KDBizException(msg);
        }
        this.fixedFields.forEach(obj -> exportFieldSet.add(obj));
        StringBuilder builder = new StringBuilder();
        exportFieldSet.forEach(obj -> builder.append((String)obj).append(','));
        this.exportFields = builder.toString().substring(0, builder.length() - 1);
        return this.exportFields;
    }

    private DynamicObject getExportTemplate() {
        Long templateId = this.getTemplateId();
        this.exportTemplate = TaxExportHelper.queryExportTemplate((Long)templateId);
        if (this.exportTemplate == null) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff1a%s", (String)"TaxFileDeclareDownLoadTask_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), templateId);
            throw new KDBizException(msg);
        }
        return this.exportTemplate;
    }

    private Map<String, List<Long>> queryTaxUnitInfo(List<QFilter> filters, String orderBy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] basicDyns = serviceHelper.query("id,taxfile.taxunit.id,taxfile.taxunit.number,taxfile.taxunit.name", filters.toArray(new QFilter[filters.size()]), orderBy);
        HashMap<String, List<Long>> taxUnitMap = new HashMap<String, List<Long>>(16);
        this.total = basicDyns.length;
        for (DynamicObject basicDyn : basicDyns) {
            String taxUnit = basicDyn.getString("taxfile.taxunit.name");
            List taxFileIds = taxUnitMap.computeIfAbsent(taxUnit, k1 -> new ArrayList(10));
            taxFileIds.add(basicDyn.getLong("id"));
        }
        return taxUnitMap;
    }

    private List<QFilter> getDataQfilter(FilterParameter para) {
        List qFilters;
        Boolean isExportAll = this.getIsExportAll();
        if (isExportAll.booleanValue()) {
            qFilters = para.getQFilters();
        } else {
            List<Long> selectIds = this.getSelectIds();
            qFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", selectIds)});
        }
        return qFilters;
    }

    public Boolean getIsExportAll() {
        String isExportAll = this.pageCache.get("isExportALL");
        return isExportAll == null ? null : Boolean.valueOf(isExportAll);
    }

    public List<Long> getSelectIds() {
        String selectIds = this.pageCache.get("selectIds");
        return selectIds == null ? null : (List)SerializationUtils.deSerializeFromBase64((String)selectIds);
    }

    public Long getTemplateId() {
        String templateId = this.pageCache.get("template");
        return templateId == null ? 0L : Long.parseLong(templateId);
    }

    private String getZipName() {
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f_%s.zip", (String)"TaxFileDeclareDownLoadTask_4", (String)"sit-itc-formplugin", (Object[])new Object[0]), date);
        return fileName;
    }

    private void setErrorMsg(String message) {
        this.finalResult.setSuccess(false);
        String oldMessage = this.finalResult.getMessage();
        if (StringUtils.isEmpty((CharSequence)oldMessage)) {
            this.finalResult.setMessage(message);
        } else {
            this.finalResult.setMessage(oldMessage + " ; " + message);
        }
    }

    private String storeData() {
        String url = "";
        HashMap wbMap = Maps.newHashMapWithExpectedSize((int)this.workbookInfoMap.size());
        for (Map.Entry<String, WorkbookInfo> entry : this.workbookInfoMap.entrySet()) {
            WorkbookInfo workbookInfo = entry.getValue();
            Workbook workbook = workbookInfo.getWorkbook();
            if (workbook == null) continue;
            wbMap.put(workbookInfo.fullName(), workbook);
        }
        if (wbMap.size() == 1) {
            for (Map.Entry<String, Object> entry : wbMap.entrySet()) {
                url = ExcelHelper.storeFile((Workbook)((Workbook)entry.getValue()), (String)entry.getKey());
            }
        } else {
            url = ExcelHelper.storeZipFile((Map)wbMap, (String)this.getZipName());
        }
        return url;
    }

    private void markTaxFile(List<Map<String, Object>> dataList) {
        ArrayList fileIds = new ArrayList(dataList.size());
        ArrayList<Long> basicIds = new ArrayList<Long>(dataList.size());
        dataList.forEach(obj -> {
            fileIds.add(Long.parseLong((String)obj.get("taxfile.id")));
            fileIds.add((Long)obj.get("taxfile.boid"));
            basicIds.add(Long.parseLong((String)obj.get("id")));
        });
        TXHandle txHandle = null;
        boolean success = true;
        try {
            txHandle = TX.required();
            this.updateBasicDeclare(basicIds);
            this.updateDeclareInfo(dataList, basicIds);
        }
        catch (Exception e) {
            success = false;
            throw new KDBizException("error in markTaxFile : " + e);
        }
        finally {
            if (!success && txHandle != null) {
                txHandle.markRollback();
            }
            if (txHandle != null) {
                txHandle.close();
            }
        }
    }

    private void updateBasicDeclare(List<Long> basicIds) {
        DynamicObject[] dynamicObjects;
        long creator = RequestContext.get().getCurrUserId();
        Date operateDate = new Date();
        QFilter filter = new QFilter("id", "in", basicIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        for (DynamicObject data : dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter})) {
            data.set("declarestatus", (Object)"1");
            data.set("modifytime", (Object)operateDate);
            data.set("modifier", (Object)creator);
        }
        serviceHelper.save(dynamicObjects);
    }

    private void updateDeclareInfo(List<Map<String, Object>> dataList, List<Long> basicIds) {
        long creator = RequestContext.get().getCurrUserId();
        Date operateDate = new Date();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        String fileds = "changetype,declaremonth,declarestatus,declareway,personstatus,taxdatabasicid,modifytime,modifier";
        DynamicObject[] existDeclareInfos = serviceHelper.query(fileds, new QFilter[]{new QFilter("taxdatabasicid", "in", basicIds)});
        Map<String, DynamicObject> existDeclareInfoMap = Arrays.stream(existDeclareInfos).collect(Collectors.toMap(obj -> obj.getString("taxdatabasicid.id"), obj -> obj));
        ArrayList newDeclareInfos = Lists.newArrayListWithCapacity((int)dataList.size());
        ArrayList updateDeclareInfos = Lists.newArrayListWithCapacity((int)existDeclareInfoMap.size());
        for (Map<String, Object> basicData : dataList) {
            String basicId = (String)basicData.get("id");
            DynamicObject declareInfo = existDeclareInfoMap.get(basicId);
            if (declareInfo == null) {
                declareInfo = serviceHelper.generateEmptyDynamicObject();
                DynamicObject file = serviceHelper.generateEmptyDynamicObject("itc_taxfile");
                file.set("id", basicData.get("taxfile.boid"));
                declareInfo.set("taxfile", (Object)file);
                declareInfo.set("taxdatabasicid", (Object)basicId);
                declareInfo.set("creator", (Object)creator);
                newDeclareInfos.add(declareInfo);
            } else {
                declareInfo.set("modifytime", (Object)operateDate);
                declareInfo.set("modifier", (Object)creator);
                updateDeclareInfos.add(declareInfo);
            }
            declareInfo.set("changetype", basicData.get("changetype_v"));
            declareInfo.set("declaremonth", (Object)this.declareMonth);
            declareInfo.set("declarestatus", (Object)"1");
            declareInfo.set("declareway", (Object)"0");
            declareInfo.set("personstatus", basicData.get("personstatus_v"));
        }
        if (!CollectionUtils.isEmpty((Collection)updateDeclareInfos)) {
            serviceHelper.save(updateDeclareInfos.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)newDeclareInfos)) {
            serviceHelper.save(newDeclareInfos.toArray(new DynamicObject[0]));
        }
    }

    public void preparedataItem() {
        BillList billList = (BillList)this.view.getControl("billlistap");
        FilterParameter para = billList.generalFilterParameter();
        this.orderBy = TaxExportHelper.getBillListOrderBy((IFormView)this.view, (BillList)billList);
        List<QFilter> filters = this.getDataQfilter(para);
        this.basicIdMap = this.queryTaxUnitInfo(filters, this.orderBy);
        for (Map.Entry<String, List<Long>> entry : this.basicIdMap.entrySet()) {
            List<Long> taxFileIds = entry.getValue();
            this.addData(entry.getKey(), taxFileIds.size(), this.pageSize, 1);
        }
        this.resolveOrderBy(this.orderByStrs, this.orderBy);
    }

    protected void resolveOrderBy(List<String> taxDataBasicFieldList, String orderBys) {
        String[] strings;
        if (StringUtils.isEmpty((CharSequence)orderBys)) {
            return;
        }
        for (String string : strings = orderBys.split("\\,")) {
            int index = string.indexOf(" ");
            String newField = string.substring(0, index);
            if (taxDataBasicFieldList.contains(newField)) continue;
            taxDataBasicFieldList.add(newField);
        }
    }
}

