/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.business.taxtaskguide.task.SitLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class AbstractTaxFileBasePlugin
extends HRDataBaseEdit {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advtoolbar"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String status = this.getModel().getDataEntity().getString("status");
        Object isOnlyView = this.getView().getFormShowParameter().getCustomParam("isOnlyView");
        if ("B".equals(status) || "true".equals(isOnlyView)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advbar_delete"});
        }
    }

    public void beforeBindData(EventObject eventObject) {
        MainEntityType dataEntityType;
        DataEntityPropertyCollection properties;
        Long taxFileId;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && null != (taxFileId = (Long)BaseDataConverter.convert((Object)parentView.getFormShowParameter().getCustomParam("taxfileboid"), Long.class)) && (properties = (dataEntityType = this.getModel().getDataEntityType()).getProperties()).containsKey((Object)"taxfile")) {
            this.getModel().setValue("taxfile", (Object)taxFileId);
        }
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!this.getModel().getDataChanged() && !"advbar_delete".equals(itemKey)) {
            return;
        }
        long pkId = this.getModel().getDataEntity().getLong("id");
        switch (itemKey) {
            case "advbar_cancel": {
                if (pkId != 0L) {
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.insertNullPage();
                break;
            }
            case "advbar_cancelafteraudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter statusFilter;
        long id;
        QFilter filter;
        HRBaseServiceHelper helper;
        DynamicObject[] dys;
        String formId;
        long taxFileId;
        FormShowParameter showParameter;
        IFormView parentView;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (("saveafteraudit".equals(opKey) || "save".equals(opKey)) && "itc_taxbase".equals((parentView = this.getView().getParentView()).getFormShowParameter().getFormId())) {
            showParameter = parentView.getFormShowParameter();
            taxFileId = (Long)showParameter.getCustomParam("taxfileid");
            formOperate.getOption().setVariableValue("relateFileKeyInfo", "{\"" + taxFileId + "\":" + parentView.getPageCache().get("relateFileKeyInfo") + "}");
        }
        if ("modifyafteraudit".equals(opKey) && "itc_taxbase".equals((parentView = this.getView().getParentView()).getFormShowParameter().getFormId()) && StringUtils.isNotEmpty((CharSequence)(formId = this.getView().getFormShowParameter().getFormId())) && (null == (dys = (helper = new HRBaseServiceHelper(formId)).query("id,status,taxfile.pernontsprop.nationality", new QFilter[]{filter = new QFilter("id", "=", (Object)(id = this.getModel().getDataEntity().getLong("id"))), statusFilter = new QFilter("status", "!=", (Object)"E")})) || 0 == dys.length)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4fe1\u606f\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTaxFileBasePlugin_3", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        }
        if ("clear_donothing".equals(opKey) && !args.isCancel()) {
            String formId2;
            parentView = this.getView().getParentView();
            showParameter = parentView.getFormShowParameter();
            taxFileId = (Long)showParameter.getCustomParam("taxfileid");
            if ("itc_taxbase".equals(parentView.getFormShowParameter().getFormId()) && StringUtils.isNotEmpty((CharSequence)(formId2 = this.getView().getFormShowParameter().getFormId()))) {
                BaseResult result = TaxFileServiceHelper.muTextLock((Long)taxFileId, (String)formId2);
                if (result.isSuccess()) {
                    MutexLockInfo lockInfo = (MutexLockInfo)result.getData();
                    TaxFileServiceHelper.showMutexNotification((IFormView)this.getView(), (MutexLockInfo)lockInfo);
                    args.setCancel(true);
                } else {
                    this.confirmClear();
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String opKey = formOperate.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && !result.isSuccess()) {
            return;
        }
        if (("saveafteraudit".equals(opKey) || "save".equals(opKey)) && "itc_taxbase".equals((parentView = this.getView().getParentView()).getFormShowParameter().getFormId())) {
            FormShowParameter showParameter = parentView.getFormShowParameter();
            long taxFileId = (Long)showParameter.getCustomParam("taxfileid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(showParameter.getCustomParam("appId") + "_taxfile");
            DynamicObject taxFile = serviceHelper.loadSingle((Object)taxFileId);
            TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber((String)this.getModel().getDataEntityType().getName());
            Map map = infoService.findKeyInfoByFileBoId(taxFile);
            Map relateFileKeyInfo = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("relateFileKeyInfo"), Map.class);
            for (Map.Entry entry : map.entrySet()) {
                relateFileKeyInfo.put(infoService.fullPropKey((String)entry.getKey()), entry.getValue());
            }
            Map relateIds = (Map)relateFileKeyInfo.get("relateIds");
            if (!CollectionUtils.isEmpty((Map)relateIds) && null != relateIds.get(formOperate.getEntityId()) && !CollectionUtils.isEmpty((Map)map)) {
                relateIds.put(formOperate.getEntityId(), map.get("id"));
            }
            TaxFileInfoServiceFactory.decorateFormShowParameter((FormShowParameter)showParameter, (DynamicObject)taxFile, (Map)relateFileKeyInfo);
            parentView.cacheFormShowParameter();
            parentView.getPageCache().put("relateFileKeyInfo", SerializationUtils.toJsonString((Object)relateFileKeyInfo));
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            Object id = map.get("id");
            if (id == null || Long.valueOf(0L).equals(id)) {
                this.insertNullPage();
            } else {
                baseShowParameter.setPkId(id);
                baseShowParameter.setStatus(OperationStatus.VIEW);
                BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
                baseShowParameter.setFormId(parameter.getFormId());
                baseShowParameter.setOpenStyle(parameter.getOpenStyle());
                baseShowParameter.setCustomParams(parameter.getCustomParams());
                parentView.showForm((FormShowParameter)baseShowParameter);
                this.getView().sendFormAction(parentView);
            }
        }
        this.releaseMutex(opKey);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (callBackId.equals("deleteConfirm") && evt.getResult() == MessageBoxResult.Yes) {
            String entityId = this.getView().getEntityId();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
            String displayName = mainEntityType.getDisplayName().getLocaleValue();
            if (kd.bos.util.StringUtils.isEmpty((String)entityId)) {
                return;
            }
            boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)mainEntityType.getName(), (String)"4715a0df000000ac");
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201d{0}\u201c\u7684\u201d\u4fee\u6539\u201c\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"TaxFileSubInfoList_4", (String)"sit-itc-formplugin", (Object[])new Object[]{displayName}));
                return;
            }
            this.deleteTaxFileSubInfo();
        }
    }

    private void releaseMutex(String opKey) {
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        String pkId = this.getModel().getDataEntity().getString("id");
        if ("saveafteraudit".equals(opKey)) {
            MutexServiceHelper.release((String)name, (String)pkId, (String)"modifyafteraudit");
        } else if ("save".equals(opKey)) {
            MutexServiceHelper.release((String)name, (String)pkId, (String)"edit");
        } else if ("refresh".equals(opKey)) {
            MutexServiceHelper.release((String)name, (String)pkId, (String)"modifyafteraudit");
            MutexServiceHelper.release((String)name, (String)pkId, (String)"edit");
        }
    }

    protected <T> T getKeyInfo(String pageNum, String key, Class<T> clazz) {
        if (key.equals(".id")) {
            key = key.substring(0, key.length() - 3);
        }
        String fullKey = StringUtils.isEmpty((CharSequence)pageNum) ? key : pageNum + "." + key;
        HashMap cast = (HashMap)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("relateFileKeyInfo"), HashMap.class);
        return (T)BaseDataConverter.convert(cast.get(fullKey), clazz);
    }

    private void insertNullPage() {
        FormShowParameter showParameter = new FormShowParameter();
        String pageKey = (String)this.getView().getFormShowParameter().getCustomParam("pageKey");
        String pageNumber = (String)this.getView().getFormShowParameter().getCustomParam("pageNumber");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(pageKey);
        showParameter.setFormId("sitbp_nullpage");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("pageNumber", pageNumber);
        showParameter.setCustomParams(customParams);
        IFormView parentView = this.getView().getParentView();
        parentView.showForm(showParameter);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("collapsible", Boolean.TRUE);
        parentView.updateControlMetadata(pageKey, map);
        this.getView().sendFormAction(parentView);
    }

    private void confirmClear() {
        String entityId = this.getView().getEntityId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        String displayName = mainEntityType.getDisplayName().getLocaleValue();
        if (kd.bos.util.StringUtils.isEmpty((String)entityId)) {
            return;
        }
        boolean hasPerm = SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)mainEntityType.getName(), (String)"4715a0df000000ac");
        if (!hasPerm) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u201c{0}\u201d\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxFileSubInfoList_2", (String)"sit-itc-formplugin", (Object[])new Object[]{displayName});
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("deleteConfirm", (IFormPlugin)this));
    }

    private void deleteTaxFileSubInfo() {
        String entityId = this.getView().getEntityId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        String displayName = mainEntityType.getDisplayName().getLocaleValue();
        long taxFileId = this.getModel().getDataEntity().getLong("taxfile.id");
        BaseResult baseResult = TaxFileServiceHelper.deleteTaxFileSubInfo((Long)taxFileId, (String)entityId, (String)displayName);
        this.getView().getPageCache().put("hasdata", null);
        String number = this.getModel().getDataEntity().getDynamicObject("taxfile").getString("number");
        if (!baseResult.isSuccess()) {
            SitLogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6e05\u7a7a", (String)"AbstractTaxFileBasePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"{0}\uff0c{1}\u6e05\u7a7a\u5931\u8d25\u3002", (String)"AbstractTaxFileBasePlugin_5", (String)"sit-itc-formplugin", (Object[])new Object[]{number, displayName}));
            this.getView().showErrorNotification(baseResult.getMessage());
        } else {
            SitLogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6e05\u7a7a", (String)"AbstractTaxFileBasePlugin_4", (String)"sit-itc-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"{0}\uff0c{1}\u6e05\u7a7a\u6210\u529f\u3002", (String)"AbstractTaxFileBasePlugin_6", (String)"sit-itc-formplugin", (Object[])new Object[]{number, displayName}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxFileSubInfoList_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
            this.insertNullPage();
        }
    }
}

