/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.formplugin.web.tax.AbstractTaxFileBasePlugin;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class BankCardEdit
extends AbstractTaxFileBasePlugin {
    private static final String USER_NAME = "username";
    private static final String BANK_CALLBACK = "bank_callback";
    private static final String HRPI_PERBANKCARD = "hrpi_perbankcard";
    private static final String BANK_CARD_F7 = "sitbs_perbankcardf7";
    private static final String PERBANKCARDVID = "perbankcardvid";
    private static String PROVINCENAME = "provincename";
    private static String PERBANKCARD = "perbankcard";
    private static String TAXFILEID = "taxfileid";

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{USER_NAME});
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        IDataModel model;
        super.beforeBindData(eventObject);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (viewStatus.equals((Object)OperationStatus.VIEW)) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (map != null && map.get(TAXFILEID) != null) {
                QFilter filter;
                Object taxDataBasic = map.get("taxDataBasicId");
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_bankcard");
                Map relateFileIds = (Map)map.get("relateFileIds");
                if (null != taxDataBasic && null != relateFileIds && null != relateFileIds.get("itc_bankcard") && (Long)BaseDataConverter.convert(relateFileIds.get("itc_bankcard"), Long.class) > 0L) {
                    filter = new QFilter("id", "=", relateFileIds.get("itc_bankcard"));
                } else {
                    filter = new QFilter("taxfile", "=", BaseDataConverter.convert(map.get("taxfileboid"), Long.class));
                    filter.and("iscurrentversion", "=", (Object)"1");
                }
                DynamicObject[] dynamicObjects = serviceHelper.query("id,taxfile,perbankcard", new QFilter[]{filter}, "createtime");
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    long perbankcard = dynamicObjects[0].getLong("perbankcard.id");
                    this.queryBankInfoAndInit(perbankcard);
                }
            }
        } else if (viewStatus.equals((Object)OperationStatus.ADDNEW) && (model = this.getView().getModel()).getValue("perbankcard") != null) {
            DynamicObject dynamicObject = (DynamicObject)model.getValue("perbankcard");
            this.queryBankInfoAndInit(dynamicObject.getLong("id"));
            this.getModel().setDataChanged(false);
        }
    }

    private void queryBankInfoAndInit(long perbankcard) {
        if (perbankcard == 0L) {
            return;
        }
        HRBaseServiceHelper shelper = new HRBaseServiceHelper(HRPI_PERBANKCARD);
        DynamicObject query = shelper.queryOne("id,boid,username,bankdeposit,bankdeposit.province,bankdeposit.province.name, sourcevid", new QFilter[]{new QFilter("id", "=", (Object)perbankcard)});
        Object name = query.get("bankdeposit.province.name");
        String username = query.getString(USER_NAME);
        IDataModel model = this.getView().getModel();
        model.setValue(PROVINCENAME, (Object)(name == null ? "" : ((OrmLocaleValue)name).getLocaleValue()));
        model.setValue(PERBANKCARD, (Object)perbankcard);
        model.setValue(USER_NAME, (Object)(username == null ? "" : username));
        model.setValue(PERBANKCARDVID, (Object)query.getLong("sourcevid"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control conl = (Control)evt.getSource();
        if (USER_NAME.equals(conl.getKey())) {
            this.openList();
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String name;
        IDataEntityProperty property = ex.getProperty();
        switch (name = property.getName()) {
            case "username": {
                String username = (String)this.getModel().getValue(USER_NAME);
                if (!StringUtils.isBlank((CharSequence)username)) break;
                this.getModel().setValue(PERBANKCARD, null);
                this.getModel().setValue(PERBANKCARDVID, null);
                this.getModel().setValue(PROVINCENAME, null);
                this.getView().updateView();
                break;
            }
        }
    }

    private void openList() {
        ListShowParameter lisShowParameter = ShowFormHelper.createShowListForm((String)BANK_CARD_F7, (boolean)false, (int)2);
        lisShowParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u5361", (String)"BankCardEdit_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        lisShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BANK_CALLBACK));
        List filters = lisShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("isdelete", "=", (Object)"0"));
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map != null && map.get("personid") != null) {
            filters.add(new QFilter("person.id", "=", (Object)Long.valueOf((String)map.get("personid"))));
        }
        this.getView().showForm((FormShowParameter)lisShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "bank_callback": {
                this.setBankCardParam(closedCallBackEvent);
            }
        }
    }

    private void setBankCardParam(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnDataCollection != null && returnDataCollection.size() > 0) {
            long perbankcardId = (Long)returnDataCollection.get(0).getPrimaryKeyValue();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(HRPI_PERBANKCARD);
            QFilter qFilter = new QFilter("id", "=", (Object)perbankcardId);
            DynamicObject obj = helper.queryOne("id,boid,username,bankdeposit,bankdeposit.province,bankdeposit.province.name,sourcevid", qFilter);
            IDataModel model = this.getView().getModel();
            Object name = obj.get("bankdeposit.province.name");
            String username = obj.getString(USER_NAME);
            model.setValue(PERBANKCARD, (Object)perbankcardId);
            model.setValue(PERBANKCARDVID, (Object)obj.getLong("sourcevid"));
            model.setValue(PROVINCENAME, (Object)(name == null ? "" : ((OrmLocaleValue)name).getLocaleValue()));
            model.setValue(USER_NAME, (Object)(username == null ? "" : username));
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (map != null && map.get(TAXFILEID) != null) {
                model.setValue("taxfile", map.get(TAXFILEID));
            }
        }
        this.getView().updateView();
    }
}

