/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.formplugin.web.tax;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class BankCardList
extends HRDataBaseList {
    private static final String HRPI_PERBANKCARD = "hrpi_perbankcard";
    public static final String BILL_LIST_AP = "billlistap";
    private static final String BANK_PROVINCE_NANE = "provincename";
    private Map<Long, DynamicObject> depositMap;

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map != null && map.get("taxfileid") != null) {
            QFilter filter = new QFilter("taxfile_id", "=", BaseDataConverter.convert(map.get("taxfileid"), Long.class));
            setFilterEvent.getQFilters().add(filter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DataProviderImpl());
    }

    public void packageData(PackageDataEvent event) {
        Long perbankcardid;
        DynamicObject rowData = event.getRowData();
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        if (this.depositMap != null && BANK_PROVINCE_NANE.equals(columnDesc.getFieldKey()) && (perbankcardid = Long.valueOf(rowData.getLong("perbankcard.id"))) != null && this.depositMap.get(perbankcardid) != null) {
            Object name = this.depositMap.get(perbankcardid).get("bankdeposit.province.name");
            event.setFormatValue((Object)(name == null ? "" : ((OrmLocaleValue)name).getLocaleValue()));
        }
    }

    private class DataProviderImpl
    extends ListDataProvider {
        private DataProviderImpl() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            List listFields = this.getListFields();
            LinkedHashSet keySet = Sets.newLinkedHashSetWithExpectedSize((int)listFields.size());
            listFields.forEach(e1 -> {
                String listFieldKey = e1.getListFieldKey();
                keySet.add(listFieldKey);
            });
            List despositIds = data.stream().filter(e1 -> e1.getDataEntityType().getProperties().containsKey((Object)"perbankcard.id") || e1.getDataEntityType().getProperties().containsKey((Object)"perbankcard_id")).map(dy -> dy.getLong("perbankcard.id")).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BankCardList.HRPI_PERBANKCARD);
            DynamicObject[] query = serviceHelper.query("id,bankdeposit.province.name", new QFilter[]{new QFilter("id", "in", despositIds)});
            BankCardList.this.depositMap = Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
            return data;
        }
    }
}

